package edu.masi.hyperadvisor.structures;
import java.util.ArrayList;

/**
 * The class Algo.
 * Represents information about a single instance of an algorithm.
 * @author covingkj
 *
 */
public class Algo {
	public String algName;
	
	public int usedMem, allocMem; 
	public int usedTime, allocTime;
	public ArrayList<ArrayList<String>> inputs;
	public ArrayList<String> classes;
	
	/**
	 * Default constructor. Initializes all Algo members.
	 */
	protected Algo(){
		algName 	= "";
		inputs 		= new ArrayList<ArrayList<String>>();
		classes 	= new ArrayList<String>();
		usedMem 	= 0;
		usedTime 	= 0;
		allocMem 	= 0;
		allocTime	= 0;
	}
		
	//This is the information for the new algorithm
	/**
	 * Constructor that should be used
	 * Populates the array name variable
	 * Populates the inputs variable with the in parameters array
	 * Populates resource variables from the output array
	 * 
	 * @param name								the name of the algorithm
	 * @param ins								the list that contains the algorithm inputs
	 * @param inClasses							the array that contains the class of each input in ins, ignored if null
	 * @param outs								the array that contains the algorithm outputs, ignored if null
	 * @throws ArrayIndexOutOfBoundsException	thrown by array access if malformed
	 */
	public Algo(String name, String [][] ins, String [] inClasses, int [] outs) throws ArrayIndexOutOfBoundsException{
		inputs 		= new ArrayList<ArrayList<String>>();
		classes 	= new ArrayList<String>();
		
		algName = name;
		
		for(int i = 0; i < ins.length; i++){		
			ArrayList<String> thisIn = new ArrayList<String>();
			for(int j = 0; j < ins[i].length; j++){
				try{
					if(ins[i][j] != null){
						thisIn.add(ins[i][j]);
					}
				} catch (Exception e) {}
			}
			
			inputs.add(thisIn);
			
			if(inClasses != null){
				classes.add(inClasses[i]);
			}
		}
		
		if(outs != null)
		{
			usedTime 	= outs[0];
			usedMem 	= outs[1];
			allocTime 	= outs[2];
			allocMem 	= outs[3];
		}
	}	
	
	//This is the information for the new algorithm
	/**
	 * Constructor that should be used
	 * Populates the array name variable
	 * Populates the inputs variable with the in parameters array
	 * Populates resource variables from the output array
	 * 
	 * @param name								the name of the algorithm
	 * @param ins								the list that contains the algorithm inputs, ignored if null
	 * @param inClasses							the array that contains the class of each input in ins, ignored if null
	 * @throws ArrayIndexOutOfBoundsException	thrown by array access if malformed
	 */
	public Algo(String name, String [][] ins, String [] inClasses) throws ArrayIndexOutOfBoundsException{
		inputs 		= new ArrayList<ArrayList<String>>();
		classes 	= new ArrayList<String>();
		
		algName = name;
		
		for(int i = 0; i < ins.length; i++){		
			ArrayList<String> thisIn = new ArrayList<String>();
			for(int j = 0; j < ins[i].length; j++){
				try{
					if(ins[i][j] != null){
						thisIn.add(ins[i][j]);
					}
				} catch (Exception e) {}
			}
			
			inputs.add(thisIn);
			
			if(inClasses != null){
				classes.add(inClasses[i]);
			}
		}
	}
	
	//This is the information for the new algorithm
	/**
	 * Constructor that should be used
	 * Populates the array name variable
	 * Populates the inputs variable with the in parameters array
	 * Populates resource variables from the output array
	 * 
	 * @param name								the name of the algorithm
	 * @param ins								the list that contains the algorithm inputs, ignored if null
	 * @param outs								the array that contains the algorithm outputs, , ignored if null
	 * @throws ArrayIndexOutOfBoundsException	thrown by array access if malformed
	 */
	public Algo(String name, String [][] ins, int [] outs) throws ArrayIndexOutOfBoundsException{
		inputs 		= new ArrayList<ArrayList<String>>();
		classes 	= new ArrayList<String>();
		
		algName = name;
		
		for(int i = 0; i < ins.length; i++){		
			ArrayList<String> thisIn = new ArrayList<String>();
			for(int j = 0; j < ins[i].length; j++){
				try{
					if(ins[i][j] != null){
						thisIn.add(ins[i][j]);
					}
				} catch (Exception e) {}
			}
			
			inputs.add(thisIn);
		}
		
		if(outs != null)
		{
			usedTime 	= outs[0];
			usedMem 	= outs[1];
			allocTime 	= outs[2];
			allocMem 	= outs[3];
		}
	}
	
	//This is the information for the new algorithm
	/**
	 * Constructor that should be used
	 * Populates the array name variable
	 * Populates the inputs variable with the in parameters array
	 * Populates resource variables from the output array
	 * 
	 * @param name								the name of the algorithm
	 * @param ins								the list that contains the algorithm inputs, ignored if null
	 * @throws ArrayIndexOutOfBoundsException	thrown by array access if malformed
	 */
	public Algo(String name, String [][] ins) throws ArrayIndexOutOfBoundsException{
		algName = name;
		
		for(int i = 0; i < ins.length; i++){		
			ArrayList<String> thisIn = new ArrayList<String>();
			for(int j = 0; j < ins[i].length; j++){
				try{
					if(ins[i][j] != null){
						thisIn.add(ins[i][j]);
					}
				} catch (Exception e) {}
			}
			
			inputs.add(thisIn);
		}
	}
}
