package edu.masi.hyperadvisor.structures;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * The class AlgoCollection.
 * Represents information about multiple instances of an algorithm from history.
 * @author covingkj
 *
 */
public class AlgoCollection {
	public String algName;
	
	public ArrayList<Algo> instances;
	public ArrayList<String> classes;
	
	/**
	 * Default constructor. Initializes all Algo members.
	 */
	protected AlgoCollection(){
		algName 	= "";
		instances = new ArrayList<Algo>();
		classes = new ArrayList<String>();
	}
		
	/**
	 * Constructor that should be used
	 * Populates the array name variable
	 * Populates the inputs variable with the in parameters array
	 * Populates resource variables from the output array
	 * 
	 * @param name								the name of the algorithm
	 * @param ins								the list that contains the algorithm inputs
	 * @param classes							the array that contains the class of each input in ins
	 * @param outs								the array that contains the algorithm outputs, ignored if null
	 * @throws ArrayIndexOutOfBoundsException	thrown by array access if malformed
	 */
	public AlgoCollection(String name, String [][][] ins, String [] inClasses, int [][] outs) throws ArrayIndexOutOfBoundsException{
		instances 	= new ArrayList<Algo>();		
		classes		= new ArrayList<String>(Arrays.asList(inClasses));
		
		algName = name;
		for(int i = 0; i < ins.length; i++){		
			Algo thisAlgo = new Algo(name, ins[i], inClasses, outs[i]);
			instances.add(thisAlgo);
		}
	}	
}