package test;

import java.util.LinkedList;

public class VolumeCompareSigleton {

private static VolumeCompareSigleton instance = null;
	
	// add private static Vectors here
	
	private static LinkedList<TestcaseStrings> tcs;
	private static LinkedList<String> directory;
	private static LinkedList<String> datadir;
	private static LinkedList<String> userdir;
	private static LinkedList<String> fileName;

	private static LinkedList<Double> threshold;

	private static String[] params;

	protected VolumeCompareSigleton () {
		// we wouldn't want anyone touching this now would we
	}

	public static VolumeCompareSigleton getInstance () {
		if (instance == null) {
			// initialize vectors here
			tcs 		= new LinkedList<TestcaseStrings>();
			directory   = new LinkedList<String>();
			datadir     = new LinkedList<String>();
			userdir     = new LinkedList<String>();
			instance = new VolumeCompareSigleton();
			threshold = new LinkedList<Double>();
			fileName = new LinkedList<String>();
			
		}

		return instance;
	}

	public void set_data (	TestcaseStrings t, 
							String dir, String ddir, String udir) {
		tcs.offer 		(t);
		directory.offer (dir);
		datadir.offer 	(ddir);
		userdir.offer 	(udir);
	}
	
	public void set_fileName ( String name)
	{
		fileName.offer (name);

	}
	
	
	public void set_threshold ( double th) {
		threshold.offer(th);

}

	public void set_params(String[] p)
	{
		params = p;
	}

	// get methods	
	public TestcaseStrings get_tcs () {
		return tcs.poll();
	}

	public String get_directory () {
		return directory.poll();
	}

	public String get_datadir () {
		return datadir.poll();
	}
	
	public String get_userdir () {
		return userdir.poll();
	}
	
	public double get_threshold(){
		return threshold.poll();
	}
	
	
	public String[] get_params() {
		return params;
	}
	
	public String get_FileName()
	{
		return fileName.poll();
	}
	
}
