package test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import org.junit.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;

public class VolumeTest extends TestCase {
	
	private String fileName;
	private String fileNameDiff;
	
	public VolumeTest(String name){
		super(name);
	}

	private Boolean test_volume(String path){
		
		VolumeCompareSigleton vcs = VolumeCompareSigleton.getInstance();
		double threshold = vcs.get_threshold();		
		
		fileName = vcs.get_FileName();
		//System.out.println("~~~~~~~~~~~" + threshold);
		
		File fexp = null;
		File fact = null;
		fexp = new File(path + "/" + "output" + "/" + fileName);
		//fexp = new File(path + "/" + "output" + "/" + "KKI2009-01-DTI_Volume00_reg_def_01_TensorLLMSE_4D_thresh1_FA_thresh1_DEC.nii");
		//System.out.println(fexp);
		int ext = fileName.lastIndexOf(".");
		String fileNameAct = fileName.substring(0, ext);
		File tempFolder = new File(path + "/" + "temp");
		String[] filelist = tempFolder.list();
		File firstFile = new File (path + "/" + "temp" + "/" + filelist[0]);
		if (!firstFile.isDirectory())
		{
			File factExist = new File (path + "/" + "temp" + "/" + fileName);
			if (factExist.isFile()){
				fact = factExist;
			}
			else{
				fact = new File(path + "/" + "temp" + "/" + fileNameAct + ".xml");
			}
		}
		else{
			File factExist = new File (path + "/" + "temp" + "/" + filelist[0] + "/" + fileName);
			if (factExist.isFile()){
				fact = factExist;
			}
			else{
				fact = new File(path + "/" + "temp" + "/" + filelist[0] + "/" +fileNameAct + ".xml");
			}
		}
		
		System.out.println("Test file: " + fileName);
		System.out.println("Test type: Volume (Set the maximum number of different voxels)");
		System.out.println("Threshold: " + threshold);
		
		if (fexp == null)
			System.out.println("Expected data image is null.");
		
		if (fact == null)
			System.out.println("Expected data image is null.");
		
		if (fact == null || fexp == null) assert(false);
		 
		ImageData act_data = ImageDataReaderWriter.getInstance().read(fact);
		ImageData exp_data = ImageDataReaderWriter.getInstance().read(fexp);
		
		
		try{
			System.out.println("Actual_data dimensions:");
			System.out.println("\tRows: " + act_data.getRows());
			System.out.println("\tCols: " + act_data.getCols());
			System.out.println("\tSlices: " + act_data.getSlices());
			
			System.out.println("Expected_data dimensions:");
			System.out.println("\tRows: " + exp_data.getRows());
			System.out.println("\tCols: " + exp_data.getCols());
			System.out.println("\tSlices: " + exp_data.getSlices());
		} catch (Error err){
			System.out.println("Error message: " + err.getMessage());
		} catch (Exception err){
			System.out.println("Exception message: " + err.getMessage());
		}
		
		if (act_data.getRows() != exp_data.getRows() || act_data.getCols() != exp_data.getCols() || act_data.getSlices() != exp_data.getSlices())
		{
			System.err.println("Error - dimension don not match");
			assert(false);
		}
		
		TestHolder th = new TestHolder();

		TestOperatorBase tob = th.get_test("strict");
		
		tob.set_tv(threshold);
		//System.out.println("*******" + threshold);

		//System.out.println("COMPARISON CRITERIA: " + tob.get_name());

		Boolean test_result = tob.run(act_data, exp_data);
		return test_result;
		

	}
	
	private Boolean test_volumeDiff(String path){
		
		VolumeCompareSigleton vcs = VolumeCompareSigleton.getInstance();
		double thresholdMax = vcs.get_threshold();
		
		fileNameDiff = vcs.get_FileName();
		
		File fexp = null;
		File fact = null;
		fexp = new File(path + "/" + "output" + "/" + fileNameDiff);
		
		int ext = fileNameDiff.lastIndexOf(".");
		String fileNameAct = fileNameDiff.substring(0, ext);
		File tempFolder = new File(path + "/" + "temp");
		String[] filelist = tempFolder.list();
		File firstFile = new File (path + "/" + "temp" + "/" + filelist[0]);
		
		if (!firstFile.isDirectory())
		{
			File factExist= new File (path + "/" + "temp" + "/" + fileNameDiff);
			if (factExist.isFile()){
				fact = factExist;
			}
			else{
				fact = new File(path + "/" + "temp" + "/" + fileNameAct + ".xml");
			}
		}
		else{
			File factExist= new File (path + "/" + "temp" + "/" + filelist[0] + "/" + fileNameDiff);
			if (factExist.isFile()){
				fact = factExist;
			}
			else{
				fact = new File(path + "/" + "temp" + "/" + filelist[0] + "/" + fileNameAct + ".xml");
			}
		}
		
		System.out.println("Test file: " + fileNameDiff);
		System.out.println("Test type: Volume (Set the maximum difference for voxels)");
		System.out.println("Threshold: " + thresholdMax);
		
		if (fexp == null)
			System.out.println("Expected data image is null.");
		
		if (fact == null)
			System.out.println("Expected data image is null.");
		
		if (fact == null || fexp == null) assert(false);

		ImageData act_data = ImageDataReaderWriter.getInstance().read(fact);
	
		ImageData exp_data = ImageDataReaderWriter.getInstance().read(fexp);
		
		try{
			System.out.println("Actual_data dimensions:");
			System.out.println("\tRows: " + act_data.getRows());
			System.out.println("\tCols: " + act_data.getCols());
			System.out.println("\tSlices: " + act_data.getSlices());
			
			System.out.println("Expected_data dimensions:");
			System.out.println("\tRows: " + exp_data.getRows());
			System.out.println("\tCols: " + exp_data.getCols());
			System.out.println("\tSlices: " + exp_data.getSlices());
		} catch (Error err){
			System.out.println("Error message: " + err.getMessage());
		} catch (Exception err){
			System.out.println("Exception message: " + err.getMessage());
		}
		
		if (act_data.getRows() != exp_data.getRows() || act_data.getCols() != exp_data.getCols() || act_data.getSlices() != exp_data.getSlices())
		{
			System.err.println("Error - dimension don not match");
			assert(false);
		}
		
		TestHolder th = new TestHolder();

		TestOperatorBase tob = th.get_test("difference");
		
		tob.set_tv(thresholdMax);
		//System.out.println("*******" + threshold);

		//System.out.println("COMPARISON CRITERIA: " + tob.get_name());

		Boolean test_result = tob.run(act_data, exp_data);
		return test_result;

	}
	
private Boolean test_none(String path){
	VolumeCompareSigleton vcs = VolumeCompareSigleton.getInstance();
	
	fileName = vcs.get_FileName();
	System.out.println("Test file: " + fileName);
	System.out.println("Test type : None");
		

	return true;
	}
	
	@Test
	public void testVolume() {

		runTest getpath = new runTest();
		String path1 = getpath.getPath();
		Boolean res = test_volume(path1);
		assertTrue("The result of this generic Volume test.", res);
		System.out.println("VolumeCompare: test the number of different voxels successfully!");
		System.out.println("##################################################################");
	}
	
	@Test
	public void testVolumeDiff() {
		runTest getpath = new runTest();
		String path1 = getpath.getPath();
		Boolean res = test_volumeDiff(path1);
		assertTrue("The result of this generic Volume test.", res);
		System.out.println("VolumeCompare: test the maximum difference for voxels successfully!");
		System.out.println("##################################################################");
	}
	
	@Test
	public void testnone() {
		runTest getpath = new runTest();
		String path1 = getpath.getPath();
		Boolean res = test_none(path1);
		assertTrue(res);
		System.out.println("VolumeCompare: test successfully!");
		System.out.println("##################################################################");
	}
	
	
}
