package edu.jhu.ece.iacl.jist.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.LinkedList;

import edu.jhu.ece.iacl.jist.io.FileReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class discover {
	
	// a list of directory names that we can safely ignore to speed this process up
	private static String [] ignore_dirs = new String [] {"CVS",
												          "executable-wrapper-examples",
												          "imaging",
												          "license",
												          "Grid-Engine-Templates",
												          "org",
												          "1.0",
												          "Atlas",
												          "JSci",
												          "MANIFEST",
												          "META-INF",
												          "antlr",
												          "assets",
												          "au",
												          "build",
												          "ch",
												          "com",
												          "config",
												          "de",
												          "examples",
												          "html",
												          "images",
												          "jaolho",
												          "java_cup",
												          "javax",
												          "library",
												          "log",
												          "methods",
												          "no",
												          "nu",
												          "opale",
												          "ptolemy",
												          "quickhull3d",
												          "repackage",
												          "resources",
												          "schemaorg_apache_xmlbeans",
												          "src-html"};

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if(args.length<1 || args[0].equalsIgnoreCase("--help")|| args[0].equalsIgnoreCase("-h")) {
			System.out.println("cli"+"\t"+"edu.jhu.ece.iacl.jist.cli.discover -h : print this message");
			System.out.println("cli"+"\t"+"edu.jhu.ece.iacl.jist.cli.discover [classpath to search]");
			System.out.println("cli"+"\t"+"");
			System.out.println("cli"+"\t"+"Search the provided classpath for classes that extend ProcessingAlgorithm.");
			System.out.println("cli"+"\t"+"Results are provided in a two column tab delimited format");
			System.out.println("cli"+"\t"+"The left column is the human readable name. The left column is the full class name.");
			System.out.println("cli"+"\t"+"The full path name may be passed to edu.jhu.ece.iacl.jist.cli.run to describe");
			System.out.println("cli"+"\t"+"command line parameters or run via the command line.");
			System.out.println("cli"+"\t"+"");
			System.out.println("cli"+"\t"+"Java Image Science Toolkit (JIST) Command Line Interface v"+JistCLI.VERSION);
			return;
		}
			
		// split the input string into a list of strings
		String[] strs = args[0].split(File.pathSeparator);
		
		try {
			PrintStream err = System.err;
			
			printAllClasses(strs, ProcessingAlgorithm.class);
			System.setErr(err);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	public static void printAllClasses(String []strs,Class ofType) throws IOException {

		LinkedList<File> dirs = new LinkedList<File>();
		LinkedList<String> packs = new LinkedList<String>();
		String pckg;
		
		// add the starting directories
		for (String str : strs) {
			File f = new File(str);
			if (f.exists() && f.isDirectory()) {
				dirs.add(f);
				packs.add("");
			}
		}
		
		// traverse the tree
		while (dirs.size() > 0) {
			File dir = dirs.removeFirst();
			String pack = packs.removeFirst();
			File[] files = dir.listFiles();
			// Test all files in directory
			for (File f : files) {
				if (f.isDirectory()) {
					
					// make sure we can't ignore this directory
					boolean ignore = false;
					if (pack.length() == 0) {
						String name = f.getName();
						for (String ignore_dir : ignore_dirs)
							if (name.equals(ignore_dir))
								ignore = true;
					}
					
					// if we can't ignore it, then try to add it
					if (!ignore) {
						dirs.add(f);
						if (pack.length() > 0) {
							packs.add(pack + "." + FileReaderWriter.getFileName(f));
						} else {
							packs.add(FileReaderWriter.getFileName(f));
						}
					}
					
				// if it is a class file, see if it is a processing algorithm
				} else if (FileReaderWriter.getFileExtension(f).equals("class")) {

					if (pack.length() > 0) {
						pckg = pack + "." + FileReaderWriter.getFileName(f);
					} else {
						pckg = FileReaderWriter.getFileName(f);
					}
					Class<ProcessingAlgorithm> mod = null;
					try {
						Class c = Class.forName(pckg).asSubclass(ofType);
						
						if (c != null) {
							if(!Modifier.isAbstract(c.getModifiers())) {
								mod = c;
								ProcessingAlgorithm alg = mod.newInstance();
								AlgorithmInformation alginfo = alg.getAlgorithmInformation();
								System.out.println("=========");
								System.out.println("Class: " + mod.getCanonicalName());
								System.out.println("Name: " + alg.getAlgorithmName().replace("\t", " "));
								System.out.println("Description: " + alginfo.getDescription());
								System.out.println("Authors: " + alginfo.getAuthors());
								System.out.println("Affiliation: " + alginfo.getAffiliation());
							}
						}
					} catch (ClassCastException e) {
					} catch (ClassNotFoundException e) {					
					} catch (UnsatisfiedLinkError e) {
					} catch (VerifyError e) {
					} catch (Error e) {
					} catch (NullPointerException e) {
						JistLogger.logError(JistLogger.SEVERE, e.getMessage());
					} catch (IllegalAccessException e) {} catch (InstantiationException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						System.out.println("cli"+"\t"+"HUH?:"+mod.getCanonicalName());
					} 
				}
			}
		}
	}
}
