/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline;

import java.util.Vector;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.graph.PipeJGraph;
import edu.jhu.ece.iacl.jist.pipeline.graph.PipeModuleCell;
import edu.jhu.ece.iacl.jist.pipeline.graph.PipeNoteFactory;
import edu.jhu.ece.iacl.jist.pipeline.graph.PipeNoteFactory.NoteCell;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamStringArea;

// TODO: Auto-generated Javadoc
/**
 * Module for generating parameters used as input to algorithm modules.
 * 
 * @author Blake Lucas
 */
public class PipeNote extends PipeModule {
	
	ParamStringArea noteParam;
	
	@SuppressWarnings("rawtypes")
	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		this.label = inputParams.getLabel();
		this.name = inputParams.getName();
		inputParams.getInputView().addObserver(this);
		outputParams.setLabel(inputParams.getLabel());
		outputParams.setName(inputParams.getName());

		// we don't want any ports for this module
		inputPorts = new Vector<PipePort>();
		outputPorts = new Vector<PipePort>();
		
		init(null);
	}
	/**
	 * Constructor for source creates all associated input and output
	 * parameters.
	 */
	@SuppressWarnings("rawtypes")
	public PipeNote() {
		super();
		
		// set the input parameters
		this.inputParams = createInputParams();
		inputParams.getInputView().addObserver(this);
		
		// set the output parameters
		this.outputParams = createOutputParams();
		outputParams.setLabel(inputParams.getLabel());
		outputParams.setName(inputParams.getName());
		
		// set the name/label for the note
		this.label = inputParams.getLabel();
		this.name = inputParams.getName();
		
		// we don't want any ports for this module
		inputPorts = new Vector<PipePort>();
		outputPorts = new Vector<PipePort>();

		init(null);
	}

	/**
	 * Create input parameters for this source.
	 * 
	 * @return input parameters
	 */
	protected ParamCollection createInputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("Post-it");
		group.setName("postitnote");
		group.add(noteParam = new ParamStringArea("Note"));
		return(group);
	}

	/**
	 * Create new graph cell for this source.
	 * 
	 * @return the pipe module cell
	 */
	public NoteCell createModuleCell() {
		return new PipeNoteFactory.NoteCell(getLabel(), this);
	}

	/**
	 * Create output parameters for this source.
	 * 
	 * @return output parameters
	 */
	protected ParamCollection createOutputParams() {
		return(new ParamCollection());
	}

	/**
	 * Initialize fields that could not be deserialized.
	 * 
	 * @param graph the graph
	 * 
	 * @return the pipe module cell
	 */
	@SuppressWarnings("rawtypes")
	public PipeModuleCell init(PipeJGraph graph) {
		for (PipePort port : inputPorts) {
			port.setPortType(PipePort.type.INPUT);
		}
		for (PipePort port : outputPorts) {
			port.setPortType(PipePort.type.OUTPUT);
		}
		if (graph != null) {
			return graph.createGraphNode(this);
		} else {
			return null;
		}
	}

	public String reconcileAndMerge() throws InvalidJistMergeException {
		return "PipeNote merge not currently necessary."; 
	}
}
