package edu.jhu.ece.iacl.jist.pipeline.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import edu.jhu.ece.iacl.jist.cli.JistCLI;
import edu.jhu.ece.iacl.jist.io.CopyDirectory;
import edu.jhu.ece.iacl.jist.pipeline.ExecutionContext;
import edu.jhu.ece.iacl.jist.pipeline.ExecutionContext.Status;
import edu.jhu.ece.iacl.jist.pipeline.JistPreferences;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout;
import edu.jhu.ece.iacl.jist.pipeline.gui.resources.PlaceHolder;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamHeader;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class JISTValidationGUI {

	public static String jvmInfo() {

		StringBuffer aboutJavaDialog = new StringBuffer(); 

		String javaClassPath = System.getProperties().getProperty("java.class.path");
		javaClassPath = javaClassPath.replace(';', '\n');

		aboutJavaDialog.append("Java version:       " + System.getProperties().getProperty("java.version") + "\n");
		aboutJavaDialog.append("Java compiler:      " + System.getProperties().getProperty("java.compiler") + "\n");
		aboutJavaDialog.append("Java vendor:        " + System.getProperties().getProperty("java.vendor") + "\n");
		aboutJavaDialog.append("Java vendor.url:    " + System.getProperties().getProperty("java.vendor.url") + "\n");
		aboutJavaDialog.append("Java home:          " + System.getProperties().getProperty("java.home") + "\n");
		aboutJavaDialog.append("Java class version: " + System.getProperties().getProperty("java.class.version") + "\n");
		aboutJavaDialog.append("Java class path:    " + "\n" + javaClassPath + "\n");
		aboutJavaDialog.append("OS name:            " + System.getProperties().getProperty("os.name") + "\n");
		aboutJavaDialog.append("OS arch:            " + System.getProperties().getProperty("os.arch") + "\n");
		aboutJavaDialog.append("OS version:         " + System.getProperties().getProperty("os.version") + "\n");
		aboutJavaDialog.append("User name:          " + System.getProperties().getProperty("user.name") + "\n");
		aboutJavaDialog.append("User home:          " + System.getProperties().getProperty("user.home") + "\n");
		aboutJavaDialog.append("User directory:     " + System.getProperties().getProperty("user.dir") + "\n");
		return aboutJavaDialog.toString();
	}

	public static String mipavInfo() {
		return gov.nih.mipav.view.MipavUtil.getVersion();		
	}

	public static String jistInfo() {
		return JistPreferences.getPreferences().toXML();		
	}

	public void fileBugReport(PipeLayout pipelineLayout) {
		JFrameTester frame = null;
		if(pipelineLayout!=null)
			frame=new JFrameTester("LayoutXML File", pipelineLayout.toSaneXML());
		else 
			frame=new JFrameTester("LayoutXML File", "No active layout file");


	}
	
	public void fileBugReport(Vector<ExecutionContext> currentContexts) {
		try { 

			JFrameTester frame=new JFrameTester("LayoutXML File", currentContexts.get(0).getLayout().toSaneXML());
		} catch(Exception e)
		{
			JFrameTester frame=new JFrameTester("LayoutXML File", "Cannot access active layout file.");
		}
	}
	
	public Vector<ExecutionContext> currentContexts;
	public void generateTestCase(Vector<ExecutionContext> currentContexts) {
		if(currentContexts==null || currentContexts.size()<1)
			JOptionPane.showMessageDialog(null, "No execution context rows selected.\nNothing to do.");
		else
			new JTestCaseGenerator("LayoutXML File", currentContexts);		
		this.currentContexts = currentContexts;
	}


	public class JTestCaseGenerator extends JDialog implements ActionListener {

		JTextField username;
		JTextField email;
		JTextField website;
		JTextField version;
		JTextField outputDirectory;
		JTextArea summary;
		JTextArea problem;
		JTextArea file;

		JTextArea mipav;
		JTextArea jvm;
		JTextArea jist;
		JTextArea roInfo;
		JButton submit;
		JButton select;
		JButton cancel;

		JButton submit2;
		
		JComboBox Test;

		Vector<JSONObject> tests;
		JSONObject currentTest;
		int typei = 0;
		public String path="";
		
		HashMap<ParamModel, JPanel> execContextPanels = new HashMap<ParamModel, JPanel>();

		public JTestCaseGenerator(String msg, Vector<ExecutionContext> currentContexts) {

			super(ProcessManager.getInstance(),"JIST Test Case Manager",false);
			this.setLayout(new BorderLayout());
			this.setPreferredSize(new Dimension(800, 400));

			JTabbedPane tabbedPane = new JTabbedPane();
			add(tabbedPane);
			//			JComponent panel1 = makeTextPanel("Panel #1");

			// create the main component that we will be adding to
			JPanel small = new JPanel(new GridBagLayout());
			JScrollPane parent = new JScrollPane(small);
			tabbedPane.addTab("Main", null, parent, "Main");

			
			// create all of the labels and textfields
			JLabel nameLabel = new JLabel("Contact Name");
			JLabel emailLabel = new JLabel("Contact E-Mail");
			JLabel websiteLabel = new JLabel("Website");
			JLabel versionLabel = new JLabel("Version");
			JLabel summaryLabel = new JLabel("Summary");
			JLabel outputLabel = new JLabel("Output Directory");
			username = new JTextField(40);			
			email = new JTextField(40);			
			website = new JTextField(40);			
			version = new JTextField(40);			
			JScrollPane summaryPane = new JScrollPane(summary = new JTextArea(10,40));			

			JPanel outputPane = new JPanel(new GridBagLayout());
			GridBagConstraints tmpC = new GridBagConstraints();
			tmpC.fill = GridBagConstraints.BOTH;
			tmpC.gridx = 0; tmpC.gridy = 0; tmpC.ipadx = 0; tmpC.weightx = 1; tmpC.ipady = 0;
			outputPane.add(outputDirectory = new JTextField(40), tmpC);
			outputDirectory.setText(currentContexts.get(0).getLayout().getRunParameters().getOutputDirectory().getAbsolutePath());
			path = outputDirectory.getText();
			tmpC.fill = GridBagConstraints.NONE;
			tmpC.gridx = 1; tmpC.gridy = 0; tmpC.ipadx = 0; tmpC.weightx = 0; tmpC.ipady = 0;
			outputPane.add(select = new JButton("..."), tmpC);
			
			submit = new JButton("Generate Report");
			cancel = new JButton("Cancel");
			
			JPanel buttonPane = new JPanel(new GridBagLayout());
			tmpC = new GridBagConstraints();
			tmpC.fill = GridBagConstraints.NONE;
			tmpC.gridx = 0; tmpC.gridy = 0; tmpC.ipadx = 10; tmpC.weightx = 0.5; tmpC.ipady = 10;
			buttonPane.add(submit = new JButton("Generate Report"), tmpC);
			tmpC.gridx = 1;
			buttonPane.add(cancel, tmpC);
			
			// add all of the components
			GridBagConstraints c = new GridBagConstraints();
			c.fill = GridBagConstraints.HORIZONTAL;
			c.weightx = 0.5; c.weighty = 0;
			c.ipadx = 5; c.ipady = 5;
			
			c.gridx = 0; c.gridy = 0; small.add(nameLabel, c);
			c.gridx = 1; c.gridy = 0; small.add(username, c);
			c.gridx = 0; c.gridy = 1; small.add(emailLabel, c);
			c.gridx = 1; c.gridy = 1; small.add(email, c);
			c.gridx = 0; c.gridy = 2; small.add(websiteLabel, c);
			c.gridx = 1; c.gridy = 2; small.add(website, c);
			c.gridx = 0; c.gridy = 3; small.add(versionLabel, c);
			c.gridx = 1; c.gridy = 3; small.add(version, c);
			c.gridx = 0; c.gridy = 4; small.add(summaryLabel, c);
			c.gridx = 1; c.gridy = 4; small.add(summaryPane, c);
			c.gridx = 0; c.gridy = 5; small.add(outputLabel, c);
			c.gridx = 1; c.gridy = 5; small.add(outputPane, c);

			c.gridwidth = 2; c.gridx = 0; c.gridy = 6; c.weightx = 0.5; c.weighty = 0; c.ipadx = 10; c.ipady = 10;
			small.add(buttonPane, c);
			c.gridwidth = 2; c.gridx = 0; c.gridy++; c.weightx = 1; c.weighty = 1; c.ipadx = 0; c.ipady = 0;
			small.add(new JLabel(""), c);
			
			setIconImage(Toolkit.getDefaultToolkit().getImage(
					PlaceHolder.class.getResource("bug.png"))); /**SET ICON HERE**/
			
			// add some action listeners
			select.addActionListener(this);
			submit.addActionListener(this);
			cancel.addActionListener(this);

			tests = new Vector<JSONObject>();
			
			for (ExecutionContext e: currentContexts) {
				
				
				if (e.getStatus() != Status.COMPLETED) {
					JistLogger.logOutput(JistLogger.INFO, String.format("[Test Case Generator] Context %s is not complete: Skipping", e.getContextName()));
					continue;
				}
				
				// get everything related to the context (non-GUI)
				ParamCollection inp = e.getInputParamsFromFile();
				ParamCollection outp = e.getOutputParamsFromFile();
				ParamHeader header = inp.getHeader();

				// do some JSON stuff
				JSONObject MainJSO 		= new JSONObject();
				JSONObject InputJSO 	= new JSONObject();
				JSONObject TestCritJSO 	= new JSONObject();
				JSONObject SurfTestJSO 	= new JSONObject();
				JSONArray Flags 		= new JSONArray();
				JSONArray Values 		= new JSONArray();
				try {
					MainJSO.put("context_name", e.getContextName());
					MainJSO.put("module", header.getValue().getCanonicalName());
					MainJSO.put("memx", Integer.toString(JistPreferences.getPreferences().getDefaultMemory()));
					MainJSO.put("debug_print", true);
					MainJSO.put("grid_run", true);
				} catch (JSONException je) { /* eat it for now */ }

				// create the main component that we will be adding to
				small = new JPanel(new GridBagLayout());
				parent = new JScrollPane(small);
				tabbedPane.addTab(e.getContextShortName(), null, parent, "Execution Context");
				c = new GridBagConstraints();
				c.fill = GridBagConstraints.HORIZONTAL;
				c.weightx = 0.5; c.weighty = 0;
				c.ipadx = 5; c.ipady = 5;
				
				JTextField temp = new JTextField(40);
				temp.setText(e.getContextName());
				temp.setEditable(false);
				c.gridx = 0; c.gridy = 0;
				small.add(new JLabel("Context Name"), c);
				c.gridx = 1; c.gridy = 0;
				small.add(temp, c);

				temp = new JTextField(40);
				temp.setEditable(false);
				temp.setText(header.getValue().getCanonicalName());
				c.gridx = 0; c.gridy = 1;
				small.add(new JLabel("Module Name"), c);
				c.gridx = 1; c.gridy = 1;
				small.add(temp, c);

				JistCLI.prepareCLITags(inp, outp);

				/**
				 * Handle the input parameters
				 */
				c.gridwidth = 2; c.gridy++; c.gridx = 0; c.ipady = 10;
				c.fill = GridBagConstraints.NONE;
				small.add(new JLabel(""), c);
				c.gridy++;
				small.add(new JLabel("Input Parameters"), c);
				c.gridwidth = 1; c.ipady = 5;
				c.fill = GridBagConstraints.HORIZONTAL;
				for(ParamModel pm :  inp.getAllDescendants()) {
					if(null!=pm.getCliTag()) {
						
						// create the parameter-specific GUI options
						JLabel outName = new JLabel (pm.getCliTag());
						outName.setToolTipText(pm.getLabel());
						JTextField outFile = new JTextField(40);
						outFile.setText((pm.getValue() == null) ? "" : pm.getValue().toString());
						outFile.setEditable(false);
						
						c.gridy++;
						c.gridx = 0; small.add(outName, c);
						c.gridx = 1; small.add(outFile, c);
						
						// adding flags and values
						Flags.put(pm.getCliTag());
						Values.put(pm.getValue().toString());

					}
				}

				/**
				 * Handle the output parameters
				 */
				c.gridwidth = 2; c.gridy++; c.gridx = 0; c.ipady = 10;
				small.add(new JLabel(""), c);
				c.gridy++;
				c.fill = GridBagConstraints.NONE;
				small.add(new JLabel("Output Parameters"), c);
				c.gridwidth = 1; c.ipady = 5;
				c.fill = GridBagConstraints.HORIZONTAL;
				for(ParamModel pm :  outp.getAllDescendants()) {
					if(pm.getCliTag() != null && pm.getValue() != null) {
						
						boolean isFile = true;
						
						String full_value = pm.getValue().toString().replaceAll("[\\[\\]]", "");
						full_value = full_value.replaceAll(" ", "");
						if (full_value.contains(",")){
							String[] splittedList = full_value.split(",");
							for (String item: splittedList) {
								File input = new File(item);
								if(!input.isFile())
									isFile = false;
							}
						} else {
							File f = new File(full_value);
							if (!f.isFile())
								isFile = false;
						}
						
						if (isFile) {
							JLabel outName = new JLabel (pm.getCliTag());
							outName.setToolTipText(pm.getLabel());
							JTextField outFile = new JTextField(40);
							outFile.setText(pm.getValue().toString());
							outFile.setEditable(false);

							// the options
							String[] choices = {"None", "Volume (Set the maximum number of different voxels)", "Volume (Set the maximum difference for voxels)", "Surface (Set the maximum number of different voxels)", "Surface (Set the maximum difference for voxels)", "FileExistence"};
							Test = new JComboBox(choices);
							JTextField thresh = new JTextField();
							thresh.setText("0");
							JPanel optPane = new JPanel(new GridBagLayout());
							tmpC = new GridBagConstraints();
							tmpC.fill = GridBagConstraints.BOTH;
							tmpC.ipadx = 0; tmpC.ipady = 0; tmpC.weightx = 1; tmpC.weighty = 1;
							
							tmpC.gridx = 0; tmpC.gridy = 0;
							optPane.add(new JLabel("Test Style: "), tmpC);
							tmpC.gridx++; optPane.add(Test, tmpC);
							
							tmpC.gridx = 0; tmpC.gridy = 1;
							optPane.add(new JLabel("Test Threshold: "), tmpC);
							tmpC.gridx++; optPane.add(thresh, tmpC);
							
							execContextPanels.put(pm, optPane);
							
							if (pm.isVolume())
								Test.setSelectedIndex(1);
							else if (pm.isSurface())
								Test.setSelectedIndex(3);
							else
								Test.setSelectedIndex(5);
							
							c.gridy++;
							c.gridx = 0; small.add(outName, c);
							c.gridx = 1; small.add(outFile, c);
							c.gridy++;
							c.gridx = 1; small.add(optPane, c);
						} else {
							JLabel outName = new JLabel (pm.getCliTag());
							outName.setToolTipText(pm.getLabel());
							JTextField outFile = new JTextField(40);
							if (pm.getValue() != null)
								outFile.setText(pm.getValue().toString());
							else
								outFile.setText("[None]");
							outFile.setEditable(false);
							c.gridy++;
							c.gridx = 0; small.add(outName, c);
							c.gridx = 1; small.add(outFile, c);
						}
						
						// adding flags and values
						Flags.put(pm.getCliTag());
						Values.put(pm.getValue().toString());
					}
				}
				c.gridwidth = 2; c.gridx = 0; c.gridy++; c.weightx = 1; c.weighty = 1; c.ipadx = 0; c.ipady = 0;
				small.add(new JLabel(""), c);

				// Add some more JSON stuff
				try {
					InputJSO.put("flags", Flags);
					InputJSO.put("values", Values);
				
					TestCritJSO.put("type", 	"your_test_criteria");
					TestCritJSO.put("val", 		"your_val");
					TestCritJSO.put("subdir", 	"your_dir");

					SurfTestJSO.put("template_volume", "\"path/to/template/volume\"");
					SurfTestJSO.put("surface_extension", "surface.extension");

					MainJSO.put("input", InputJSO);
					MainJSO.put("test_criteria", TestCritJSO);
					MainJSO.put("surface_test", SurfTestJSO);
				} catch (JSONException jse) { /* do nothing */ }
				tests.add(MainJSO);
			}

			pack();
			setVisible(true);
		}

		private String encode(String key, String pair) throws UnsupportedEncodingException {
			return URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(pair, "UTF-8");
		}
		
		@Override		
		public void actionPerformed(ActionEvent evt) {
			// TODO Auto-generated method stub
			if(evt.getSource()==cancel) {
				this.setVisible(false);
				this.dispose();
			} else if(evt.getSource()==submit) {
				
				String msg = "";
				

				//String selectType = type.getSelectedItem().toString();
				//Generate the folder for each exp
				for(ExecutionContext e: currentContexts) {
					
					if (e.getStatus() != Status.COMPLETED)
						continue;
					
					String testIn = "JIST-Test-Case-" + e.getContextName();
					path = outputDirectory.getText();
					
					// make sure the output directory is valid
					if (!(new File(path)).isDirectory()) {
						JOptionPane.showMessageDialog(this, "Output Directory is invalid", "Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
					
					File testFile = new File (path + File.separator + testIn);
					testFile.mkdir();
					msg += testFile.getAbsolutePath() + "\n";
				    
					//get the contact information
					String mainName = username.getText();
					String mainEmail = email.getText();
					String mainWeb = website.getText();
					String mainversion = version.getText();
					String mainSummary = summary.getText();
					FileWriter contactInfo;
					String contactFileName = path+ File.separator + testIn + File.separator+ "ContactInfo.txt";
					try {
						contactInfo = new FileWriter(contactFileName);
						PrintWriter contact = new PrintWriter(contactInfo);
						contact.println("Contact Name: " + mainName);
						contact.println("Contact E-mail: " + mainEmail);
						contact.println("Website: " + mainWeb);
						contact.println("Version: " + mainversion);
						contact.println("comments: " + mainSummary);
						contact.close();
					} catch (IOException e1) {
						JOptionPane.showMessageDialog(this, e1.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
				
					//generate the input data file for the exp
					ParamCollection inp = e.getInputParamsFromFile();
					ParamCollection outp = e.getOutputParamsFromFile();
					JistCLI.prepareCLITags(inp, outp);
					int i = 0;
					for(ParamModel pm :  inp.getAllDescendants()) {
						if(null!=pm.getCliTag() && pm.getValue() != null) {
							String pathName1 = pm.getValue().toString().replaceAll("[\\[\\]]", "");
							String pathName = pathName1.replaceAll(" ", "");
							if (!pathName.contains(",")){
								File input = new File(pathName);
								if(input.isFile()){
									int index = pathName.lastIndexOf(File.separator);
									String dataName = pathName.substring(index+1);
									int indexName = pathName.lastIndexOf(".");
									String indexString = pathName.substring(0, index);
									int secINdex = indexString.lastIndexOf(File.separator);
									String folderPath = indexString.substring(0, secINdex);
									File inputFolder= new File (path + File.separator + testIn + File.separator + "input" + i);
									inputFolder.mkdir();
									//set the output folder
									File resultOut = new File (path + File.separator +testIn + File.separator + "temp");
									resultOut.mkdir();
								
									String CommfileName = pathName.substring(index + 1, indexName);
									String tail = pathName.substring(indexName + 1);
									if (tail.equals("xml")){
										String rawData = indexString + File.separator + CommfileName + ".raw";
											try {
												CopyDirectory.copyFileToFolder(rawData, path + File.separator + testIn + File.separator + "input" + i);
											} catch (IOException e1) {
												JOptionPane.showMessageDialog(this, e1.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
												return;
											}
									}
									try {
										CopyDirectory.copyFileToFolder(pathName, path + File.separator + testIn + File.separator + "input" + i);
									} catch (IOException e2) {
										JOptionPane.showMessageDialog(this, e2.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
										return;
									}
									i = i + 1;
								}
							} else {
								String[] pathNameList = pathName.split(",");
								for (String inItem : pathNameList){
									File input = new File(inItem);
									if(input.isFile()){
										int index = inItem.lastIndexOf(File.separator);
										String dataName = inItem.substring(index+1);
										int indexName = inItem.lastIndexOf(".");
										String indexString = inItem.substring(0, index);
										File inputFolder= new File (path + File.separator + testIn + File.separator + "input" + i);
										inputFolder.mkdir();
									
										String CommfileName = inItem.substring(index + 1, indexName);
										String tail = inItem.substring(indexName + 1);
										if (tail.equals("xml")){
											String rawData = indexString + File.separator + CommfileName + ".raw";
												try {
													CopyDirectory.copyFileToFolder(rawData, path + File.separator + testIn + File.separator + "input" + i);
												} catch (IOException e1) {
													JOptionPane.showMessageDialog(this, e1.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
													return;
												}
										}
										try {
											CopyDirectory.copyFileToFolder(inItem, path + File.separator + testIn + File.separator + "input" + i);
										} catch (IOException e2) {
											JOptionPane.showMessageDialog(this, e2.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
											return;
										}
									}
								}
								i = i + 1;
							}
						}
					}
					
					//*************************************************
					//generate output data file for the exp
					String outputFolderPath = path + File.separator + testIn + File.separator + "output";
					File outputFolder = new File (path + outputFolderPath);
					outputFolder.mkdir();
					for(ParamModel pm :  outp.getAllDescendants()) {
						//pm.getFactory().saveResources(outputFolder, true);
						if (pm.getCliTag() == null || pm.getValue() == null) continue;
						
						String tagPaths1 = pm.getValue().toString().replaceAll("[\\[\\]]", "");
						String tagPaths = tagPaths1.replaceAll(" ", "");
						String[] tagPathList = tagPaths.split(",");
						for (String item : tagPathList){
							File input = new File(item);
							if(input.isFile()){
								int index = item.lastIndexOf(File.separator);
								String dataName = item.substring(index+1);
								int indexName = item.lastIndexOf(".");
								String tail = item.substring(indexName+1);
								String commFileName = item.substring(index+1, indexName);
								String indexString = item.substring(0, index);
								if (tail.equals("xml")){
									String rawData = indexString + File.separator + commFileName + ".raw";
									try {
										CopyDirectory.copyFileToFolder(rawData, outputFolderPath);
									} catch (IOException e3) {
										JOptionPane.showMessageDialog(this, e3.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
										return;
									}
								}
								
								try {
									CopyDirectory.copyFileToFolder(item, outputFolderPath);
								} catch (IOException e2) {
									JOptionPane.showMessageDialog(this, e2.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
									return;
								}
							}
						}
					}
	
					//Generate properties file for test case
					ProcessManagerTable managerPane = null;
					try {
						FileWriter outFile = new FileWriter(path+ File.separator + testIn + File.separator + "TestCase.properties");
						PrintWriter out = new PrintWriter(outFile);
						
						out.println("Context name:"+e.getContextName());
							
							JistCLI.prepareCLITags(inp, outp);
							
							//generate the test type for each output
							for(ParamModel pm :  outp.getAllDescendants()) {
								if (null != pm.getCliTag() && pm.getValue() != null){
								String splitted1 = pm.getValue().toString().replaceAll("[\\[\\]]", "");
								String splitted = splitted1.replaceAll(" ", "");
								if (splitted.contains(",")){
									String[] splittedList = splitted.split(",");
									boolean use = true;
									for (String item: splittedList){
										File input = new File(item);
										if (!input.isFile())
											use = false;
									}
									if (use) {
										for (String item: splittedList){
											File input = new File(item);
											if(input.isFile()){
												int index = item.lastIndexOf(File.separator);
												String dataName = item.substring(index+1);
												int indexName = item.lastIndexOf(".");
												String outfileName = "output" + "/" + dataName;
												out.println("Out Param: "+pm.getCliTag()+","+ outfileName);
												out.println(this.getComboBoxValue(pm));
												out.println(this.getTextfieldValue(pm));
											}
										}
									}
								} else {
									File input2 = new File(splitted);
									if(input2.isFile()){
										int index = splitted.lastIndexOf(File.separator);
										String dataName = splitted.substring(index+1);
										int indexName = splitted.lastIndexOf(".");
										String outfileName = "output" + "/" + dataName;
										out.println("Out Param: "+pm.getCliTag()+","+ outfileName);
										out.println(this.getComboBoxValue(pm));
										out.println(this.getTextfieldValue(pm));
									}
								}	
							}
						}
						out.println("~~~~~~~~~~~~~~~~~~~~~~~~~");
						//out.println("Context name: "+e.getContextName());
						ParamHeader header = inp.getHeader();
						out.println(header.getValue().getCanonicalName());
						int k = 0;
						for(ParamModel pm :  inp.getAllDescendants()) {
							if(null!=pm.getCliTag() && pm.getValue() != null) {
								String splitted1 = pm.getValue().toString().replaceAll("[\\[\\]]", "");
								String splitted = splitted1.replaceAll(" ", "");
								File input = new File(splitted);
								
								// handle file collections
								if (splitted.contains(",")){
									String[] splittedList = splitted.split(",");
									boolean use = true;
									for (String item: splittedList){
										File inputColl = new File(item);
										if (!inputColl.isFile())
											use = false;
									}
									if (use) {
										String fileName = "";
										for (String item: splittedList) {
											int index = item.lastIndexOf(File.separator);
											String dataName = item.substring(index+1);
											if (fileName.equals(""))
												fileName = "input" + k + File.separator + dataName;
											else
												fileName += ";input" + k + File.separator + dataName;
										}
										k = k + 1;
										out.println("-"+pm.getCliTag()+" "+fileName);
									} else {
										out.println("-"+pm.getCliTag()+" "+splitted);
									}
									
								// handle files
								} else if (input.isFile()) {
									int index = splitted.lastIndexOf(File.separator);
									String dataName = splitted.substring(index+1);
									String fileName = "input" + k + File.separator + dataName;
									k = k + 1;
									out.println("-"+pm.getCliTag()+" "+fileName);
									
								// handle non-file parameters
								} else {
									out.println("-"+pm.getCliTag()+" "+splitted);
								}
							}
						}
						out.println("-xDir " + "temp");
						out.close();
					}  catch (IOException e4) {
						JOptionPane.showMessageDialog(this, e4.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
	
					//Generate the zip file
					try {
						ZipOutputStream zout = new ZipOutputStream (new FileOutputStream (new File(path + File.separator + testIn + ".zip")));
						File f = new File(path+ File.separator + testIn);
						zipFiles(zout, f, "");
						try {
							zout.close();
						} catch (IOException e1) {
							JOptionPane.showMessageDialog(this, e1.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
							return;
						}
					} catch (FileNotFoundException e5) {
						JOptionPane.showMessageDialog(this, e5.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
				}
				JOptionPane.showMessageDialog(this, "The following test cases were successfully generated:\n" + msg);
				this.setVisible(false);
				this.dispose();
			} else if(evt.getSource()==submit2) { // testcase submission button

				String wtf = ((JButton) evt.getSource()).getAccessibleContext().getAccessibleParent().getAccessibleContext().getAccessibleName();
				
			} else if(evt.getSource()==select) {
				JFileChooser chooser = new JFileChooser();
				File currDir = new File(outputDirectory.getText());
				if (currDir.exists())
					chooser.setCurrentDirectory(currDir);
				else
					chooser.setCurrentDirectory(JistPreferences.getPreferences().getLastLayoutDirectory());
				chooser.setDialogTitle("Select Output Directory");
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				chooser.setAcceptAllFileFilterUsed(false);

				if (chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
					JistLogger.logOutput(JistLogger.FINE, "getCurrentDirectory(): " + chooser.getSelectedFile().getAbsolutePath());
					outputDirectory.setText(chooser.getSelectedFile().getAbsolutePath());
					
				} else {
					JistLogger.logOutput(JistLogger.FINE, "No Selection ");
				}	 
			}	
			typei = typei+1;
		}
		
		private String getComboBoxValue(ParamModel pm) {
			JPanel currentPanel = (JPanel) this.execContextPanels.get(pm);
			//JComboBox currentPanel = (JComboBox) this.execContextPanels.get(pm);
//			JPanel currentPanel = ((JPanel) ((JButton) evt.getSource()).getParent());
			Component[] comps = currentPanel.getComponents();
			for(int cIdx = 0; cIdx < comps.length; cIdx++) {
				Component comp = comps[cIdx];
					if(comp instanceof JComboBox){
					JComboBox cBox = (JComboBox) comp;
					String out = cBox.getSelectedItem().toString();
					return out;
					}
			}
			return "dummy";
			
//			String out = currentPanel.getSelectedItem().toString();
//			return out;
		}
		
		private String getTextfieldValue(ParamModel pm) {
			//JPanel currentPanel = (JPanel) this.execContextPanels.get(pm);
			Container currentPanel = (Container) this.execContextPanels.get(pm);
			Component[] comps = currentPanel.getComponents();
			for(int cIdx = 0; cIdx < comps.length; cIdx++) {
				Component comp = comps[cIdx];
				if(comp instanceof JTextField) {
					JTextField textfield = (JTextField) comp;
					String out = textfield.getText();
					return out;
				}
			}
			
			return "dummy";
		}
	}


	public class JFrameTester extends JDialog implements ActionListener {

		JTextField username;
		JTextField email;
		JTextField summary;
		JTextArea problem;
		JTextArea file;
		
		//Updates for SOAP post
		JTextField nitrcusername;
		JPasswordField nitrcpassword;
		
		JTextArea mipav;
		JTextArea jvm;
		JTextArea jist;
		JTextArea roInfo;
		JButton submit;
		JButton cancel;

		public JFrameTester(String msg, String value) {

			super((Dialog)null,"JIST Bug Report",true);
			this.setLayout(new BorderLayout());


			JPanel small = new JPanel();

			BoxLayout layout = new BoxLayout(small, BoxLayout.PAGE_AXIS);
			small.setLayout(layout);
			//			this.add(small, BorderLayout.NORTH);


			JScrollPane parent = new JScrollPane(small);
			add(parent);

			JPanel itemPane = new JPanel(new BorderLayout());			

			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel("Your Name "), BorderLayout.WEST);
			itemPane.add(username = new JTextField(40), BorderLayout.EAST);			
			small.add(itemPane);
			
			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel("Your NITRC Username "), BorderLayout.WEST);
			itemPane.add(nitrcusername = new JTextField(40), BorderLayout.EAST);			
			small.add(itemPane);
			
			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel("Your NITRC Password "), BorderLayout.WEST);
			itemPane.add(nitrcpassword = new JPasswordField(40), BorderLayout.EAST);			
			small.add(itemPane);

			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel("Contact e-mail "), BorderLayout.WEST);
			itemPane.add(email = new JTextField(40), BorderLayout.EAST);			
			small.add(itemPane);

			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel("Problem Summary "), BorderLayout.WEST);
			itemPane.add(summary = new JTextField(40), BorderLayout.EAST);			
			small.add(itemPane);

			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel("Problem Description "), BorderLayout.WEST);
			itemPane.add(new JScrollPane(problem = new JTextArea(10,40)), BorderLayout.EAST);			
			small.add(itemPane);

			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel(msg +"\n (read only)"), BorderLayout.WEST);
			itemPane.add(new JScrollPane(file = new JTextArea(10,40)), BorderLayout.EAST);
			//			file.setS
			file.setText(value);
			file.setLineWrap(true);
			file.setEditable(false);
			small.add(itemPane);


			itemPane = new JPanel(new BorderLayout());
			itemPane.add(new JLabel("System Information \n (read only) "), BorderLayout.WEST);
			itemPane.add(new JScrollPane(roInfo = new JTextArea(10,40)), BorderLayout.EAST);			
			small.add(itemPane);
			mipav = new JTextArea();jist=new JTextArea();jvm = new JTextArea();
			mipav.setText("********************* MIPAV Information *********************\n"+mipavInfo());
			jist.setText("********************* JIST Information *********************\n"+jistInfo());
			jvm.setText("********************* JVM Information *********************\n"+jvmInfo());
			roInfo.setText(mipav.getText()+"\n\n"+jist.getText()+"\n\n"+jvm.getText());
			roInfo.setEditable(false);

			itemPane = new JPanel(new BorderLayout());
			JLabel t;
			itemPane .add(t=new JLabel("********** If you click submit, the above information will be transmitted. **********"),BorderLayout.CENTER);
			t.setHorizontalTextPosition(JLabel.CENTER);
			small.add(itemPane);

			itemPane = new JPanel(new BorderLayout());
			itemPane .add(t=new JLabel("******** DO NOT INCLUDE CONFIDENTIAL OR PROTECTED HUMAN SUBJECTS INFORMATION ********"),BorderLayout.CENTER);
			t.setHorizontalTextPosition(JLabel.CENTER);
			small.add(itemPane);

			itemPane = new JPanel(new BorderLayout());
			itemPane.add(submit = new JButton("Submit Report"),BorderLayout.WEST);
			submit.addActionListener(this);
			itemPane.add(cancel = new JButton("Cancel"),BorderLayout.EAST);
			cancel.addActionListener(this);
			small.add(itemPane);

			setIconImage(Toolkit.getDefaultToolkit().getImage(
					PlaceHolder.class.getResource("bug.png"))); /**SET ICON HERE**/


			pack();
			setVisible(true);
		}

		private String encode(String key, String pair) throws UnsupportedEncodingException {
			return URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(pair, "UTF-8");
		}

		public void submit() {

			try{
			//Get/initialize some parameters for the addArtifact web service
		    String t_username = nitrcusername.getText();
		    char[] password_char = nitrcpassword.getPassword();
		    String t_password = new String(password_char);
		    
		    String project_id = "228";
		    String tracker_id = "942"; 
		    
		    String p_sumraw = summary.getText();
		    String p_sum = StringEscapeUtils.escapeXml(p_sumraw);
		    String probraw = problem.getText();
		    String prob = StringEscapeUtils.escapeXml(probraw);
		    
		    String group_id = "228";
		    String group_artifact_id="942";
		    String status_id = "3";
		    String priority = "3";
		    String assigned_to ="0";
		    
			//Change to SOAP call
		    SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
		    SOAPConnection soapConnection = soapConnectionFactory.createConnection();
		    
		    String url = "https://www.nitrc.org/soap/?wasdl";
		    
		    MessageFactory messageFactory = MessageFactory.newInstance();
		    SOAPMessage soapMessage = messageFactory.createMessage();
		    SOAPPart soapPart = soapMessage.getSOAPPart();
		    
		    String serverURI = "http://www.nitrc.org";
		    SOAPEnvelope envelope = soapPart.getEnvelope();
		    envelope.addNamespaceDeclaration("ns3","http://www.nitrc.org");
		    envelope.addNamespaceDeclaration("ns2","http://www.w3.org/2001/XMLSchema");
		    envelope.addNamespaceDeclaration("ns1", "http://schemas.xmlsoap.org/soap/envelope/");
		    envelope.addNamespaceDeclaration("SOAP-ENC","http://schemas.xmlsoap.org/soap/encoding/");
		    envelope.addNamespaceDeclaration("SOAP-ENV","http://schemas.xmlsoap.org/soap/envelope/");
		    
		    //Create the login
		    SOAPBody soapBody = envelope.getBody();
		    SOAPElement login = soapBody.addChildElement(envelope.createName("login","ns3","http://schemas.xmlsoap.org/soap/envelope/"));
		    login.addChildElement("userid").addTextNode(t_username).setAttribute("xsi:type","ns2:string");
		    login.addChildElement("passwd").addTextNode(t_password).setAttribute("xsi:type","ns2:string");
		    
		    //Save the message
		    soapMessage.saveChanges();
		    
		    //Send the login request
		    SOAPMessage rp = soapConnection.call(soapMessage,url);
		    
		    //Parse the XML string to extract the session key
		    String sess_key = rp.getSOAPBody().getElementsByTagName("loginResponse").item(0).getTextContent();
		    
		    //Check to see if the session key is valid.
		    if (!sess_key.contains("=-*-")){
		    	System.out.println(sess_key);
		    }
		    //Grab text from the GUI and format the SOAP message
		    MessageFactory messageFactoryErr = MessageFactory.newInstance();
		    SOAPMessage soapMessageErr = messageFactoryErr.createMessage();
		    SOAPPart soapPartErr = soapMessageErr.getSOAPPart();
		    SOAPEnvelope envelopeErr = soapPartErr.getEnvelope();
		    
		    envelopeErr.addNamespaceDeclaration("ns3","http://www.nitrc.org");
		    envelopeErr.addNamespaceDeclaration("ns2","http://www.w3.org/2001/XMLSchema");
		    envelopeErr.addNamespaceDeclaration("ns1", "http://schemas.xmlsoap.org/soap/envelope/");
		    envelopeErr.addNamespaceDeclaration("SOAP-ENC","http://schemas.xmlsoap.org/soap/encoding/");
		    envelopeErr.addNamespaceDeclaration("SOAP-ENV","http://schemas.xmlsoap.org/soap/envelope/");
		    
		    SOAPBody soapBodyErr = envelopeErr.getBody();
		    SOAPElement addArtifact = soapBodyErr.addChildElement(envelopeErr.createName("addArtifact","ns3","http://schemas.xmlsoap.org/soap/envelope/"));
		    addArtifact.addChildElement("session_ser").addTextNode(sess_key).setAttribute("xsi:type","ns2:string");
		    addArtifact.addChildElement("group_id").addTextNode(group_id).setAttribute("xsi:type","ns2:int");
		    addArtifact.addChildElement("group_artifact_id").addTextNode(group_artifact_id).setAttribute("xsi:type","ns2:int");
		    addArtifact.addChildElement("status_id").addTextNode(status_id).setAttribute("xsi:type","ns2:int");
		    addArtifact.addChildElement("priority").addTextNode(priority).setAttribute("xsi:type","ns2:int");
		    addArtifact.addChildElement("assigned_to").addTextNode(assigned_to).setAttribute("xsi:type","ns2:int");
		    addArtifact.addChildElement("summary").addTextNode(p_sum).setAttribute("xsi:type","ns2:string");
		    addArtifact.addChildElement("details").addTextNode(prob).setAttribute("xsi:type","ns2:string");
		    soapMessageErr.saveChanges();
		    
		    //Send the error
		    SOAPMessage rp_err = soapConnection.call(soapMessageErr,url);
		    
		    //Send a final message to logout and close the conenction
		    MessageFactory messageFactoryLogout = MessageFactory.newInstance();
		    SOAPMessage soapMessageLogout = messageFactoryLogout.createMessage();
		    SOAPPart soapPartLogout = soapMessageLogout.getSOAPPart();
		    SOAPEnvelope envelopeLogout = soapPartLogout.getEnvelope();
		    
		    envelopeLogout.addNamespaceDeclaration("ns3","http://www.nitrc.org");
		    envelopeLogout.addNamespaceDeclaration("ns2","http://www.w3.org/2001/XMLSchema");
		    envelopeLogout.addNamespaceDeclaration("ns1", "http://schemas.xmlsoap.org/soap/envelope/");
		    envelopeLogout.addNamespaceDeclaration("SOAP-ENC","http://schemas.xmlsoap.org/soap/encoding/");
		    envelopeLogout.addNamespaceDeclaration("SOAP-ENV","http://schemas.xmlsoap.org/soap/envelope/");
		    
		    SOAPBody soapBodyLogout = envelopeLogout.getBody();
		    SOAPElement logout = soapBodyLogout.addChildElement(envelopeLogout.createName("logout","ns3","http://schemas.xmlsoap.org/soap/envelope/"));
		    addArtifact.addChildElement("session_ser").addTextNode(sess_key).setAttribute("xsi:type","ns2:string");

		    soapMessageErr.saveChanges();
		    
		    SOAPMessage rp_logout = soapConnection.call(soapMessageLogout,url);
		    
		    //Close the connection 
		    soapConnection.close();
		    
		 
			}
			catch (Exception e){
				System.out.println(e.getMessage());
			}
		    
			//HttpClient client = new HttpClient();
			//client.getParams().setParameter("http.useragent", "JIST Client");

			BufferedReader br = null;

				/*
				 * http://www.nitrc.org/tracker/index.php?group_id=228&atid=942&func=postadd&user_email=test%40test.name&submit=Submit&extra_fields%5B4384%5D=100&extra_fields%5B4383%5D=100&extra_fields%5B4382%5D=100&extra_fields%5B4381%5D=100&extra_fields%5B4380%5D=100&extra_fields%5B4379%5D=100&extra_fields%5B4378%5D=100&extra_fields%5B4385%5D=&summary=sfsaf&details=afsdaf
				 */

				/*			
//			extra_fields%%5D=100&extra_fields%%5D=100&extra_fields%%5D=&summary=sfsaf&details=afsdaf
			StringBuffer url = new StringBuffer("http://www.nitrc.org/tracker/index.php?group_id=228&atid=942&func=postadd&");
			url.append(encode("group_id","228")+"&");
			url.append(encode("atid","942")+"&");
			url.append(encode("func","postadd")+"&");
			url.append(encode("user_email",email.getText())+"&");
			url.append(encode("submit","Submit")+"&");
//			url.append(encode("extra_fields[4384]","100")+"&");
//			url.append(encode("extra_fields[4382]","100")+"&");
//			url.append(encode("extra_fields[4381]","100")+"&");
//			url.append(encode("extra_fields[4380]","100")+"&");
//			url.append(encode("extra_fields[4379]","100")+"&");
//			url.append(encode("extra_fields[4378]","100")+"&");
//			url.append(encode("extra_fields[4385]","")+"&");
			url.append(encode("summary", problem.getText())+"&");
			url.append(encode("details", mipav.getText()+jist.getText()+jvm.getText()));

			GetMethod method = new GetMethod(url.toString());
				 */
				//			
				////			&user_email=test			
				//			method.addParameter("summary", problem.getText());
				//			method.addParameter("details", mipav.getText()+jist.getText()+jvm.getText());



				//MultipartPostMethod method = new MultipartPostMethod("https://www.nitrc.org/tracker/index.php");
				//method.addParameter("func","postadd");
				//method.addParameter("group_id","228");
				//method.addParameter("atid","2811");
				//method.addParameter("user_email","bennett.landman@vanderbilt.edu");
				//method.addParameter("submit","Submit");
				//				method.addParameter("extra_fields[4384]","100");
				//				method.addParameter("extra_fields[4382]","100");
				//				method.addParameter("extra_fields[4381]","100");
				//				method.addParameter("extra_fields[4380]","100");
				//				method.addParameter("extra_fields[4379]","100");
				//				method.addParameter("extra_fields[4378]","100");
				//				method.addParameter("extra_fields[4385]","");
				//				
				////				&user_email=test			
				//method.addParameter("summary", summary.getText());
				//method.addParameter("details", problem.getText());



				/*
				File f1 = new File(JistPreferences.getPreferences().getLastDirectory(),"ProblemFile.xml");
				FileWriter fp = new FileWriter(f1);
				fp.write(file.getText());
				fp.close();
				method.addParameter("input_file[]", f1);

				File f2 = new File(JistPreferences.getPreferences().getLastDirectory(),"SystemDetails.txt");
				fp = new FileWriter(f2);
				fp.write(mipav.getText()+"\n\n\n"+jist.getText()+"\n\n\n"+jvm.getText());
				fp.close();
				method.addParameter("input_file[]", f2);

				File f3 = new File(JistPreferences.getPreferences().getLastDirectory(),"ContactInfo.txt");
				fp = new FileWriter(f3);
				fp.write("name: "+username.getText()+"\nemail: "+email.getText());
				fp.close();
				method.addParameter("input_file[]", f3);
				//
				//				f1.delete();
				//				f2.delete();
				*/
				/*
				try{
					
					//int returnCode = client.executeMethod(method);
					int returnCode = 0;

					if(returnCode == HttpStatus.SC_NOT_IMPLEMENTED) {
						System.err.println("The Post method is not implemented by this URI");
						// still consume the response body
						method.getResponseBodyAsString();
					} else {
						br = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
						String readLine;
						while(((readLine = br.readLine()) != null)) {
							System.err.println(readLine);
						}
					}
				} catch (Exception e) {
					System.err.println(e);
				} finally {
					method.releaseConnection();
					if(br != null) try { br.close(); } catch (Exception fe) {}
				}
				f1.delete();
				f2.delete();
				f3.delete();
			} catch (Exception e) {
				System.err.println(e);
			}
			/*
			/*
			HttpClient client = new HttpClient();
			client.getParams().setParameter("http.useragent", "JIST Client");

			BufferedReader br = null;

			PostMethod method = new PostMethod("http://spreadsheets.google.com/formResponse?formkey=dHlfaEpHTEpfMExhR2ZPTjIwOTJadmc6MQ&amp;ifq");
//			method.addParameter("formkey", "dHlfaEpHTEpfMExhR2ZPTjIwOTJadmc6MQ&amp;ifq");
			method.addParameter("entry.0.single", "test test test");
			method.addParameter("entry.2.single", email.getText());
			method.addParameter("entry.6.single",problem.getText());
			method.addParameter("entry.7.group", file.getText());
			method.addParameter("entry.4.single",mipav.getText() );
			method.addParameter("entry.3.single",jist.getText() );
			method.addParameter("entry.3.single",jvm.getText() );


			try{
				int returnCode = client.executeMethod(method);

				if(returnCode == HttpStatus.SC_NOT_IMPLEMENTED) {
					System.err.println("The Post method is not implemented by this URI");
					// still consume the response body
					method.getResponseBodyAsString();
				} else {
					br = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
					String readLine;
					while(((readLine = br.readLine()) != null)) {
						System.err.println(readLine);
					}
				}
			} catch (Exception e) {
				System.err.println(e);
			} finally {
				method.releaseConnection();
				if(br != null) try { br.close(); } catch (Exception fe) {}
			}
			 */

			/*
			try { 
				// Construct data


				String data = URLEncoder.encode("entry.0.single", "UTF-8") + "=" + URLEncoder.encode(username.getText(), "UTF-8"); 
				data += "&" + URLEncoder.encode("entry.2.single", "UTF-8") + "=" + URLEncoder.encode(email.getText(), "UTF-8"); 
				data += "&" + URLEncoder.encode("entry.6.single", "UTF-8") + "=" + URLEncoder.encode(problem.getText(), "UTF-8");
				data += "&" + URLEncoder.encode("entry.7.group", "UTF-8") + "=" + URLEncoder.encode(file.getText(), "UTF-8");
				data += "&" + URLEncoder.encode("entry.4.single", "UTF-8") + "=" + URLEncoder.encode(mipav.getText(), "UTF-8");
				data += "&" + URLEncoder.encode("entry.3.single", "UTF-8") + "=" + URLEncoder.encode(jist.getText(), "UTF-8");
				data += "&" + URLEncoder.encode("entry.5.single", "UTF-8") + "=" + URLEncoder.encode(jvm.getText(), "UTF-8");

				// Send data 
				URL url = new URL("http://spreadsheets.google.com/formResponse?formkey=dHlfaEpHTEpfMExhR2ZPTjIwOTJadmc6MQ&amp;ifq"); 
				URLConnection conn = url.openConnection(); 
				conn.setDoOutput(true); 
				OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream()); 
				wr.write(data); wr.flush(); 

				// Get the response 
				BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream())); 
				String line; 
				while ((line = rd.readLine()) != null) { 
					// Process line...
					} 
				wr.close(); rd.close(); 
				JOptionPane.showMessageDialog(this,"Message sent","Bug report",JOptionPane.INFORMATION_MESSAGE);	
				}

			catch (Exception e1) {
				JOptionPane.showMessageDialog(this,"Message failed:"+e1.getMessage(),"Bug report",JOptionPane.ERROR_MESSAGE);

			} 
			 */
		}

		@Override
		public void actionPerformed(ActionEvent evt) {
			// TODO Auto-generated method stub
			if(evt.getSource()==cancel) {
				this.setVisible(false);
				this.dispose();
			} else if(evt.getSource()==submit) {
				submit();
				this.setVisible(false);
				this.dispose(); 
			}

		}

	}


	public void zipFiles(ZipOutputStream out, File f, String base) throws FileNotFoundException {
		// TODO Auto-generated method stub
		if (f.isDirectory()){
			File[] f1 = f.listFiles();
			try {
				out.putNextEntry(new ZipEntry(base + "/"));
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			base = base.length() == 0 ? "" : base + "/";
			for (int i = 0; i < f1.length; i++){
				zipFiles(out, f1[i], base + f1[i].getName());
			}
		}
			else{
				try {
					out.putNextEntry(new ZipEntry(base));
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				FileInputStream in = new FileInputStream(f);
				int b;
				try {
					while ((b = in.read()) != -1){
						out.write(b);
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				try {
					in.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}



}


