package edu.jhu.ece.iacl.jist.pipeline.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.Vector;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import gov.nih.mipav.view.Preferences;

public class JSONPluginParser {
	
	JSONObject jsonObj;	
    File jsonFile;
	JSONArray inputs;
	JSONArray outputs;
	JSONObject header;
	boolean runStatus = false;
	final File jistLib = new File(Preferences.getProperty("JIST_Library_Directory"));
    public String pluginInitTest;
	String pluginPackage;
	String pluginCategory;
	String pluginLabel;
	String pluginName;
	String shortDescription;
	String longDescription;
	String authorAffiliation;
	String authorName;
	String authorEmail;
	String authorWebsite;
	
	List<String> paramTypes = Arrays.asList("ParamString", "ParamFile", "ParamVolume", "ParamDouble",
											"ParamFloat", "ParamLong", "ParamInteger");	//These are the supported types currently
	
	final List<String> requiredInputArgs = Arrays.asList("type", "required", "arg", "name");	//These are required for each input to the module
	final List<String> requiredOutputArgs = Arrays.asList("type", "required", "arg", "name", "output");	//These are required for each input to the module
	
	
	public JSONPluginParser(File jsonFile) throws JSONException, FileNotFoundException{
		this.jsonFile=jsonFile;
		readFileToJSONObject(jsonFile);
		initInputs();
		initOutputs();
		initProgramInfo();
		
		
	}
	
	/**
	 * Write the plugin
	 * @throws FileNotFoundException
	 * @throws JSONException
	 */
	public void writePlugin() throws FileNotFoundException, JSONException{
		String[] tmp = this.pluginCategory.split("\\.");
		File outputPath = new File(jistLib.getAbsolutePath(),this.pluginPackage);
		outputPath = new File(outputPath.getAbsolutePath(),StringUtils.join(tmp,File.separator));
		System.out.println(outputPath.getAbsolutePath());
		if (!outputPath.exists()){
			JistLogger.logOutput(JistLogger.FINE, String.format("Output path %s does not exist. Creating now.", outputPath.getAbsolutePath()));
			boolean result = outputPath.mkdirs();
			if (!result){
				throw new RuntimeException("Could not create output directory for plugin");
			}
		}
		File outputModule = new File(outputPath,String.format("%s.module", FilenameUtils.getBaseName(jsonFile.getAbsolutePath())));
		System.out.println(outputModule.getAbsoluteFile());
		FileWriter w;
		
		try {
			
			w = new FileWriter(outputModule);
			w.write(getSpace(0)+"<edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm>"+"\n");
			w.write(getSpace(2)+"<expectedWallTime>0</expectedWallTime>"+"\n");
	        w.write(getSpace(2)+"<label>"+this.pluginLabel+"</label>"+"\n");
	        w.write(getSpace(2)+"<name>"+this.pluginName+"</name>"+"\n");
	        w.write(getSpace(2)+"<inputPorts>"+"\n");
	        w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInformation>"+"\n");
	        w.write(getSpace(6)+"<info>"+"\n");
	        w.write(getSpace(8)+"<authors>"+"\n");
	        
	  
	        w.write(getSpace(10)+"<edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation-AlgorithmAuthor>"+"\n");
	        w.write(getSpace(12)+"<website>"+this.authorWebsite+"</website>"+"\n");
	        w.write(getSpace(12)+"<author>"+this.authorName+"</author>"+"\n");
	        
	        w.write(getSpace(12)+"<email>"+this.authorEmail+"</email>"+"\n");
	        w.write(getSpace(10)+"</edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation-AlgorithmAuthor>"+"\n");
	        w.write(getSpace(8)+"</authors>"+"\n");
	        
	        w.write(getSpace(8)+"<citations/>"+"\n");
	        w.write(getSpace(8)+"<version>1.2</version>"+"\n");
	        w.write(getSpace(8)+"<description>"+this.shortDescription+"</description>"+"\n");
	        w.write(getSpace(8)+"<longdescription>"+this.longDescription+"</longdescription>"+"\n");
	        w.write(getSpace(8)+"<website>"+this.authorWebsite+"</website>"+"\n");
	        w.write(getSpace(8)+"<affiliation>"+this.authorAffiliation+"</affiliation>"+"\n");
	        w.write(getSpace(8)+"<name>"+this.pluginName+"</name>"+"\n");
	        w.write(getSpace(8)+"<label>"+this.pluginLabel+"</label>"+"\n");
	        
	        //Send all through the generalize class
	        if (runStatus){
	        	w.write(getSpace(8)+"<algorithmClass>edu.jhu.ece.iacl.jist.pipeline.parser.JistJSONPlugin</algorithmClass>"+"\n");
	        }else{
        		w.write(getSpace(8)+"<algorithmClass>edu.jhu.ece.iacl.jist.pipeline.parser.JistJSONFailedPlugin</algorithmClass>"+"\n");	
        	}
	        w.write(getSpace(8)+"<devStatus>ALPHA</devStatus>"+"\n");
	        w.write(getSpace(8)+"<editable>false</editable>"+"\n");
	        w.write(getSpace(6)+"</info>"+"\n");
	        w.write(getSpace(6)+"<name>Algorithm Information</name>"+"\n");
	        w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        w.write(getSpace(6)+"<incomingConnectors/>"+"\n");
	        w.write(getSpace(6)+"<mandatory>true</mandatory>"+"\n");
	        w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInformation>"+"\n");
	        
	        boolean flagParamFile = false;
	        boolean flagParamVolume = false;
	        for (int i=0 ; i<this.inputs.length();i++){
	        	JSONObject obj = this.inputs.getJSONObject(i);
	        	String thisType = (String) obj.get("type");
	        	String thisReqStatus = (String) obj.get("required");
	        	String thisName = (String) obj.get("name");
	        	
	        	//IS OF TYPE PARAMVOLUME
	        	if (thisType.equals("ParamVolume")){
	        		ArrayList<String> theParamVolume;
	        		if (!flagParamVolume){
	        			theParamVolume = buildParamVolume(i,"in",flagParamVolume);
	        			flagParamVolume = true;
	        		}else{
	        			theParamVolume = buildParamVolume(i,"in",flagParamVolume);
	        		}
	        		for (String s: theParamVolume){
	        			w.write(s);
	        		}
	        	//Is of type PARAMFLOAT
	        	}else if (thisType.equals("ParamFloat")){

	        	//IS of type PARAMBOOLEAN	
	        	}else if (thisType.equals("ParamBoolean")){
	        		
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean>"+"\n");
	        		w.write(getSpace(6)+"<value>false</value>"+"\n");
    				w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
    				w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        		w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        	    w.write(getSpace(6)+"<incomingConnectors/>"+"\n");
	        	    w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
	        	    w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean>"+"\n");
	        	}
	        	//IS OF TYPE PARAMINT
	        	else if (thisType.equals("ParamInteger")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger>"+"\n");
	        	    w.write(getSpace(6)+"<value class=\"int\">1000</value>"+"\n");
    	    		w.write(getSpace(6)+"<min class=\"int\">0</min>"+"\n");
    				w.write(getSpace(6)+"<max class=\"int\">100000</max>"+"\n");
					w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
					w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
					w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
				    w.write(getSpace(6)+"<incomingConnectors/>"+"\n");
				    w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
				    w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger>"+"\n");
	        	}
	        	//Is of type ParamDouble
	        	else if (thisType.equals("ParamDouble")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble>"+"\n");
	        	    w.write(getSpace(6)+"<value class=\"double\">1000</value>"+"\n");
    	    		w.write(getSpace(6)+"<min class=\"double\">0</min>"+"\n");
    				w.write(getSpace(6)+"<max class=\"double\">100000</max>"+"\n");
					w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
					w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
					w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
				    w.write(getSpace(6)+"<incomingConnectors/>"+"\n");
				    w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
				    w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble>"+"\n");
	        	}
	        	//Is of type ParamLong
	        	else if (thisType.equals("ParamLong")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong>"+"\n");
	        	    w.write(getSpace(6)+"<value class=\"long\">1000</value>"+"\n");
    	    		w.write(getSpace(6)+"<min class=\"long\">0</min>"+"\n");
    				w.write(getSpace(6)+"<max class=\"long\">100000</max>"+"\n");
					w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
					w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
					w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
				    w.write(getSpace(6)+"<incomingConnectors/>"+"\n");
				    w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
				    w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong>"+"\n");
	        	}
	        	//Is of type ParamFile
	        	else if (thisType.equals("ParamFile")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile>"+"\n");
    				w.write(getSpace(6)+"<extensionFilter>"+"\n");
					w.write(getSpace(8)+"<exts>"+"\n");
					//FIX THIS
					w.write(getSpace(10)+"<string>java</string>"+"\n");
					w.write(getSpace(8)+"</exts>"+"\n");
					w.write(getSpace(6)+"<preferredExtension>0</preferredExtension>"+"\n");
					w.write(getSpace(6)+"</extensionFilter>"+"\n");
					if (!flagParamFile){
						w.write(getSpace(6)+"<dialogType>FILE</dialogType>\n");
						flagParamFile = true;
					}else{
						w.write(getSpace(6)+"<dialogType reference=\"../../edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume/dialogType\"/>"+"\n");
					}
					w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
					w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
					w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
					w.write(getSpace(6)+"<incomingConnectors/>"+"\n");
					w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
					w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile>"+"\n");
	        	}
	            
	        	else if (thisType.equals("ParamString")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString>"+"\n");
    				w.write(getSpace(6)+"<string></string>"+"\n");
					w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
					w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
					w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
					w.write(getSpace(6)+"<incomingConnectors/>"+"\n");
					w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
					w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString>"+"\n");

	        	}
	        	
	        }
	        
	        w.write(getSpace(2)+"</inputPorts>"+"\n");
	        w.write(getSpace(2)+"<outputPorts>"+"\n");
	        
	        flagParamVolume = false;
	        flagParamFile = false;
	        for (int i=0 ; i<this.outputs.length();i++){
	        	JSONObject obj = this.outputs.getJSONObject(i);
	        	String thisType = (String) obj.get("type");
	        	String thisReqStatus = (String) obj.get("required");
	        	String thisName = (String) obj.get("name");
	        	String thisValue = (String) obj.get("output");

	        	//IS OF TYPE PARAMVOLUME
	        	if (thisType.equals("ParamVolume")){
	        		ArrayList<String> theParamVolume;
	        		if (!flagParamVolume){
	        			theParamVolume = buildParamVolume(i,"out",flagParamVolume);
	        			flagParamVolume = true;
	        		}else{
	        			theParamVolume = buildParamVolume(i,"out",flagParamVolume);
	        		}
	        		for (String s: theParamVolume){
	        			w.write(s);
	        		}
	        	//Is of Type ParamFloat
	        	}else if (thisType.equals("ParamFloat")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat>"+"\n");
	        		w.write(getSpace(6)+"<value class=\"float\">0.0</value>"+"\n");
	        		w.write(getSpace(6)+"<min class=\"float\">-1.0E20</min>"+"\n");
	        		w.write(getSpace(6)+"<max class=\"float\">1.0E20</max>"+"\n");
	        		w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
	        		w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        		w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        		w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
	        		w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
	        		w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat>"+"\n");
	        		
	        	//IS of type PARAMBOOLEAN	
	        	}else if (thisType.equals("ParamBoolean")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean>"+"\n");
	        		w.write(getSpace(6)+"<value>"+thisValue+"</value>"+"\n");
	        		w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
	        		w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        		w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        		w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
	        		w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
	        		w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean>"+"\n");

	        	}
	        	//IS OF TYPE PARAMINT
	        	else if (thisType.equals("ParamInteger")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger>"+"\n");
	        		w.write(getSpace(6)+"<value class=\"int\">0</value>"+"\n");
	        		w.write(getSpace(6)+"<min class=\"int\">-1000000000</min>"+"\n");
	        		w.write(getSpace(6)+"<max class=\"int\">1000000000</max>"+"\n");
	        		w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
	        		w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        		w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        		w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
	        		w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
	        		w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger>"+"\n");
	        	}
	        	//Is of type ParamDouble
	        	else if (thisType.equals("ParamDouble")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble>"+"\n");
        	        w.write(getSpace(6)+"<value class=\"double\">0.0</value>"+"\n");
	        	    w.write(getSpace(6)+"<min class=\"double\">-1.0E20</min>"+"\n");
	        	    w.write(getSpace(6)+"<max class=\"double\">1.0E20</max>"+"\n");
        	        w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
    	        	w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
    	        	w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
    	        	w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
    	        	w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
	        	    w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble>"+"\n");

	        	}
	        	//Is of type ParamLong
	        	else if (thisType.equals("ParamLong")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong>"+"\n");
	        		w.write(getSpace(6)+"<value class=\"int\">0</value>"+"\n");
	        		w.write(getSpace(6)+"<min class=\"long\">-1000000000</min>"+"\n");
	        		w.write(getSpace(6)+"<max class=\"long\">1000000000</max>"+"\n");
	        		w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
	        		w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        		w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        		w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
	        		w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
	        	    w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong>"+"\n");
	        	}
	        	//Is of type ParamFile
	        	else if (thisType.equals("ParamFile")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile>"+"\n");
    				w.write(getSpace(6)+"<extensionFilter>"+"\n");
					w.write(getSpace(8)+"<exts/>"+"\n");
					w.write(getSpace(8)+"<preferredExtension>0</preferredExtension>"+"\n");
					w.write(getSpace(6)+"</extensionFilter>"+"\n");
					
					if (!flagParamFile){
						w.write(getSpace(6)+"<dialogType>FILE</dialogType>"+"\n");
						flagParamFile = true;
					}else{
						w.write(getSpace(6)+"<dialogType reference=\"../../edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile/dialogType\"/>"+"\n");	
					}
					w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
					w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
					w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
					w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
					w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
					w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile>"+"\n");
	        	}
	            
	        	//Is of type ParamString
	        	else if (thisType.equals("ParamString")){
	        		w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString>"+"\n");
	        		w.write(getSpace(6)+"<string>"+thisValue+"</string>"+"\n");
	        		w.write(getSpace(6)+"<name>"+thisName+"</name>"+"\n");
	        		w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        		w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        		w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
	        		w.write(getSpace(6)+"<mandatory>"+thisReqStatus+"</mandatory>"+"\n");
	        		w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString>"+"\n");
	        	}
	        	
	        }
	        
	        
	        
	        w.write(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamPerformance>"+"\n");
	        w.write(getSpace(6)+"<name>Execution Time</name>"+"\n");
	        w.write(getSpace(6)+"<hidden>false</hidden>"+"\n");
	        w.write(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>"+"\n");
	        w.write(getSpace(6)+"<outgoingConnectors/>"+"\n");
	        w.write(getSpace(6)+"<mandatory>true</mandatory>"+"\n");
	        w.write(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamPerformance>"+"\n");
	        w.write(getSpace(2)+"</outputPorts>"+"\n");
	        w.write(getSpace(2)+"<inputParams>"+"\n");
	        w.write(getSpace(4)+"<connectionCount>"+String.valueOf(this.inputs.length()+2)+"</connectionCount>"+"\n");
	        w.write(getSpace(4)+"<children>"+"\n");
	        w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamHeader>"+"\n");
	        
	        if (runStatus){
	        	w.write(getSpace(8)+"<className>edu.jhu.ece.iacl.jist.pipeline.parser.JistJSONPlugin</className>"+"\n");
	        }else{
	        	w.write(getSpace(8)+"<className>edu.jhu.ece.iacl.jist.pipeline.parser.JistJSONFailedPlugin</className>"+"\n");
	        }
	        w.write(getSpace(8)+"<version>1.2</version>"+"\n");
	        w.write(getSpace(8)+"<uuid>"+UUID.randomUUID().toString()+"</uuid>"+"\n");
	        w.write(getSpace(8)+"<name>Algorithm</name>"+"\n");
	        w.write(getSpace(8)+"<hidden>true</hidden>"+"\n");
	        w.write(getSpace(8)+"<incomingConnectors/>"+"\n");
	        w.write(getSpace(8)+"<mandatory>true</mandatory>"+"\n");
	        w.write(getSpace(6)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamHeader>"+"\n");
	        w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInformation reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInformation\"/>"+"\n");
	        int paramStringCnt=0;
	        int paramDoubleCnt=0;
	        int paramFileCnt=0;
	        int paramVolumeCnt=0;
	        int paramLongCnt=0;
	        int paramFloatCnt=0;
	        int paramBooleanCnt=0;
	        int paramIntCnt=0;
	        for (int i=0;i<this.inputs.length();i++){
	        	JSONObject obj = this.inputs.getJSONObject(i);
	        	String thisType = (String) obj.get("type");
	        	if (thisType.equals("ParamString") && paramStringCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString\"/>"+"\n");
	        		paramStringCnt++;
	        	}else if (thisType.equals("ParamString")&& paramStringCnt >0){
	        		paramStringCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString["+String.valueOf(paramStringCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamInteger") && paramIntCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger\"/>"+"\n");
	        		paramIntCnt++;
	        	}else if (thisType.equals("ParamInteger")&& paramIntCnt >0){
	        		paramIntCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger["+String.valueOf(paramIntCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamDouble") && paramDoubleCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble\"/>"+"\n");
	        		paramDoubleCnt++;
	        	}else if (thisType.equals("ParamDouble")&& paramDoubleCnt >0){
	        		paramDoubleCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble["+String.valueOf(paramDoubleCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamFloat") && paramFloatCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat\"/>"+"\n");
	        		paramFloatCnt++;
	        	}else if (thisType.equals("ParamFloat")&& paramFloatCnt >0){
	        		paramFloatCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat["+String.valueOf(paramFloatCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamLong") && paramLongCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong\"/>"+"\n");
	        		paramLongCnt++;
	        	}else if (thisType.equals("ParamLong")&& paramLongCnt >0){
	        		paramLongCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong["+String.valueOf(paramLongCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamFile") && paramFileCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile\"/>"+"\n");
	        		paramFileCnt++;
	        	}else if (thisType.equals("ParamFile")&& paramFileCnt >0){
	        		paramFileCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile["+String.valueOf(paramFileCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamVolume") && paramVolumeCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume\"/>"+"\n");
	        		paramVolumeCnt++;
	        	}else if (thisType.equals("ParamVolume")&& paramVolumeCnt >0){
	        		paramVolumeCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume["+String.valueOf(paramVolumeCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamBoolean") && paramBooleanCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean\"/>"+"\n");
	        		paramBooleanCnt++;
	        	}else if (thisType.equals("ParamBoolean")&& paramBooleanCnt >0){
	        		paramBooleanCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean reference=\"../../../inputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean["+String.valueOf(paramBooleanCnt)+"]\"/>"+"\n");
	        	}
	        }
	        
	        
	        w.write(getSpace(4)+"</children>"+"\n");
	        w.write(getSpace(4)+"<category>"+this.pluginCategory+"</category>"+"\n");
	        w.write(getSpace(4)+"<pkg>"+this.pluginPackage+"</pkg>"+"\n");
	        w.write(getSpace(4)+"<label>"+this.pluginLabel+"</label>"+"\n");
	        w.write(getSpace(4)+"<name>"+this.pluginName+"</name>"+"\n");
	        w.write(getSpace(4)+"<hidden>false</hidden>"+"\n");
	        w.write(getSpace(4)+"<incomingConnectors/>"+"\n");
	        w.write(getSpace(4)+"<mandatory>true</mandatory>"+"\n");
	        
	        
	        w.write(getSpace(2)+"</inputParams>"+"\n");
	        w.write(getSpace(2)+"<outputParams>"+"\n");
	        w.write(getSpace(4)+"<connectionCount>"+String.valueOf(this.outputs.length()+2)+"</connectionCount>"+"\n");
	        w.write(getSpace(4)+"<children>"+"\n");
	        w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamHeader>"+"\n");
	        if (runStatus){
	        	w.write(getSpace(8)+"<className>edu.jhu.ece.iacl.jist.pipeline.parser.JistJSONPlugin</className>"+"\n");
	        }else{
	        	w.write(getSpace(8)+"<className>edu.jhu.ece.iacl.jist.pipeline.parser.JistJSONFailedPlugin</className>"+"\n");
	        }
	        w.write(getSpace(8)+"<version>1.2</version>"+"\n");
	        w.write(getSpace(8)+"<uuid>"+UUID.randomUUID().toString()+"</uuid>"+"\n");
	        w.write(getSpace(8)+"<name>Algorithm</name>"+"\n");
	        w.write(getSpace(8)+"<hidden>true</hidden>"+"\n");
	        w.write(getSpace(8)+"<incomingConnectors/>"+"\n");
	        w.write(getSpace(8)+"<mandatory>true</mandatory>"+"\n");
	        w.write(getSpace(6)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamHeader>"+"\n");
	        
	        paramStringCnt=0;
	        paramDoubleCnt=0;
	        paramFileCnt=0;
	        paramVolumeCnt=0;
	        paramLongCnt=0;
	        paramFloatCnt=0;
	        paramBooleanCnt=0;
	        paramIntCnt=0;
	        for (int i=0;i<this.outputs.length();i++){
	        	JSONObject obj = this.outputs.getJSONObject(i);
	        	String thisType = (String) obj.get("type");
	        	if (thisType.equals("ParamString") && paramStringCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString\"/>"+"\n");
	        		paramStringCnt++;
	        	}else if (thisType.equals("ParamString")&& paramStringCnt >0){
	        		paramStringCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString["+String.valueOf(paramStringCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamInteger") && paramIntCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger\"/>"+"\n");
	        		paramIntCnt++;
	        	}else if (thisType.equals("ParamInteger")&& paramIntCnt >0){
	        		paramIntCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger["+String.valueOf(paramIntCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamDouble") && paramDoubleCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble\"/>"+"\n");
	        		paramDoubleCnt++;
	        	}else if (thisType.equals("ParamDouble")&& paramDoubleCnt >0){
	        		paramDoubleCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble["+String.valueOf(paramDoubleCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamFloat") && paramFloatCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat\"/>"+"\n");
	        		paramFloatCnt++;
	        	}else if (thisType.equals("ParamFloat")&& paramFloatCnt >0){
	        		paramFloatCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat["+String.valueOf(paramFloatCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamLong") && paramLongCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong\"/>"+"\n");
	        		paramLongCnt++;
	        	}else if (thisType.equals("ParamLong")&& paramLongCnt >0){
	        		paramLongCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamLong["+String.valueOf(paramLongCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamFile") && paramFileCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile\"/>"+"\n");
	        		paramFileCnt++;
	        	}else if (thisType.equals("ParamFile")&& paramFileCnt >0){
	        		paramFileCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile["+String.valueOf(paramFileCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamVolume") && paramVolumeCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume\"/>"+"\n");
	        		paramVolumeCnt++;
	        	}else if (thisType.equals("ParamVolume")&& paramVolumeCnt >0){
	        		paramVolumeCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume["+String.valueOf(paramVolumeCnt)+"]\"/>"+"\n");
	        	}else if (thisType.equals("ParamBoolean") && paramBooleanCnt==0){
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean\"/>"+"\n");
	        		paramBooleanCnt++;
	        	}else if (thisType.equals("ParamBoolean")&& paramBooleanCnt >0){
	        		paramBooleanCnt++;
	        		w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean["+String.valueOf(paramBooleanCnt)+"]\"/>"+"\n");
	        	}
	        }
	        w.write(getSpace(6)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamPerformance reference=\"../../../outputPorts/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamPerformance\"/>"+"\n");
	        w.write(getSpace(4)+"</children>"+"\n");
	        w.write(getSpace(4)+"<pkg>Base</pkg>"+"\n");
	        w.write(getSpace(4)+"<label>"+this.pluginLabel+"</label>"+"\n");
	        w.write(getSpace(4)+"<name>"+this.pluginName+"</name>"+"\n");
	        w.write(getSpace(4)+"<hidden>false</hidden>"+"\n");
	        w.write(getSpace(4)+"<incomingConnectors/>"+"\n");
	        w.write(getSpace(4)+"<mandatory>true</mandatory>"+"\n");
	        w.write(getSpace(2)+"</outputParams>"+"\n");
	        w.write(getSpace(0)+"</edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm>");
			w.close();
			JistLogger.logOutput(JistLogger.FINE,String.format("Successfully wrote plugin to %s", outputModule.getAbsoluteFile().toString()));
			
		} catch (IOException e) {
			JistLogger.logError(JistLogger.SEVERE, "ERROR encountered during plugin writing");
			e.printStackTrace();
		}
		
	}

	/**
	 * Init the program information strings
	 * @throws JSONException
	 */
	private void initProgramInfo() throws JSONException{
		this.header = jsonObj.getJSONObject("programInfo");
		pluginInitTest = header.getString("pluginInitTest");
		pluginPackage = header.getString("pluginPackage");
		pluginCategory = header.getString("pluginCategory");
		pluginLabel = header.getString("pluginLabel");
		pluginName = header.getString("pluginName");
		shortDescription = header.getString("shortDescription");
		longDescription = header.getString("longDescription");
		authorAffiliation = header.getString("authorAffiliation");
		authorName = header.getString("authorName");
		authorEmail = header.getString("authorEmail");
		authorWebsite = header.getString("authorWebsite");			
	}
	
	
	/**
	 * Check that each output to the module has the required args
	 * @throws JSONException
	 */
	private void initOutputs() throws JSONException{
		this.outputs = jsonObj.getJSONArray("outputParams");
		for (int i=0; i<outputs.length(); i++){
			JSONObject tempObject = outputs.getJSONObject(i);
			Iterator keys = tempObject.keys();
			List<String> tempKeys = new ArrayList<String>();
			
			//Check that the keys are first spelled correctly
			while(keys.hasNext()){
				String thisKey = keys.next().toString();
				tempKeys.add(thisKey);
				boolean flag = false;
				for (String s: requiredOutputArgs){
					if (thisKey.equals(s)){
						flag = true;
						break;
					}
				}
				if (!flag){
					throw new RuntimeException(String.format("Failed to parse arg for output at JSON Object %d in outputs\nOutputs must be name, required, arg, type.",i));
				}
			}
			//Now check that we have all of the required keys
			List diff = new ArrayList(requiredOutputArgs);
			diff.removeAll(tempKeys);
			if (diff.size() != 0){
				throw new RuntimeException(String.format("Failed to parse arg for output at JSON Object %d in outputs\nMissing a required output arg(s) %s",i,diff.toString()));
			}
		}
	}
	
	
	/**
	 * Check that each input to the module has the required args
	 * @throws JSONException
	 */
	private void initInputs() throws JSONException{
		
		this.inputs = jsonObj.getJSONArray("inputParams");
		for (int i=0; i<inputs.length(); i++){
			JSONObject tempObject = inputs.getJSONObject(i);
			Iterator keys = tempObject.keys();
			List<String> tempKeys = new ArrayList<String>();
			
			//Check that the keys are first spelled correctly
			while(keys.hasNext()){
				String thisKey = keys.next().toString();
				tempKeys.add(thisKey);
				boolean flag = false;
				for (String s: requiredInputArgs){
					if (thisKey.equals(s)){
						flag = true;
						break;
					}
				}
				if (!flag){
					throw new RuntimeException(String.format("Failed to parse arg for input at JSON Object %d in inputs\nInputs must be name, required, arg, type.",i));
				}
			}
			//Now check that we have all of the required keys
			List diff = new ArrayList(requiredInputArgs);
			diff.removeAll(tempKeys);
			if (diff.size() != 0){
				throw new RuntimeException(String.format("Failed to parse arg for input at JSON Object %d in inputs\nMissing a required input arg(s) %s",i,diff.toString()));
			}
			
		}
	}
	
	
	/**
	 * Read in the json object file and make sure it is valid. Set the jsonObj if read in properly. null otherwise
	 * @param jsonFile
	 */
	private void readFileToJSONObject(File jsonFile){
		BufferedReader reader;
		String output = "";
		String line = "";
		try {
			reader = new BufferedReader(new FileReader (jsonFile));
			line = reader.readLine();
			while (line !=null){
				output+=line;
				line = reader.readLine();	
			}
			reader.close();
		} catch (FileNotFoundException e) {
			JistLogger.logError(JistLogger.SEVERE, "JSONValidate: File "+jsonFile.getName()+"not found.");
			e.printStackTrace();
		} catch (IOException e) {
			JistLogger.logError(JistLogger.SEVERE, "JSONValidate: IOException caught parsing "+jsonFile.getName());
			e.printStackTrace();
		}
		JSONObject myobj=null;
		try {
			myobj = new JSONObject(output);
		} catch (JSONException e) {
			JistLogger.logError(JistLogger.SEVERE, "ERROR: Could not read json file to JSONObject");
			e.printStackTrace();
		}
		this.jsonObj=myobj;
	}
	
	
	/**
	 * Return a string prefix of spaces
	 * @param n - the  number of spaces desired
	 * @return - String of spaces of (n) length
	 */
	public String getSpace(int n){
		StringBuffer outputBuffer = new StringBuffer(n);
		for (int i = 0; i < n; i++){
			   outputBuffer.append(" ");
			}
		return outputBuffer.toString();
	}
	
	
	/**
	 * Building the param volumes are a bit more complex. This handles the building of an input
	 * @param i - the index in the input json array
	 * @return - array list of strings for the module
	 * @throws JSONException
	 */
	private ArrayList<String>  buildParamVolume(int i,String type,boolean flag) throws JSONException{
		JSONObject obj = inputs.getJSONObject(i);
		ImageDataReaderWriter idrw = new ImageDataReaderWriter();
        Vector<String> supportedFileExtensions = idrw.getInstance().getExtensionFilter().getExtensions();
        
		ArrayList<String> theParamVolume = new ArrayList<String>();
		theParamVolume.add(getSpace(4)+"<edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume>"+"\n");
		theParamVolume.add(getSpace(6)+"<rows>-1</rows>"+"\n");
		theParamVolume.add(getSpace(6)+"<cols>-1</cols>"+"\n");
		theParamVolume.add(getSpace(6)+"<slices>-1</slices>"+"\n");
		theParamVolume.add(getSpace(6)+"<components>1</components>"+"\n");
		theParamVolume.add(getSpace(6)+"<imageIntent>0</imageIntent>"+"\n");
		theParamVolume.add(getSpace(6)+"<readerWriter class=\"edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter\">"+"\n");
		theParamVolume.add(getSpace(8)+"<extensionFilter>"+"\n");
		theParamVolume.add(getSpace(10)+"<exts>"+"\n");
		for (String tempType: supportedFileExtensions){
			theParamVolume.add(getSpace(12)+"<string>"+tempType+"</string>"+"\n");
		}
		theParamVolume.add(getSpace(10)+"</exts>"+"\n");
		theParamVolume.add(getSpace(10)+"<preferredExtension>24</preferredExtension>"+"\n");
		theParamVolume.add(getSpace(8)+"</extensionFilter>"+"\n");
		
		theParamVolume.add(getSpace(8)+"<compressionOptions>"+"\n");
		theParamVolume.add(getSpace(10)+"<string>none</string>"+"\n");
		theParamVolume.add(getSpace(10)+"<string>gzip</string>"+"\n");
		theParamVolume.add(getSpace(10)+"<string>bzip2</string>"+"\n");
		theParamVolume.add(getSpace(8)+"</compressionOptions>"+"\n");
		theParamVolume.add(getSpace(8)+"<prefCompression>gzip</prefCompression>"+"\n");
		theParamVolume.add(getSpace(6)+"</readerWriter>"+"\n");
		
		theParamVolume.add(getSpace(6)+"<extensionFilter reference=\"../readerWriter/extensionFilter\"/>"+"\n");
		if (!flag){
			theParamVolume.add(getSpace(6)+"<dialogType>FILE</dialogType>"+"\n");
		}else{
			theParamVolume.add(getSpace(6)+"<dialogType reference=\"../../edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume/dialogType\"/>\n");
		}
		String tempName = (String) obj.get("name");
		theParamVolume.add(getSpace(6)+"<name>"+tempName+"</name>"+"\n");
		theParamVolume.add(getSpace(6)+"<hidden>false</hidden>"+"\n");
		theParamVolume.add(getSpace(6)+"<owner class=\"edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm\" reference=\"../../..\"/>");
		if (type.equals("in")){
			theParamVolume.add(getSpace(6)+"<incomingConnectors/>"+"\n");
		}else if (type.equals("out")){
			theParamVolume.add(getSpace(6)+"<outgoingConnectors/>"+"\n");
		}
		String tempReq = (String) obj.get("required");
		theParamVolume.add(getSpace(6)+"<mandatory>"+tempReq+"</mandatory>"+"\n");
		theParamVolume.add(getSpace(4)+"</edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume>"+"\n");
		return theParamVolume;
		
	}
	
	
	/**
	 * Test the status of the command
	 * @param cmd - string for the init test
	 */
	public void pluginInitTest(String cmd){
		Process p;
		int exitStatus =0;
	
		try {
			p = Runtime.getRuntime().exec(cmd);
			p.waitFor();
			exitStatus = p.exitValue();
			if (exitStatus==0){
				this.runStatus = true;
				JistLogger.logOutput(JistLogger.FINE, "Plugin Passed. Can run");
			}else{
				JistLogger.logOutput(JistLogger.FINE, "Plugin Failed. Can NOT run");
			}
		} catch (IOException e) {
			JistLogger.logError(JistLogger.SEVERE, "Caught IOException trying to run pluginInitTest. Fatal. Can not continue");
			e.printStackTrace();
		} catch (InterruptedException e) {
			JistLogger.logError(JistLogger.SEVERE, "Caught InterruptedException trying to run pluginInitTest. Fatal. Can not continue");
			e.printStackTrace();
		}
		
	}
}
			

	
