package edu.jhu.ece.iacl.jist.pipeline.parser;


import java.awt.Color;
import java.io.File;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.factory.ParamFactory;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

/**
 * This is a simple plugin that is used just to show that a plugin can not run. The color will show up gray in the tree.
 * @author damons
 *
 */

public class JistJSONFailedPlugin extends ProcessingAlgorithm  {
	
    ParamFile externalOut;
    ParamFile externalErr;
    File pipeFile;
	public JistJSONFailedPlugin(){};
	public JistJSONFailedPlugin(PipeAlgorithm pipe) {
		init(pipe);
	}

	/**
	 * Initialize parameters and algorithm.
	 * 
	 * @param pipeFile the pipe file
	 */
	public void init(File pipeFile) {
		this.pipeFile = pipeFile;
		this.inputParams = (ParamCollection) ParamFactory.fromXML(pipeFile);
		System.out.println(pipeFile.getAbsolutePath());
		this.outputParams.setName(inputParams.getName());
		this.outputParams.setLabel(inputParams.getLabel());
	}


	/**
	 * Initialize parameters and algorithm.
	 * 
	 * @param pipe the pipe
	 */
	public void init(PipeAlgorithm pipe) {
		this.inputParams = pipe.getInputParams();

		this.outputParams.setName(inputParams.getName());
		this.outputParams.setLabel(inputParams.getLabel());
	}


	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "\nAlgorithm Version: " + revnum + "\n";




	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("Base");
		inputParams.setLabel("JIST External Failed Script Adapter");
		//inputParams.setName("ExtScript_Adapter");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.nitrc.org/projects/jist/");
		info.setDescription(shortDescription);
		info.add(new AlgorithmAuthor("Stephen Damon", "", ""));
		info.setVersion(revnum);
		info.setEditable(false);
		this.setPreferredColor(Color.GRAY);
		info.setStatus(DevelopmentStatus.ALPHA);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
	}

	@Override
	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {	
		JistLogger.logOutput(JistLogger.SEVERE, "FATAL: External module can not run. Please make sure your path is set up properly");
		JistLogger.logError(JistLogger.SEVERE, "FATAL: External module can not run. Please make sure your path is set up properly");
	}
	


}
