package edu.jhu.ece.iacl.jist.pipeline.parser;


import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import edu.jhu.ece.iacl.jist.io.MipavController;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.InvalidJistMergeException;
import edu.jhu.ece.iacl.jist.pipeline.MipavViewUserInterface;
import edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.factory.ParamFactory;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamHeader;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInformation;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamNumberCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamPerformance;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.plugins.AbstractProcessingAlgorithmInterface;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import gov.nih.mipav.view.Preferences;
import gov.nih.mipav.view.dialogs.ActionDiscovery;


public class JistJSONPlugin extends ProcessingAlgorithm  {

    ParamFile externalOut;
    ParamFile externalErr;
    File pipeFile;
	public JistJSONPlugin(){};
	public JistJSONPlugin(PipeAlgorithm pipe) {
		System.out.println("INIT");
		init(pipe);
	}

	/**
	 * Initialize parameters and algorithm.
	 * 
	 * @param pipeFile the pipe file
	 */
	public void init(File pipeFile) {
		this.pipeFile = pipeFile;
		this.inputParams = (ParamCollection) ParamFactory.fromXML(pipeFile);
		System.out.println(pipeFile.getAbsolutePath());
		this.outputParams.setName(inputParams.getName());
		this.outputParams.setLabel(inputParams.getLabel());
	}


	/**
	 * Initialize parameters and algorithm.
	 * 
	 * @param pipe the pipe
	 */
	public void init(PipeAlgorithm pipe) {
		this.inputParams = pipe.getInputParams();

		this.outputParams.setName(inputParams.getName());
		this.outputParams.setLabel(inputParams.getLabel());
	}


	private static final String cvsversion = "$Revision: 1.6 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "\nAlgorithm Version: " + revnum + "\n";




	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("Base");
		inputParams.setLabel("JIST External Script Adapter");
		//inputParams.setName("ExtScript_Adapter");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.nitrc.org/projects/jist/");
		info.setDescription(shortDescription);
		info.add(new AlgorithmAuthor("Stephen Damon", "", ""));
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.ALPHA);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		
	}

	@Override
	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {	
		File extJistLib = new File(Preferences.getProperty("JIST_External_Library_Directory"));
		
		
		//First, get the plugin so we can init the outputs and inputs. 
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder;
		String moduleName = null;
		try {
			builder = factory.newDocumentBuilder();
			Document doc = builder.parse(pipeFile);
			XPath xPath =  XPathFactory.newInstance().newXPath();
			XPathExpression expr = xPath.compile("/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection/children/edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInformation/info/name");
			Object result = expr.evaluate(doc,XPathConstants.STRING);
			moduleName = result.toString();
		} catch (ParserConfigurationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (XPathExpressionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		File expectedModule = new File(extJistLib.getAbsolutePath(),moduleName);
		if (expectedModule.exists()){
			JistLogger.logOutput(JistLogger.FINE, "Plugin Found");
		}else{
			JistLogger.logOutput(JistLogger.FINE, String.format("Expecting plugin: %s",expectedModule.getAbsolutePath().toString()));
			JistLogger.logError(JistLogger.SEVERE, "COULD NOT FIND PLUGIN. Please check that your .json file is in your external directory");
		}
		
		
//		p.readFileToJSONObject(jsonFile);
//		p.initInputs();
//		p.initOutputs();
//		p.initProgramInfo();
		
		String out="";
		try {
			out = buildString(inputParams,expectedModule);
		} catch (FileNotFoundException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (JSONException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		JistLogger.logOutput(JistLogger.INFO,"String as built: "+out);
		
		Process p;
		int exitStatus =0;
		try {
			p = Runtime.getRuntime().exec(out);
			p.waitFor();
			File thisOut = new File(this.getOutputDirectory()+File.separator+"externalCommand.out");
			File thisErr = new File(this.getOutputDirectory()+File.separator+"externalCommand.err");
			BufferedWriter writerOut = new BufferedWriter(new FileWriter(thisOut));
			BufferedReader readerOut = new BufferedReader(
		               new InputStreamReader(p.getInputStream()) );
			BufferedWriter writerErr = new BufferedWriter(new FileWriter(thisOut));
			BufferedReader readerErr = new BufferedReader(
		               new InputStreamReader(p.getErrorStream()));
			String lineIn = "";
			String lineErr = "";
		       while ((lineIn = readerOut.readLine()) != null) {
		    	   writerOut.write(lineIn+"\n");
		         JistLogger.logOutput(JistLogger.SEVERE, lineIn);
		       }
		       while ((lineErr = readerErr.readLine()) != null) {
		    	   writerErr.write(lineErr+"\n");
		         JistLogger.logOutput(JistLogger.SEVERE, lineIn);
		       }
		       writerOut.close();
		       writerErr.close();
			exitStatus = p.exitValue();
			if (exitStatus!=0){
				throw new RuntimeException(this.getAlgorithmName()+" Failed with exit status "+String.valueOf(exitStatus));
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		

		
		JSONPluginParser parser=null;
		try {
			parser = new JSONPluginParser(expectedModule);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (JSONException e) {
			e.printStackTrace();
		}
		JSONArray outputs = parser.outputs;
		for (int i=0; i<outputs.length();i++){
			JSONObject tempObject = null;
			try {
				tempObject = (JSONObject) outputs.get(i);
			} catch (JSONException e) {
				e.printStackTrace();
			}
			try {
				if (tempObject.get("type").toString().equals("ParamFile")){
					ParamFile OUTPUT = new ParamFile(tempObject.get("name").toString());
					System.out.println(outputParams.toString());
					if (!tempObject.get("output").toString().equals("")){
						if (tempObject.get("output").toString().contains(File.separator)){
							OUTPUT.setValue(tempObject.get("output").toString());
						}else{
							OUTPUT.setValue(this.getOutputDirectory()+tempObject.get("output").toString());
						}
					}
				}else if (tempObject.get("type").toString().equals("ParamVolume")){
					ParamVolume OUTPUT = new ParamVolume(tempObject.get("name").toString());
					System.out.println(outputParams.toString());
					if (!tempObject.get("output").toString().equals("")){
						if (tempObject.get("output").toString().contains(File.separator)){
							OUTPUT.setValue(tempObject.get("output").toString());
						}else{
							OUTPUT.setValue(this.getOutputDirectory()+tempObject.get("output").toString());
						}
					}
				}
			} catch (JSONException e) {
				e.printStackTrace();
			}
		}
	}
	
	protected String buildString(ParamCollection iParams, File module) throws FileNotFoundException, JSONException{
		String out="";
		Vector<ParamModel> model = iParams.getAllDescendants();
		String delimiter = inputParams.getAllDescendants().get(2).getValue().toString();
		JSONPluginParser parser = new JSONPluginParser(module);
		JSONArray inputs = parser.inputs;
		for (int i=1;i<inputs.length();i++){
			JSONObject object = (JSONObject) inputs.get(i);
			String arg = object.get("arg").toString();
			if (!(inputParams.getAllDescendants().get(i+2).getValue() == null)){ 
				String paramValue = inputParams.getAllDescendants().get(i+2).getValue().toString();	
				out+=String.format("%s%s%s%s",delimiter,arg,delimiter,paramValue);
			}
			
						
//				
//			}
		}
		
		return out;
	}


}
