package edu.jhu.ece.iacl.jist.pipeline.parser;


import java.awt.Dimension;
import java.io.File;
import java.util.Date;

import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.MipavController;
import edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.graph.PipeModuleCell;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.plugins.MedicAlgorithmGeneralScriptAdapter;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class ShellScriptXmlParser implements ScriptParser {
	private FileExtensionFilter filt = new FileExtensionFilter(new String[] { "ExtModuleXML" });

	public PipeAlgorithm openPipeAlgorithm() {
		JFileChooser loadDialog = new JFileChooser("Open extModuleXML File");
		loadDialog.setCurrentDirectory(MipavController.getDefaultWorkingDirectory());
		loadDialog.setDialogType(JFileChooser.OPEN_DIALOG);
		loadDialog.setFileFilter(filt);
		loadDialog.setFileSelectionMode(JFileChooser.FILES_ONLY);
		int returnVal = loadDialog.showOpenDialog(null);
		JistLogger.logOutput(JistLogger.INFO, "load return val: " + returnVal);
		JistLogger.logOutput(JistLogger.INFO, "approve op: " + JFileChooser.APPROVE_OPTION);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			JistLogger.logOutput(JistLogger.INFO, "File ext ok!");
			return parsePipeAlgorithm(loadDialog.getSelectedFile());
		} else {
			JistLogger.logError(JistLogger.SEVERE, "FILE EXT FAILURE!");
			return null;
		}
	}

	public PipeAlgorithm parsePipeAlgorithm(File f) {
		if (!filt.accept(f)) {
			return null;
		}

		Date date = new Date(f.lastModified());
		MedicAlgorithmGeneralScriptAdapter scriptAdapter = extModuleXMLParser(f, date);
		if(scriptAdapter == null)
			return null;
		PipeAlgorithm algo = new PipeAlgorithm();
		algo.setAlgorithm(scriptAdapter);
		Dimension d = PipeModuleCell.getPreferredSize(scriptAdapter.getInput(), scriptAdapter.getOutput());
		return algo;
	}
	
	public FileExtensionFilter getFileExtensionFilter(){
		return filt;
	}

	//Builds Module from extModule
	public static MedicAlgorithmGeneralScriptAdapter extModuleXMLParser(File extModuleXml, Date date) {
		try{
			//Read XML and Parse into tree
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(extModuleXml);
			doc.getDocumentElement().normalize();

			//Find Module Name, and Associated Script File
			String moduleName = doc.getElementsByTagName("ModuleName").item(0).getChildNodes().item(0).getNodeValue();
			String scriptLoc = doc.getElementsByTagName("ModuleScriptFile").item(0).getChildNodes().item(0).getNodeValue();
			File scriptFile = new File(scriptLoc);
			
			//Set module name and type
			MedicAlgorithmGeneralScriptAdapter extModule = new MedicAlgorithmGeneralScriptAdapter();
			ParamCollection inputParams  = extModule.getInput();
			ParamCollection outputParams = extModule.getOutput();
			
			//Add and Set XML, Script File and  Preferred Image Type
			extModule.setExtModuleXML(extModuleXml);
			extModule.setExtModuleScript(scriptFile);
			
			if(doc.getElementsByTagName("ConvertInputImgsToType").getLength()>0){//
				String prefImageType = doc.getElementsByTagName("ConvertInputImgsToType").item(0).getChildNodes().item(0).getNodeValue();
				extModule.setInputPrefImageType(prefImageType);
			}else{
				extModule.setInputPrefImageType("nii");
			}
			
			
			//Set Algorithm Info
			inputParams.setLabel(moduleName);
			inputParams.setName(moduleName);
			outputParams.setLabel(moduleName);
			outputParams.setName(moduleName);
			extModule.getAlgorithmInformation().init(extModule);
			extModule.getAlgorithmInformation().setCreationDate(date);

			//Begin finding Parameters
			Node inParamNode = doc.getElementsByTagName("InputParams").item(0);
			Node outParamNode = doc.getElementsByTagName("OutputParams").item(0);

			//add input/outs from XML
			addParamsToCollection(inParamNode, inputParams);
			addParamsToCollection(outParamNode, outputParams);

			// Move the execution time parameter to end of parameters
			//ParamModel execParam = outputParams.getValue(1);
			//outputParams.remove(execParam);
			//outputParams.add(execParam);

			return extModule;
		}catch(Exception e){
			e.printStackTrace();
			System.err.println( extModuleXml + ":" + e.getMessage());
			return null;
		}
	}

	//Types Param
	public enum ParamTypes {
		BOOLEAN,
		DOUBLE,
		FILE,
		FILECOLLECTION,
		INTEGER,
		OPTION,
		VOLUME,
		VOLUMECOLLECTION,
		SURFACE,
		STRING;
	}

	public static void addParamsToCollection(Node paramsNode, ParamCollection paramCollection){

		if(paramsNode.getNodeType() != Node.ELEMENT_NODE) return;

		Element inParamElement = (Element) paramsNode;
		NodeList inParamNList = inParamElement.getElementsByTagName("Param");

		for (int i = 0; i < inParamNList.getLength(); i++){
			Node nNode = inParamNList.item(i);

			if(nNode.getNodeType() == Node.ELEMENT_NODE){

				Element paramElement = (Element) nNode;

				String paramNameVal = paramElement.getElementsByTagName("ParamName").item(0).getChildNodes().item(0).getNodeValue();
				String paramTypeVal = paramElement.getElementsByTagName("ParamType").item(0).getChildNodes().item(0).getNodeValue();
				
				NodeList inputDefaultNodeList = paramElement.getElementsByTagName("InputDefault");
				String inputDefaultVal;
				if(inputDefaultNodeList.getLength() > 0)
					inputDefaultVal = inputDefaultNodeList.item(0).getChildNodes().item(0).getNodeValue();
				else
					inputDefaultVal = null;
				
				NodeList mandatoryNodeList = paramElement.getElementsByTagName("Mandatory");
				String mandatoryParam;
				if (mandatoryNodeList.getLength()>0)
					mandatoryParam = mandatoryNodeList.item(0).getChildNodes().item(0).getNodeValue();
				else
					mandatoryParam = "true";
				
				//System.out.format("Name" + paramNameVal + "\n");
				//System.out.format("Type" + paramTypeVal + "\n");

				ParamTypes paramTypesEnumVal = ParamTypes.valueOf(paramTypeVal);
				switch(paramTypesEnumVal){

				case VOLUME:
					paramCollection.add(new ParamVolume(paramNameVal,null,-1,-1,-1,-1));
					paramCollection.getFirstChildByName(paramNameVal).setMandatory(Boolean.valueOf(mandatoryParam));
					break;
				
				case SURFACE:
					paramCollection.add(new ParamSurface(paramNameVal));
					paramCollection.getFirstChildByName(paramNameVal).setMandatory(Boolean.valueOf(mandatoryParam));
					break;
					
				case BOOLEAN:
					boolean defaultBool = Boolean.valueOf(inputDefaultVal);
					paramCollection.add(new ParamBoolean(paramNameVal,defaultBool));
					break;
					
				case VOLUMECOLLECTION:
					paramCollection.add(new ParamVolumeCollection(paramNameVal,null,-1,-1,-1,-1));
					paramCollection.getFirstChildByName(paramNameVal).setMandatory(Boolean.valueOf(mandatoryParam));
					break;

				case INTEGER:
					int defaultInt;
					if(inputDefaultVal == null)
						defaultInt = 0;
					else
						defaultInt = Integer.valueOf(inputDefaultVal);
					
					paramCollection.add(new ParamInteger(paramNameVal,defaultInt));
					break;

				case DOUBLE:
					System.out.format("Default " + Double.valueOf(inputDefaultVal) + "\n");
					double defaultD;
					if(inputDefaultVal == null)
						defaultD = 0d;
					else
						defaultD = Double.valueOf(inputDefaultVal);
					paramCollection.add(new ParamDouble(paramNameVal,defaultD));
					break;
					
				case OPTION:
					
					NodeList oplist = paramElement.getElementsByTagName("Option");
					String[] optionList = new String[oplist.getLength()];
					for(int n=0; n<oplist.getLength(); n++){
						optionList[n]=oplist.item(n).getChildNodes().item(0).getNodeValue();
					}
					ParamOption options = new ParamOption(paramNameVal, optionList);
					if(inputDefaultVal == null)
						options.setValue(0);
					else
						options.setValue(inputDefaultVal);
					paramCollection.add(options);
					break;
					
				case FILE:
					paramCollection.add(new ParamFile(paramNameVal));
					paramCollection.getFirstChildByName(paramNameVal).setMandatory(Boolean.valueOf(mandatoryParam));
					break;
					
				case FILECOLLECTION:
					paramCollection.add(new ParamFileCollection(paramNameVal));
					paramCollection.getFirstChildByName(paramNameVal).setMandatory(Boolean.valueOf(mandatoryParam));
					break;
					
				case STRING:
					String defaultString;
					if(inputDefaultVal == null)
						defaultString="";
					else
						defaultString=inputDefaultVal;
					paramCollection.add(new ParamString(paramNameVal,defaultString));
					break;

				default:
					System.out.format("Param Type Unrecognized");
					break;

				}

				//paramNameVal = paramElement.getElementsByTagName("ParamScriptTag").item(0).getChildNodes().item(0);
				//System.out.format("Tag" + paramNameVal.getNodeValue());

			}

		}

	}

}
