package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamNumberCollection;

public class PipeDoubleCollectionExternalSource extends PipeExternalSource{
	
	public PipeDoubleCollectionExternalSource(){
		super();
	}
	
	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		defaultValueParam = (ParamNumberCollection) inputParams.getFirstChildByName("Default");
		valParam =(ParamNumberCollection) outputParams.getFirstChildByName("Float Collection");
	}
	
	public ParamCollection createInputParams() {
		ParamCollection group = new ParamCollection();
		group.add(defaultValueParam = new ParamNumberCollection("Default"));
		group.setLabel("External Float Collection");
		group.setName("extfloats");
		group.setCategory("Externalize.Number.Float");
		return group;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.pipeline.PipeSource#createOutputParams()
	 */
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("Float Collection");
		group.add(valParam = new ParamNumberCollection("Float Collection"));
		return group;
	}
}
