package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;

public class PipeFileExternalSource extends PipeExternalSource{
	public PipeFileExternalSource(){
		super();
	}
	
	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		defaultValueParam = (ParamFile) inputParams.getFirstChildByName("Default File");
		valParam =(ParamFile) outputParams.getFirstChildByName("File");
	}
	
	public ParamCollection createInputParams() {
		ParamCollection group = new ParamCollection();
		group.add(defaultValueParam = new ParamFile("Default File",new FileExtensionFilter(new String[]{})));
		group.setLabel("External File");
		group.setName("extfile");
		group.setCategory("Externalize.File");
		return group;
	}
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("File");
		group.add(valParam = new ParamFile("File",new FileExtensionFilter(new String[]{})));
		return group;
	}
}
