package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamNumberCollection;

public class PipeIntegerCollectionExternalSource extends PipeExternalSource{
	public PipeIntegerCollectionExternalSource(){
		super();
	}

	
	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		defaultValueParam = (ParamNumberCollection) inputParams.getFirstChildByName("Default");
		valParam =(ParamNumberCollection) outputParams.getFirstChildByName("Integer Collection");
	}
	
	public ParamCollection createInputParams() {
		ParamCollection group = new ParamCollection();
		group.add(defaultValueParam = new ParamNumberCollection("Default"));
		group.setLabel("External Integer Collection");
		group.setName("extints");
		group.setCategory("Externalize.Number.Integer");
		return group;
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.jist.pipeline.PipeSource#createOutputParams()
	 */
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("Integer Collection");
		group.add(valParam = new ParamNumberCollection("Integer Collection"));
		return group;
	}
}
