package edu.jhu.ece.iacl.jist.pipeline.src;

import java.io.File;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.io.ArrayObjectTxtReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.PipeSource;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public abstract class PipeSourceCollectionSet extends PipeSource {

	/** The volume collection param. */
	protected ParamFileCollection outCollectionParam;
	
	/** the Text File Based Parameters **/
	protected ParamFile txtFileParam;
	protected ParamInteger startEntry;
	protected ParamInteger endEntry;
	
	/** The off. */
	transient protected Object[][] data;
	transient protected int index;
	transient int st, end;

	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		txtFileParam = (ParamFile) inputParams.getFirstChildByName("List File");
		startEntry = (ParamInteger) inputParams.getFirstChildByName("Start Entry");
		endEntry = (ParamInteger) inputParams.getFirstChildByName("End Entry");
	}
	
	/**
	 * Create input parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createInputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("Volume Collection Set");
		group.setName("Volume_Collection_Set");
		group.setCategory("Volume Collection");
		
		// set the text file options
		group.add(txtFileParam = new ParamFile("List File"));
		txtFileParam.setExtensionFilter(ArrayObjectTxtReaderWriter.getInstance().getExtensionFilter());
		group.add(startEntry = new ParamInteger("Start Entry", 0, 100000, 0));
		group.add(endEntry = new ParamInteger("End Entry", -1, 100000, -1));
		
		return group;
	}
	
	public abstract ParamCollection createOutputParams();

	@Override
	public ParamFileCollection getOutputParam() {
		return outCollectionParam;
	}
	
	/**
	 * Iterate.
	 * 
	 * @return true, if iterate
	 */
	public boolean iterate() {
		if (hasNext()) {
			if (!super.iterate()) {
				if (index < data.length) {
					getOutputParam().setValue(getValue(index++));
					push();
				} else {
					reset();
					isReset = true;
					return false;
				}
			}
			return true;
		} else {
			reset();
			isReset = true;
			return false;
		}
	}
	
	/**
	 * Reset iterator.
	 */
	public void reset() {
		super.reset();
		data = ArrayObjectTxtReaderWriter.getInstance().read(txtFileParam.getValue());
		if(data == null) {
			JistLogger.logError(JistLogger.INFO, "Cannot Read: "+ txtFileParam.getValue());
			data = new Object[0][0];
		} 
		index = 0;
		st = startEntry.getInt();
		end = endEntry.getInt();
		index = st;
		if (((end == -1) || (index < end)) && (index < data.length)) {
			getOutputParam().setValue(getValue(index++));
		} else {
			index++;
		}
		push();
	}
	
	/**
	 * Returns true if iterator has more values.
	 * 
	 * @return true, if checks for next
	 */
	public boolean hasNext() {
		return (super.hasNext() || (((end == -1) || (index < end)) && (index < data.length)));
	}
	
	protected ArrayList<File> getValue(int i) {
		ArrayList<File> vollist = new ArrayList<File>();
		for(int j=0; j<data[i].length; j++){
			vollist.add(new File(data[i][j].toString().trim()));
		}
		return vollist;
	}

	@SuppressWarnings("unchecked")
	protected void setValue(Object obj) {
		outCollectionParam.setValue((ArrayList<File>)obj);
	}

}
