package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;

public class PipeSourceCollectionSetFile extends PipeSourceCollectionSet {

	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		outCollectionParam = (ParamFileCollection)outputParams.getFirstChildByName("File Collection");
		getParentPort().setParameter(outCollectionParam);
	}
	
	/**
	 * Default constructor.
	 */
	public PipeSourceCollectionSetFile() { 
		super();
		getParentPort().setParameter(outCollectionParam);
	}
	
	/**
	 * Create input parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createInputParams() {
		ParamCollection group = super.createInputParams();
		group.setLabel("File Collection Set");
		group.setName("File_Collection_Set");
		group.setCategory("File");
		return group;
	}
	
	@Override
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("File Collection List");
		group.add(outCollectionParam = new ParamFileCollection("File Collection"));
		return group;
	}
}
