package edu.jhu.ece.iacl.jist.pipeline.src;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;

public class PipeSourceCollectionSetVolume extends PipeSourceCollectionSet {

	public void xmlDecodeModule(Document document, Element el) {
		super.xmlDecodeModule(document, el);
		outCollectionParam = (ParamVolumeCollection)outputParams.getFirstChildByName("Volume Collection");
		getParentPort().setParameter(outCollectionParam);
	}
	
	/**
	 * Default constructor.
	 */
	public PipeSourceCollectionSetVolume() { 
		super();
		getParentPort().setParameter(outCollectionParam);
	}
	
	/**
	 * Create input parameters.
	 * 
	 * @return the param collection
	 */
	public ParamCollection createInputParams() {
		ParamCollection group = super.createInputParams();
		group.setLabel("Volume Collection Set");
		group.setName("Volume_Collection_Set");
		group.setCategory("Volume");
		return group;
	}
	
	@Override
	public ParamCollection createOutputParams() {
		ParamCollection group = new ParamCollection();
		group.setLabel("Volume Collection List");
		group.add(outCollectionParam = new ParamVolumeCollection("Volume Collection"));
		return group;
	}
}