/**
 * Java Image Science Toolkit (JIST)
 *
 * Image Analysis and Communications Laboratory &
 * Laboratory for Medical Image Computing &
 * The Johns Hopkins University
 * 
 * http://www.nitrc.org/projects/jist/
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 */
package edu.jhu.ece.iacl.jist.pipeline.view.output;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;

import edu.jhu.ece.iacl.jist.io.FileReaderWriter;
import edu.jhu.ece.iacl.jist.io.MipavController;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;

/**
 * Output view for a volume parameter.
 * 
 * @author Blake Lucas <br> Muqun Li(muqun.li@vanderbilt.edu)
 */
public class ParamVolumeOutputView extends ParamOutputView implements ActionListener {
	// view button
	/** The button. */
	protected JButton button;

	/**
	 * Default constructor.
	 * 
	 * @param param
	 *            volume parameter
	 */
	public ParamVolumeOutputView(ParamVolume param) {
		super(param);
		button = new JButton("Open Volume");
		button.addActionListener(this);
		add(button, BorderLayout.SOUTH);

		this.update();
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent event) {
		
		// TODO Auto-generated method stub
		if (event.getSource().equals(button)) {
			if (getParameter().getValue() != null && getParameter().getValue().exists()) {
				// make sure the main mipav is visible (mainly for developers)
				MipavController.getUI().getMainFrame().setVisible(true);
				MipavController.getUI().setAppFrameVisible(true);
				
				// open the image
				MipavController.getUI().openImageFrame(getParameter().getURI().getPath());
				
				// make sure it is visible
				if (!MipavController.getUI().getActiveImageFrame().getFrame().isVisible())
					MipavController.getUI().getActiveImageFrame().getFrame().setVisible(true);
			}
		}
	}

	/**
	 * Get volume parameter.
	 * 
	 * @return volume parameter
	 */
	public ParamVolume getParameter() {
		return (ParamVolume) param;
	}

	/**
	 * Update view from parameter.
	 */
	public void update() {
		File f = getParameter().getValue();
		if (f == null) {
			if (getParameter().getValue() != null && getParameter().getValue().exists()) {
				field.setText(getParameter().getValue().getName());
			} else {
				field.setText("null");
				button.setEnabled(false);
			}
		} else {
			field.setText(FileReaderWriter.getFileName(f));
		}
	}
}
