package edu.jhu.ece.iacl.jist.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.InvalidJistMergeException;
import edu.jhu.ece.iacl.jist.pipeline.PipeAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.factory.ParamFactory;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.pipeline.parser.ShellScriptXmlParser;
import edu.jhu.ece.iacl.jist.pipeline.parser.ShellScriptXmlParser.ParamTypes;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class MedicAlgorithmGeneralScriptAdapter extends ProcessingAlgorithm implements AbstractProcessingAlgorithmInterface{

	public static final String ANYTYPE = "ANYTYPE"; 
	public static final String ExtModXmlParamName 		= "ExtModule XML File";
	public static final String ExtModScriptParamName 	= "ExtModule Script File";

	private static final String cvsversion = "$Revision: 1.9 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "\nAlgorithm Version: " + revnum + "\n";

	private File destdir;
	private List<File> cleanUpConvertedInputsList;//collection of input files converted (and need to be removed at end);
	private String convertedInputImgType;
	private ImageDataReaderWriter readerWriter = new ImageDataReaderWriter();
	private boolean doReWrite = true;

	//Parameters independent of external module
	private ParamFile inParamExtModuleXML, inParamExtModuleScript;
	private ParamOption inParamPrefImageTypeParam;
	/**
	 * Initialize parameters and algorithm.
	 * 
	 * @param pipeFile the pipe file
	 */
	public void init(File pipeFile) {
		//Load Input params from file
		this.inputParams = (ParamCollection) ParamFactory.fromXML(pipeFile);
		loadOutputParametersFromInputs();
	}
	
	public void setExtModuleXML(File extModXmlFile){
		inParamExtModuleXML = new ParamFile(ExtModXmlParamName);
		inParamExtModuleXML.setValue(extModXmlFile);
		inputParams.add(inParamExtModuleXML);
	}
	
	public void setExtModuleScript(File extModScriptFile){
		inParamExtModuleScript = new ParamFile(ExtModScriptParamName);
		inParamExtModuleScript.setValue(extModScriptFile);
		inputParams.add(inParamExtModuleScript);
	}
	
	public void setInputPrefImageType(String prefImgType){
		Vector<String> exts=readerWriter.getExtensionFilter().getExtensions();
		inParamPrefImageTypeParam=new ParamOption("Convert Input Images To Type",exts);
		
		// check that the type is valid
		if(exts.contains(prefImgType)){
			inParamPrefImageTypeParam.setValue(prefImgType);
		}else{
			JistLogger.logError(JistLogger.WARNING, "invalid type: default to nii");
			inParamPrefImageTypeParam.setValue("nii");
		}
		inputParams.add(inParamPrefImageTypeParam);
	}
	
	/**
	 * Initialize parameters and algorithm.
	 * 
	 * @param pipe the pipe
	 */
	public void init(PipeAlgorithm pipe) {
		this.inputParams = pipe.getInputParams();
		loadOutputParametersFromInputs();
	}
	
	public void loadOutputParametersFromInputs(){
		
		boolean XMLFound = false;
		boolean scriptFound = false;
		outputParams.setName(inputParams.getName());//set output param name from loaded input (this determines save location)
		//Look parameters independent of external module
		for(int i=0; i<inputParams.size(); i++){
			//if XML file, then parse so we can add in outputs params
			if(inputParams.getValue(i).getName().equals(ExtModXmlParamName)){
				try{
					DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
					DocumentBuilder db = dbf.newDocumentBuilder();
					inParamExtModuleXML = ((ParamFile)inputParams.getValue(i));
					//Once found, parse and add adding outputs params 
					Document doc= db.parse(inParamExtModuleXML.getValue());
					doc.getDocumentElement().normalize();
					Node outParamNode = doc.getElementsByTagName("OutputParams").item(0);
					ShellScriptXmlParser.addParamsToCollection(outParamNode, outputParams);
				} catch(Exception e) {
					JistLogger.logError(JistLogger.SEVERE, e.toString());
					e.printStackTrace();

				}
				XMLFound = true;
			}

			//find script File
			if(inputParams.getValue(i).getName().equals(ExtModScriptParamName)){
				inParamExtModuleScript = ((ParamFile)inputParams.getValue(i));
				scriptFound = true;
			}

			//find image type the extModule needs to work with
			if(inputParams.getValue(i).getName().equals("Convert Input Images To Type")){
				inParamPrefImageTypeParam = ((ParamOption)inputParams.getValue(i));
			}

		}
		if(!XMLFound){
			JistLogger.logError(JistLogger.SEVERE, "MISSING ExtModuleXML File!! Output Parameters are not correctly verified (will not link)!\n");
			JistLogger.logError(JistLogger.SEVERE, "MISSING ExtModuleXML File!! Output Parameters are not correctly verified (will not link)!\n");
			JistLogger.logError(JistLogger.SEVERE, "MISSING ExtModuleXML File!! Output Parameters are not correctly verified (will not link)!\n");
		}
		
		if(!scriptFound){
			JistLogger.logError(JistLogger.SEVERE, "MISSING Script File!!!\n");
			JistLogger.logError(JistLogger.SEVERE, "MISSING Script File!!!\n");
			JistLogger.logError(JistLogger.SEVERE, "MISSING Script File!!!\n");
		}
	}

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setPackage("Base");
		inputParams.setLabel("JIST External Script Adapter");
		//inputParams.setName("ExtScript_Adapter");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.nitrc.org/projects/jist/");
		info.setDescription(shortDescription);
		info.add(new AlgorithmAuthor("John Bogovic", "", ""));
		info.add(new AlgorithmAuthor("Min Chen", "", ""));
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.ALPHA);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
	}

	@Override
	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {
		
		try {
			//set where files will be written
			
			// only set a destdir here if it hasnt already been set
			if(destdir==null){
				destdir = new File(this.getOutputDirectory().getCanonicalFile()+File.separator+this.getAlgorithmName());
			}
			
			// create the directory if it doesn't exist
			if(!destdir.isDirectory()){
				(new File(destdir.getCanonicalPath())).mkdir();
			}

			// The following string is passed as command line argument, we add to this
			String shellArg=""; 

			//Parse XML File
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(inParamExtModuleXML.getValue());
			doc.getDocumentElement().normalize();
			//Set Pref Type
			convertedInputImgType = inParamPrefImageTypeParam.getValue();
			//This is our script command for calling the external module, set as start for command argument string
			shellArg = inParamExtModuleScript.getValue().getAbsolutePath();


			// Use XML to add string for input/output tags and arguments
			cleanUpConvertedInputsList = new ArrayList<File>();//collection of input files converted (and need to be removed at end)
			Node inParamNode = doc.getElementsByTagName("InputParams").item(0);
			Node outParamNode = doc.getElementsByTagName("OutputParams").item(0);
			NodeList inParamNList = null; 
			NodeList outParamNList = null;

			//make List
			// parse input params
			if(inParamNode.getNodeType() == Node.ELEMENT_NODE){
				Element inParamElement = (Element) inParamNode;
				inParamNList = inParamElement.getElementsByTagName("Param");
			}
		
			// parse output params
			if(outParamNode.getNodeType() == Node.ELEMENT_NODE){
				Element outParamElement = (Element) outParamNode;
				outParamNList = outParamElement.getElementsByTagName("Param");
			}


			//build command array, size = 1 + # of inputs + # of outputs
			String[] comArray = new String[1 + inParamNList.getLength() + outParamNList.getLength()];
			comArray[0] = shellArg; // first command is shell argument
			addParamsArgFromXML(inParamNList, comArray, 1, true);
			addParamsArgFromXML(outParamNList, comArray, inParamNList.getLength() + 1, false);

			JistLogger.logOutput(JistLogger.INFO, "Current Command:");
			for(int i=0; i<comArray.length; i++){
				JistLogger.logOutput(JistLogger.INFO, comArray[i]);
			}
			JistLogger.logOutput(JistLogger.INFO, "\n");
			
			// run the script
			Runtime rt = Runtime.getRuntime();
			Process pr = rt.exec(comArray);

			// collect the command line output
			BufferedReader inputOut = new BufferedReader(new InputStreamReader(pr.getInputStream()));
			BufferedReader inputError = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
			String lineOut=null;
			String lineError=null;
			while((lineOut=inputOut.readLine()) != null || (lineError=inputError.readLine()) != null) {
				JistLogger.logOutput(JistLogger.INFO, lineOut);
				System.err.println(lineError);
			}
			int exitVal = pr.waitFor();
			
			if(exitVal==0){
				JistLogger.logOutput(JistLogger.INFO, "Executed successfully");
			}else{
				JistLogger.logError(JistLogger.WARNING, "Executed with error(s)");
			}
			
		} catch(Exception e) {
			JistLogger.logError(JistLogger.WARNING, "Executed with error(s)");
			e.printStackTrace();
		}
		
		cleanUp();
		
	}
	
	public void setDestDir(File destdir){
		this.destdir=destdir;
	}
	
	public void setDoReWrite(boolean doReWrite){
		this.doReWrite=doReWrite;
	}

	private void cleanUp(){
		if(doReWrite){
			//Convert all output into the global preferred type and erase all older stuff
			for(int i=0; i<outputParams.size(); i++){
				if(outputParams.getValue(i) instanceof ParamVolume ){// if ParamVolume
					ParamVolume currentParamVolume = (ParamVolume)outputParams.getValue(i);
					File currentFile = currentParamVolume .getValue();
					ImageData currentVol = readerWriter.read(currentFile);//convert output into ImageData;
					JistLogger.logOutput(JistLogger.FINE, "Deleting: " + currentFile.getAbsolutePath() + "\n");
					ImageDataReaderWriter.deleteImageFile(currentFile);//delete the original file
					currentParamVolume.setValue(currentVol);//read file and write as image data
				}if(outputParams.getValue(i) instanceof ParamVolumeCollection ){
					ParamVolumeCollection paramVolCollection = (ParamVolumeCollection)outputParams.getValue(i);
					List<ImageData> convertedParamVolColection= new ArrayList<ImageData>(); 
					for(int j=0; j<paramVolCollection.size(); j++){
						File currentFile = paramVolCollection.getFileList().get(j);
						ImageData currentVol = readerWriter.read(currentFile);//convert output into ImageData;
						JistLogger.logOutput(JistLogger.FINE, "Deleting: " + currentFile.getAbsolutePath() + "\n");
						ImageDataReaderWriter.deleteImageFile(currentFile);//delete the original file
						convertedParamVolColection.add(currentVol);
					}
					paramVolCollection.setValue(convertedParamVolColection);
				}
			}
		}
		//removes all files created for extension compatibility
		for	(File currentFile : cleanUpConvertedInputsList)	{
			JistLogger.logOutput(JistLogger.FINE, "Deleting: " + currentFile.getAbsolutePath() + "\n");
			ImageDataReaderWriter.deleteImageFile(currentFile);
		}
	}

	private void addParamsArgFromXML(NodeList paramsNList,String[] argArray, int arrayOffset, boolean isInputParams){

		for (int i = 0; i < paramsNList.getLength(); i++){
			Node nNode = paramsNList.item(i);

			if(nNode.getNodeType() == Node.ELEMENT_NODE){

				Element paramElement = (Element) nNode;

				String paramNameVal = paramElement.getElementsByTagName("ParamName").item(0).getChildNodes().item(0).getNodeValue();
				String paramTypeVal = paramElement.getElementsByTagName("ParamType").item(0).getChildNodes().item(0).getNodeValue();
				ParamTypes paramType = ParamTypes.valueOf(paramTypeVal);
				
				String paramString="";
				if(isInputParams)//if is input
					paramString = findInputParamAndMakeString(paramNameVal, paramTypeVal);
				else{//else is output
					Node paramOutputFileNode = paramElement.getElementsByTagName("OutputFileName").item(0);
					if(paramOutputFileNode != null){
						//make Output File that external module will write to
						ArrayList<File> paramOutputFileList = new ArrayList<File>();
						NodeList outFileNodes = paramOutputFileNode.getChildNodes();
						for(int j=0; j<outFileNodes.getLength(); j++){
							
							File[] filecol = parseOutputName(outFileNodes.item(j).getNodeValue());
							
							// from argument to file collection
							for(int n=0; n<filecol.length; n++){
								
								File f = filecol[n];
								paramOutputFileList.add(filecol[n]);
								
								paramString += f.getPath();
								if(n<filecol.length-1){
									paramString+=",";
								}
								
							}
							
						}

						//Set the file as an output parameter
						setParamOutputFileName(paramNameVal, paramTypeVal, paramOutputFileList);

					}else
						JistLogger.logError(JistLogger.WARNING, "Missing file for parameter " + paramNameVal+  ". If the parameter is an output, add tag <OutputFileName> to XML\n");

				}

				argArray[arrayOffset+i]=paramString;

			}

		}

	}
	
	/**
	 * Parses the file name expression for the output parameter with the 'outputNameValue.' 
	 * 
	 * If the parameter given by paramname is a VOLUMECOLLECTION or FILECOLLECTION, then 
	 * the ith entry in the output file array will contain the ith volume or file.  
	 * 
	 * Typically, each element of the output file collection is associated with an element
	 * of an input file collection.  The number of output files in the collection depend
	 * on the number of files passed to the input parameter referenced in the expression. 
	 * 
	 * Example
	 * 	If "::Input Volumes::_def.img" is given as an input, this method will
	 * 		* Look for an input parameter with the name 'Input Volumes'
	 * 		* Create a list of all files passed to that input
	 * 		* For each file in the list, create an output file name according to the file name expression
	 * 			* e.g. if input files are {a.txt, b.txt}, the ouput files will be {a_def.img, b_def.img}
	 * 
	 * Otherwise, the file array will have only one element.
	 * 
	 * @param outputNameValue
	 * @return an array of files containing the output file(s)
	 */
	private File[] parseOutputName(String outputNameValue){

		Pattern p = Pattern.compile("::([^:]*)::");
		Matcher m = p.matcher(outputNameValue);
		String paramName = "";
		
		if(m.find()){
			paramName = m.group().replace(":","");
			JistLogger.logOutput(JistLogger.INFO, "paramName: " + paramName);

		}else{
			return new File[]{new File(outputNameValue)};
		}
		
		try{
			String[] paramFlist = paramFname(paramName);
			File[] out = new File[paramFlist.length];

			for(int i=0; i<paramFlist.length; i++){
				
				File f = new File(m.replaceAll(paramFlist[i]));
				
				// check that the extension is correct and change it if necessary				
//				String desiredExtString = "."+this.convertedInputImgType;
//				if(!f.getPath().endsWith(desiredExtString)){
//					String pathstr = f.getPath();
//					
//					f = new File(pathstr.substring(0,pathstr.lastIndexOf('.'))+desiredExtString);
//							
//				}
				
				out[i]=f;
			}

			return out;
			
		}catch(Exception e){
			e.printStackTrace();
			
			return new File[]{new File(outputNameValue)};
		}
	}

//	/**
//	 * For the ouput parameter with name 'outputNameValue' generates an output file name
//	 * based on the <OutputFileName> tag in the ExtModuleXML.
//	 * 
//	 * @param outputNameValue The name of the output parameter
//	 * @return
//	 */
//	private String parseOutputName(String outputNameValue){
//
//		StringBuffer strout = new StringBuffer();
//
//		Pattern p = Pattern.compile("::([^:]*)::");
//		Matcher m = p.matcher(outputNameValue);
//
//		while(m.find()){
//			
//			String[] paramFname = paramFname(m.group().replace(":",""));
//			
//			for(int k=0; k<paramFname.length; k++){
//				m.appendReplacement(strout, paramFname );
//			}
//			
//			
//		}
//		m.appendTail(strout);
//
//
//		return strout.toString();
//	}
//
	/**
	 * 
	 * Returns a string array containing the file name(s) 
	 * If the parameter given by paramname is a VOLUMECOLLECTION or FILECOLLECTION, then 
	 * the ith entry in the output string array will contain the ith volume or file.  
	 * Otherwise, the string array will have only one element.
	 * 
	 * @param paramname The name of the parameter
	 * @return
	 */
	private String[] paramFname(String paramname){
		
		for(int i=0; i<inputParams.size(); i++){
			if(inputParams.getValue(i).getName().equals(paramname)){
				if(inputParams.getValue(i) instanceof ParamFileCollection){
					
					ParamFileCollection thisparam = (ParamFileCollection)inputParams.getValue(i);
					String[] namestr = new String[thisparam.size()];
					
					for(int j=0; j<thisparam.size(); j++){
						String thisfname = thisparam.getValue(j).getName();
						String thisBase = thisfname.substring(0, thisfname.lastIndexOf('.'));
						
						namestr[j] = destdir.getAbsolutePath() + File.separator + 
									thisBase;
						
					}
					
					return namestr;
					
				}else{
					String pathstr =inputParams.getValue(i).getValue().toString();
					String namestr = destdir.getAbsolutePath() + File.separator + 
							pathstr.substring(pathstr.lastIndexOf(File.separator)+1,pathstr.lastIndexOf('.'));
					
					return new String[]{namestr};
				}
				
			}
		}
		return null;
	}
	
	private String findInputParamAndMakeString(String paramName, String paramType){

		String paramString="";
		for(int i=0; i<inputParams.size(); i++){
			if(inputParams.getValue(i).getName().equals(paramName)){

				ParamTypes paramTypesEnumVal = ParamTypes.valueOf(paramType);
				switch(paramTypesEnumVal){

				case BOOLEAN:
					paramString = ((ParamBoolean)inputParams.getValue(i)).getValue().toString();
					break;
				case DOUBLE:
					paramString = ((ParamDouble)inputParams.getValue(i)).getValue().toString();
					break;
				case FILECOLLECTION:
					ParamFileCollection filecol = ((ParamFileCollection)inputParams.getValue(i));
					paramString = "";
					for(int j=0; j<filecol.size(); j++){
						paramString += filecol.getValue(j).getAbsolutePath();
						if(j<filecol.size()-1){
							paramString +=",";
						}
					}
					break;
				case FILE:
					paramString = ((ParamFile)inputParams.getValue(i)).getValue().getAbsolutePath();
					break;
				case INTEGER:
					paramString = ((ParamInteger)inputParams.getValue(i)).getValue().toString();
					break;
				case OPTION:
					paramString = ((ParamOption)inputParams.getValue(i)).getValue().toString();
					break;
				case VOLUMECOLLECTION:
					ParamVolumeCollection inputVolCol = ((ParamVolumeCollection)inputParams.getValue(i));
					JistLogger.logOutput(JistLogger.FINE, inputVolCol+"");
					JistLogger.logOutput(JistLogger.FINE, inputVolCol.size()+"");
					for(int j=0; j<inputVolCol.size(); j++){
						JistLogger.logOutput(JistLogger.FINE, j+"");
						JistLogger.logOutput(JistLogger.FINE, inputVolCol.getValue(j)+"");
						JistLogger.logOutput(JistLogger.FINE, inputVolCol.getValue(j).getAbsolutePath());
						
						//if input extension doesn't match, then we have to convert
						if(convertedInputImgType!=null && !FilenameUtils.getExtension(inputVolCol.getValue(j).getAbsolutePath()).equals(convertedInputImgType)){
							String convertVolLoc = destdir.getAbsolutePath() + File.separator + inputVolCol.getParamVolume(j).getImageData().getName()+"_convertedInput."+convertedInputImgType;
							File convertedVol = new File(convertVolLoc);
							cleanUpConvertedInputsList.add(convertedVol);//added to clean up list
							readerWriter.write(inputVolCol.getParamVolume(j).getImageData(), convertedVol);
							paramString += convertedVol.getAbsolutePath();
						}else{
							paramString += ((ParamVolumeCollection)inputParams.getValue(i)).getValue(j).getAbsolutePath();
						}

						if(j<inputVolCol.size()-1){
							paramString +=",";
						}
					}
					break;
				case VOLUME:
					ParamVolume inputVol = ((ParamVolume)inputParams.getValue(i));
					//if input extension doesn't match, then we have to convert
					if(convertedInputImgType!=null && !FilenameUtils.getExtension(inputVol.getValue().getAbsolutePath()).equals(convertedInputImgType)){
						String convertVolLoc = destdir.getAbsolutePath() + File.separator + inputVol.getImageData().getName()+"_convertedInput."+convertedInputImgType;
						File convertedVol = new File(convertVolLoc);
						cleanUpConvertedInputsList.add(convertedVol);//add up to clean up list
						readerWriter.write(inputVol.getImageData(), convertedVol);
						paramString = convertedVol.getAbsolutePath();
					}else
						paramString = ((ParamVolume)inputParams.getValue(i)).getValue().getAbsolutePath();
					break;
				case SURFACE:
					paramString = ((ParamSurface)inputParams.getValue(i)).getValue().getAbsolutePath();
					break;
				case STRING:
					paramString = ((ParamString)inputParams.getValue(i)).getValue();
					break;
				default:
					JistLogger.logError(JistLogger.WARNING, "Param Type Unrecognized\n");
					break;
				}

			}
		}

		return paramString;
	}

	private void setParamOutputFileName(String paramName, String paramType, List<File> paramOutputFileList){
		for(int i=0; i<outputParams.size(); i++){
			if(outputParams.getValue(i).getName().equals(paramName)){
				ParamTypes paramTypesEnumVal = ParamTypes.valueOf(paramType);
				switch(paramTypesEnumVal){
				case VOLUME:
					ParamVolume outVol = ((ParamVolume)outputParams.getValue(i));
					//String outputType = readerWriter.getFileExtension(paramOutputFileList.get(0).getAbsolutePath());
					//outVol.getReaderWriter().getExtensionFilter().setPreferredExtension(outputType);
					outVol.setValue(paramOutputFileList.get(0));
					break;
				case VOLUMECOLLECTION:
					ParamVolumeCollection outVolCol = ((ParamVolumeCollection)outputParams.getValue(i));
					//outputType = FilenameUtils.getExtension(paramOutputFileList.get(0).getAbsolutePath());
					//outVolCol.getReaderWriter().getExtensionFilter().setPreferredExtension(outputType);
					for(int j=0; j<paramOutputFileList.size(); j++){
						outVolCol.add(paramOutputFileList.get(j));
					}
					break;
				case INTEGER:
					//ToDo
					break;

				case DOUBLE:
					//ToDo
					break;

				case FILE:
					((ParamFile)outputParams.getValue(i)).setValue(paramOutputFileList.get(0));
					break;
				case FILECOLLECTION:
					ParamFileCollection outFileCol =((ParamFileCollection)outputParams.getValue(i));
					for(int j=0; j<paramOutputFileList.size(); j++){
						outFileCol.add(paramOutputFileList.get(j));
					}
					break;
				case SURFACE:
					((ParamSurface)outputParams.getValue(i)).setValue(paramOutputFileList.get(0));
					break;					
				case STRING:
					break;

				default:
					JistLogger.logError(JistLogger.SEVERE, "Param Type Unrecognized");
					break;
				}

			}
		}

	}

	public String reconcileAndMerge(ParamCollection inputParams2,
			ParamCollection outputParams2) throws InvalidJistMergeException {
		
		String msg = super.reconcileAndMerge(inputParams2, outputParams2);

		// total HACK
		inputParams = inputParams2;
		outputParams = outputParams2;

		return msg;	
}

}
