package edu.jhu.ece.iacl.jist.processcontrol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

import edu.jhu.ece.iacl.jist.pipeline.ExecutionContext;

public class JistSshSession extends Thread {
	private String privateKeyPath;
	private String publicDNS;
	private int port;
	private String finalCmd;
	private ExecutionContext context;
	public JistSshSession(String _privateKeyPath,  String _publicDNS, int _port, String _finalCmd,ExecutionContext _context){
		this.privateKeyPath = _privateKeyPath;
		this.publicDNS = _publicDNS;
		this.port = _port;
		this.finalCmd = _finalCmd;
		this.context = _context;
	}
	public void run(){
		final JSch jsch = new JSch();
		try {
			jsch.addIdentity(privateKeyPath);
		} catch (JSchException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		try {
			final Session session = jsch.getSession("ec2-user", publicDNS, port);
			final ChannelExec channel = (ChannelExec) session.openChannel("exec");

			((ChannelExec) channel).setPty(true);
			channel.setCommand(finalCmd);
			

			channel.connect();

			final InputStream input = channel.getInputStream();

			final Reader reader = new InputStreamReader(input);

			final BufferedReader buffered = new BufferedReader(reader);

			while (true) {

				final String line = buffered.readLine();

				if (line == null) {
					break;
				}

				context.setLineFromAWS(line);
				System.out.println(line);
			}

			channel.disconnect();
			session.disconnect();
		} catch (JSchException | IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}