package edu.vanderbilt.masi.jistcloud;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStatus;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Region;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

import edu.jhu.ece.iacl.jist.pipeline.gui.AwsEC2DashboardPanel;


public class JistAwsEC2 {
	static AmazonEC2 ec2Client;
	
	private String keyPairName;
	private String region;
	private String keyPairAbsolutePath;
	private String securityGroupName;
	private String securityGroupDescription;
	private String imageId;
	private String instanceType;
	private Integer maxInstanceNum;
	private Set<Instance> currentInstances = new HashSet<Instance>();
	private Set<String> currentInstancesId = new HashSet<String>();
	private Set<String> curRunningInstancesId = new HashSet<String>();
	
	//Insert instance id who has installed mipav and jist
	private Set<String> mipavJistInstancesId = new HashSet<String>();
	private static Map<String, Integer> runningInstancesUsage;
	private String S3FS_BIN = "/JistAwsEc2/DoNotDelete/s3fs.bin";
	private String IF_FILE_EXISTS_BIN = "/JistAwsEc2/DoNotDelete/IfFileExists.bin";
	private String IF_DIR_EXISTS_BIN = "/JistAwsEc2/DoNotDelete/IfDirExists.bin";
	private String MIPAV_INSTALL_PARA = "/JistAwsEc2/DoNotDelete/mipavInstallPara";
	// public static void main(String[] args){
	// System.out.println("tesst");
	// AWSCredentials credentials = null;
	// try {
	// credentials = new ProfileCredentialsProvider("default")
	// .getCredentials();
	// } catch (Exception e1) {
	// System.out
	// .println("Credentials were not properly entered into AwsCredentials.properties.");
	// System.out.println(e1.getMessage());
	// System.exit(-1);
	// }
	//
	// ec2Client = new AmazonEC2Client(credentials);
	// ec2Client.setEndpoint("ec2.us-west-2.amazonaws.com");
	//
	//
	// DescribeInstancesResult describeInstancesRequest = ec2Client
	// .describeInstances();
	//
	// List<Reservation> reservations = describeInstancesRequest
	// .getReservations();
	// Set<Instance> instances = new HashSet<Instance>();
	//
	// for (Reservation reservation : reservations) {
	// instances.addAll(reservation.getInstances());
	// }
	//
	// for (Instance x : instances) {
	// System.out.print(x.getLaunchTime());
	// System.out.println(x.getClientToken());
	// System.out.println(x.getInstanceId());
	// }
	//
	// System.out.println("You have " + instances.size()
	// + " Amazon EC2 instance(s) running.");
	// }

	public JistAwsEC2(String _accessKey, String _secretKey, String _regionName) {
		ec2Client = new AmazonEC2Client(
				checkCredentials(_accessKey, _secretKey));
		ec2Client.setEndpoint(_regionName);

	}

	public AmazonEC2 getAmazonEc2Client() {
		return ec2Client;
	}

	public void setAmazonE2Client(AmazonEC2 _p_ec2Client) {
		ec2Client = _p_ec2Client;
	}
	
	public String getRegion() {
		return region;
	}

	public void setRegion(String _p_region) {
		region = _p_region;
	}

	public String getKeyPairName() {
		return keyPairName;
	}

	public void setKeyPairName(String _p_KeyPairName) {
		keyPairName = _p_KeyPairName;
	}

	public String getKeyPairAbsolutePath() {
		return keyPairAbsolutePath;
	}

	public void setKeyPairAbsolutePath(String _p_KeyPairAbsolutePath) {
		keyPairAbsolutePath = _p_KeyPairAbsolutePath;
	}

	public String getSecurityGroupName() {
		return securityGroupName;
	}

	public void setSecurityGroupName(String _p_SecurityGroupName) {
		securityGroupName = _p_SecurityGroupName;
	}

	public String getSecurityGroupDescription() {
		return securityGroupDescription;
	}

	public void setSecurityGroupDescription(String _p_securityGroupDescription) {
		securityGroupDescription = _p_securityGroupDescription;
	}

	public String getImageId() {
		return imageId;
	}

	public void setImageId(String _p_imageID) {
		imageId = _p_imageID;
	}

	public String getInstanceType() {
		return instanceType;
	}

	public void setInstanceType(String _p_instanceType) {
		instanceType = _p_instanceType;
	}

	public Integer getMaxInstanceNum() {
		return maxInstanceNum;
	}

	public void setMaxInstanceNum(Object object) {
		maxInstanceNum = (Integer) object;
	}

	public Set<Instance> getCurrentInstances() {
		return currentInstances;
	}

	public void setCurrentInstances(Set<Instance> _p_currentInstancesId) {
		currentInstances = _p_currentInstancesId;
	}

	public Set<String> getCurrentInstancesId() {
		return currentInstancesId;
	}

	public void setCurrentInstancesId(Set<String> _p_currentInstancesId) {
		currentInstancesId = _p_currentInstancesId;
	}
	
	public Set<String> getCurRunningInstancesId() {
		return curRunningInstancesId;
	}
	
	public void setCurRunningInstancesId(Set<String> _p_curRunningInstancesId) {
		curRunningInstancesId = _p_curRunningInstancesId;
	}

	public static AWSCredentials checkCredentials(String accessKey,
			String secretKey) {
		AWSCredentials credentials = null;
		try {
			credentials = new BasicAWSCredentials(accessKey, secretKey);
			return credentials;
		} catch (Exception e) {
			throw new AmazonClientException(
					"Cannot load the credentials from the credential profiles file. ",
					e);
		}
	}

	public boolean checkNewSecurityGroup(AmazonEC2 ec2, String SecurityGroupName) {
		// set Security Group

		DescribeSecurityGroupsResult describesecurityGroup = ec2
				.describeSecurityGroups();
		List<SecurityGroup> securityGroup = describesecurityGroup
				.getSecurityGroups();

		// CHECK IF KEYNAME EXISTS
		// System.out.println(keypairs.size());
		for (SecurityGroup tmpSecurityGroup : securityGroup) {
			if (tmpSecurityGroup.getGroupName().equals(
					this.getSecurityGroupName()))
				return false;
		}
		return true;
	}

	public void createSecurityGroup(AmazonEC2 ec2, String GroupName,
			String GroupDescription) {
		try {
			CreateSecurityGroupRequest securityGroupRequest = new CreateSecurityGroupRequest(
					GroupName, GroupDescription);
			ec2.createSecurityGroup(securityGroupRequest);
		} catch (AmazonServiceException ase) {
			// Likely this means that the group is already created, so ignore.
			System.out.println(ase.getMessage());
		}

		String ipAddr = "0.0.0.0/0";

		// Create a range that you would like to populate.
		ArrayList<String> ipRanges = new ArrayList<String>();
		ipRanges.add(ipAddr);

		// Open up port 22 for TCP traffic to the associated IP
		// from above (e.g. ssh traffic).
		ArrayList<IpPermission> ipPermissions = new ArrayList<IpPermission>();
		IpPermission ipPermission = new IpPermission();
		ipPermission.setIpProtocol("tcp");
		ipPermission.setFromPort(new Integer(22));
		ipPermission.setToPort(new Integer(22));
		ipPermission.setIpRanges(ipRanges);
		ipPermissions.add(ipPermission);

		try {
			// Authorize the ports to the used.
			AuthorizeSecurityGroupIngressRequest ingressRequest = new AuthorizeSecurityGroupIngressRequest(
					GroupName, ipPermissions);
			ec2.authorizeSecurityGroupIngress(ingressRequest);
		} catch (AmazonServiceException ase) {
			// Ignore because this likely means the zone has
			// already been authorized.
			System.out.println(ase.getMessage());
		}
	}

	public boolean checkNewKeyPair(String keyPairName) {

		// String tmpAbsolutePath = filePath + "/"
		// + keyPairName;
		//
		// this.setKeyPairAbsolutePath(tmpAbsolutePath);
		DescribeKeyPairsResult describekeypairSet = this.getAmazonEc2Client()
				.describeKeyPairs();
		List<KeyPairInfo> keypairs = describekeypairSet.getKeyPairs();

		// CHECK IF KEYNAME EXISTS
		// System.out.println(keypairs.size());
		for (KeyPairInfo tmpKeypair : keypairs) {
			if (tmpKeypair.getKeyName().equals(this.getKeyPairName()))
				return false;
		}
		return true;
	}

	public void createKeyPair(AmazonEC2 ec2, String filePath, String keyPairName) {
		CreateKeyPairRequest createKeyPairRequest = new CreateKeyPairRequest();
		createKeyPairRequest.withKeyName(keyPairName);

		CreateKeyPairResult createKeyPairResult = ec2
				.createKeyPair(createKeyPairRequest);

		KeyPair keyPair = new KeyPair();
		keyPair = createKeyPairResult.getKeyPair();
		String privateKey = keyPair.getKeyMaterial();

		// store the pem key in local
		// String privateKey = keyPair.getKeyMaterial();
		String fileAbsolutelyName = filePath + "/" + keyPairName + ".pem";
		this.setKeyPairAbsolutePath(fileAbsolutelyName);
		File distFile = new File(fileAbsolutelyName);
		BufferedReader bufferedReader = new BufferedReader(new StringReader(
				keyPair.getKeyMaterial()));
		BufferedWriter bufferedWriter;
		try {
			bufferedWriter = new BufferedWriter(new FileWriter(distFile));
			char buf[] = new char[1024];
			int len;
			while ((len = bufferedReader.read(buf)) != -1) {
				bufferedWriter.write(buf, 0, len);
			}
			bufferedWriter.flush();
			bufferedReader.close();
			bufferedWriter.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void runAndInitInstance(JistAwsEC2 jistAwsEC2) {
		RunInstancesRequest runInstancesRequest = new RunInstancesRequest();

		runInstancesRequest.withImageId(jistAwsEC2.getImageId())
				.withInstanceType(jistAwsEC2.getInstanceType()).withMinCount(1)
				.withMaxCount(jistAwsEC2.getMaxInstanceNum())
				.withKeyName(jistAwsEC2.getKeyPairName())
				.withSecurityGroups(jistAwsEC2.getSecurityGroupName());
				

		RunInstancesResult runInstancesResult = jistAwsEC2.getAmazonEc2Client()
				.runInstances(runInstancesRequest);

		Reservation reservationStart = runInstancesResult.getReservation();
		currentInstances.addAll(reservationStart.getInstances());

		// init currentInstanceId
		for (Instance x : currentInstances) {
			currentInstancesId.add(x.getInstanceId());
		}
	}

	public boolean stopInsance(AmazonEC2 ec2, List<String> instanceIds) {
		try {
			refreshStatus();
			
			Iterator<Instance> iterSet = currentInstances.iterator();
			while (iterSet.hasNext()) {
				Instance tmpInstance = iterSet.next();
				String curId = tmpInstance.getInstanceId().toString();
				String curState = tmpInstance.getState().toString();
				System.out.println(curState);
				for (Iterator<String> iterList = instanceIds.listIterator(); iterList
						.hasNext();) {
					String terminateId = iterList.next();
					if (curId.equals(terminateId)) {
						if(curState.contains("running"))
							continue;
						else
							return false;

					}
				}
			}
			StopInstancesRequest stopInstancesRequest = new StopInstancesRequest(
					instanceIds);
			ec2.stopInstances(stopInstancesRequest);
			
		} catch (AmazonServiceException e) {
			// Write out any exceptions that may have occurred.
			System.out.println("Error terminating instances");
			System.out.println("Caught Exception: " + e.getMessage());
			System.out.println("Reponse Status Code: " + e.getStatusCode());
			System.out.println("Error Code: " + e.getErrorCode());
			System.out.println("Request ID: " + e.getRequestId());
		}
		return true;
	}

	public boolean startInstance(AmazonEC2 ec2, List<String> instanceIds) {
		try {
			refreshStatus();
			
			Iterator<Instance> iterSet = currentInstances.iterator();
			while (iterSet.hasNext()) {
				Instance tmpInstance = iterSet.next();
				String curId = tmpInstance.getInstanceId().toString();
				String curState = tmpInstance.getState().toString();
				System.out.println(curState);
				for (Iterator<String> iterList = instanceIds.listIterator(); iterList
						.hasNext();) {
					String terminateId = iterList.next();
					if (curId.equals(terminateId)) {
						if(curState.contains("stopped"))
							continue;
						else
							return false;

					}
				}
			}
			
			StartInstancesRequest startInstancesRequest = new StartInstancesRequest(
					instanceIds);
			ec2.startInstances(startInstancesRequest);
		} catch (AmazonServiceException e) {
			// Write out any exceptions that may have occurred.
			System.out.println("Error terminating instances");
			System.out.println("Caught Exception: " + e.getMessage());
			System.out.println("Reponse Status Code: " + e.getStatusCode());
			System.out.println("Error Code: " + e.getErrorCode());
			System.out.println("Request ID: " + e.getRequestId());
		}
		return true;
	}

	public void removeAllInstances() {
		Iterator<String> iterSet = currentInstancesId.iterator();
		while (iterSet.hasNext()) {
			iterSet.remove();
		}
	}
	
	public void destructor(){
		keyPairName = "";
		region = "";
		keyPairAbsolutePath = "";
		securityGroupName = "";
		securityGroupDescription = "";
		imageId = "";
		instanceType = "";
		maxInstanceNum = 0;
		currentInstances.clear();
		currentInstancesId.clear();
	}

	public void terminateInstance(AmazonEC2 ec2, List<String> instanceIds) {
		try {
			TerminateInstancesRequest terminateRequest = new TerminateInstancesRequest(
					instanceIds);

			Iterator<String> iterSet = currentInstancesId.iterator();
			// Integer tmpMachineNumber;
			while (iterSet.hasNext()) {
				String curId = iterSet.next();
				for (Iterator<String> iterList = instanceIds.listIterator(); iterList
						.hasNext();) {
					String terminateId = iterList.next();
					if (curId.equals(terminateId)) {
						iterSet.remove();
						iterList.remove();
						// tmpMachineNumber = this.getMaxInstanceNum();
						// tmpMachineNumber--;
						// this.setMaxInstanceNum(tmpMachineNumber);
					}
				}
			}
			ec2.terminateInstances(terminateRequest);
		} catch (AmazonServiceException e) {
			// Write out any exceptions that may have occurred.
			System.out.println("Error terminating instances");
			System.out.println("Caught Exception: " + e.getMessage());
			System.out.println("Reponse Status Code: " + e.getStatusCode());
			System.out.println("Error Code: " + e.getErrorCode());
			System.out.println("Request ID: " + e.getRequestId());
		}
	}

	public void refreshStatus() {
		DescribeInstancesResult describeInstancesRequest = ec2Client
				.describeInstances();

		List<Reservation> reservations = describeInstancesRequest
				.getReservations();
		Set<Instance> allEC2Instances = new HashSet<Instance>();
		Set<Instance> newInstances = new HashSet<Instance>();
		

		// System.out.println("Current"+currentInstances.size());
		for (Reservation reservation : reservations) {
			allEC2Instances.addAll(reservation.getInstances());
		}
		// System.out.println("All"+allEC2Instances.size());
		for (Instance x : allEC2Instances) {

			// System.out.println(currentInstances.contains(x));
			if (currentInstancesId.contains(x.getInstanceId())) {
				newInstances.add(x);
			}
		}
		// System.out.println(newInstances.size());
		this.setCurrentInstances(newInstances);
		// System.out.println(currentInstances.size());
	}
	
	public void getRunningInstancesId() {
		//refreshStatus();
		
		Iterator<Instance> iterSet = currentInstances.iterator();
		Set<String> newRunningInstances = new HashSet<String>();
		while (iterSet.hasNext()) {
			Instance tmpInstance = iterSet.next();
			String curId = tmpInstance.getInstanceId().toString();
			String curState = tmpInstance.getState().toString();
			//System.out.println(curState+"aa");
			if(curState.contains("running"))
				newRunningInstances.add(curId);
		}
		this.setCurRunningInstancesId(newRunningInstances);
	}

	public String getInstanceStatus(String instanceId){
		DescribeInstanceStatusRequest request = new DescribeInstanceStatusRequest().withInstanceIds(instanceId);
		DescribeInstanceStatusResult result = ec2Client.describeInstanceStatus(request);
		List<InstanceStatus> state = result.getInstanceStatuses();
		return state.get(0).getInstanceStatus().getStatus();
	}
	
	public void sendS3FStoEC2(Instance runningInstance, String keyPath, String user) throws IOException, InterruptedException{
		//scp -o StrictHostKeyChecking=no -i abc.pem /home/local/VANDERBILT/baos1/JistAwsEc2/DoNotDelete/s3fs.bin ec2-user@ec2-52-26-254-125.us-west-2.compute.amazonaws.com:~
		if(!this.mipavJistInstancesId.contains(runningInstance.getInstanceId())){
			String makeSecretKey  = "chmod 400 "+ keyPath;
			execSecureCopy(makeSecretKey);
			String systemHome = System.getProperties().getProperty("user.home");			
			String cmd = "scp -o StrictHostKeyChecking=no -i "+ keyPath + " "+ systemHome + S3FS_BIN + " " + user+ "@" + runningInstance.getPublicDnsName()+":~";
			execSecureCopy(cmd);
			cmd = "scp -o StrictHostKeyChecking=no -i "+ keyPath + " "+ systemHome + IF_FILE_EXISTS_BIN + " " + user+ "@" + runningInstance.getPublicDnsName()+":~";
			execSecureCopy(cmd);
			cmd = "scp -o StrictHostKeyChecking=no -i "+ keyPath + " "+ systemHome + IF_DIR_EXISTS_BIN + " " + user+ "@" + runningInstance.getPublicDnsName()+":~";
			execSecureCopy(cmd);
			cmd = "scp -o StrictHostKeyChecking=no -i "+ keyPath + " "+ systemHome + MIPAV_INSTALL_PARA + " " + user+ "@" + runningInstance.getPublicDnsName()+":~";
			execSecureCopy(cmd);
		}
	}
	
	public static void execSecureCopy(String cmd) throws IOException, InterruptedException{
		System.out.println(cmd);
		Process process1 = Runtime
				.getRuntime()
				.exec(cmd);
		//System.out.println("wocaaaaa");
		InputStream is1 = process1.getInputStream();
		BufferedReader reader1 = new BufferedReader(new InputStreamReader(is1));
		String line1;
		while ((line1 = reader1.readLine()) != null) {
			System.out.println(line1);
		}
		process1.waitFor();
		is1.close();
		reader1.close();
		process1.destroy();
	}
	
	public void mountS3initialMipavJist(Instance runningInstance, String keyPath, String user) throws Exception {
		// TODO Auto-generated method stub
		if(!this.mipavJistInstancesId.contains(runningInstance.getInstanceId())){
			String makeSecretKey  = "chmod 400 "+ keyPath;
			execSecureCopy(makeSecretKey);
			
			Session session = JistAwsUtil.createSession(keyPath, user, runningInstance.getPublicDnsName(), 22);
			session.setConfig("StrictHostKeyChecking", "no");
			session.connect();
			
			JistAwsUtil.exec(session, "chmod +x s3fs.bin");
			JistAwsUtil.exec(session, "sudo sh -c 'nohup ./s3fs.bin '");		
			JistAwsUtil.exec(session, "cat mipavInstallPara | ./installMIPAV.bin");
			AwsEC2DashboardPanel.numOfCompleteInstall = AwsEC2DashboardPanel.numOfCompleteInstall + 0.6;
//			JistAwsUtil.exec(session, "cd");
//			JistAwsUtil.exec(session, "sudo rm -rf /home/ec2-user/jist-lib");
			
//			JistAwsUtil.exec(session, "cat mipavInstallPara | ./installMIPAV.bin");
			JistAwsUtil.exec(session, "sudo cp /mnt/s3/plugins.zip /home/ec2-user/");
			JistAwsUtil.exec(session, "sudo chmod 777 /home/ec2-user/plugins.zip");
			JistAwsUtil.exec(session, "sudo sh -c 'nohup unzip /home/ec2-user/plugins.zip -d /home/ec2-user/mipav/'");
			JistAwsUtil.exec(session, "sudo cp /mnt/s3/mipav.preferences /home/ec2-user/mipav/");
			JistAwsUtil.exec(session, "sudo sh -c 'nohup unzip /home/ec2-user/mipav.zip -d /home/ec2-user/ '");
			JistAwsUtil.exec(session, "sudo chmod 777 /home/ec2-user/mipav/mipav.preferences");
			System.out.println("DONEDONE");
//			JistAwsUtil.exec(session, "sudo cp /mnt/s3/mipav.preferences /home/ec2-user/mipav/");
//			JistAwsUtil.exec(session, "sudo chmod 777 /mnt/s3/JistUserPreferences.xml");										 
//			JistAwsUtil.exec(session, "sudo cp /mnt/s3/JistUserPreferences.xml /home/ec2-user/jist-lib/");
			session.disconnect();
			mipavJistInstancesId.add(runningInstance.getInstanceId());
		}

	}
	
	public void mountS3ReinitialMipavJist(Instance runningInstance, String keyPath, String user, String bucket) throws Exception {
		// TODO Auto-generated method stub
//		if(!this.mipavJistInstancesId.contains(runningInstance.getInstanceId())){
			String makeSecretKey  = "chmod 400 "+ keyPath;
			execSecureCopy(makeSecretKey);
			
			Session session = JistAwsUtil.createSession(keyPath, user, runningInstance.getPublicDnsName(), 22);
			session.setConfig("StrictHostKeyChecking", "no");
			session.connect();
		
			JistAwsUtil.exec(session, "sudo s3fs "+ bucket +" /mnt/s3 -o allow_other");		

			session.disconnect();
//			mipavJistInstancesId.add(runningInstance.getInstanceId());
//		}
	}
	
	public static String getRunningInstanceIdFromMap(){
		for(String id : runningInstancesUsage.keySet()){
			if(runningInstancesUsage.get(id).equals(1)){
				//1: instance is free
				//0: instance is busy
				runningInstancesUsage.put(id,0);
				System.out.println(id + "is busy~!!");
				return id;
			}
		}
		return null;
	}
	
	public static void setRunningInstanceFromBusyToFree(String id){
		runningInstancesUsage.put(id,1);
		System.out.println(id + "is free~!!");
	}
	
	public HashMap<String, Integer> getRunningInstanceUsage(){
		return (HashMap<String, Integer>) runningInstancesUsage;
	}
	
	public void setRunningInstanceUsage(HashMap<String, Integer> _p_map){
		runningInstancesUsage = _p_map;
	}
//	public String logInEc2AndExecCmd(Instance runningInstance, String keyPath, String user, String cmd) throws JSchException, IOException{
//		System.out.println(cmd);
//		String feedBackFromEC2 = "";
//		JSch jsch = new JSch();
//		String host = runningInstance.getPublicDnsName();
//		jsch.addIdentity(keyPath);
//		Session session = jsch.getSession(user,host, 22);
//		java.util.Properties config = new java.util.Properties();
//		config.put("StrictHostKeyChecking", "no");
//		session.setConfig(config);
//		session.connect();
//
//		ChannelExec channelExec = (ChannelExec) session
//				.openChannel("exec");
//		channelExec
//		.setCommand(cmd);
//		
//		channelExec.connect();
//		
//		InputStream in = channelExec
//				.getInputStream();
//		byte[] tmp = new byte[1024];
//		while (true) {
//			while (in.available() > 0) {
//				int b = in.read(tmp, 0, 1024);
//				if (b < 0)
//					break;
//				
//				feedBackFromEC2 = new String(tmp, 0, b);
//			}
//			
//			if (channelExec.isClosed()) {
//				System.out.println("exit-status: "
//						+ channelExec
//								.getExitStatus());
//				channelExec.disconnect();
//				session.disconnect();
//				in.close();
//				break;
//			}
//			try {
//				Thread.sleep(1000);
//			}
//		
//			catch (Exception ee1) {
//				System.out.print("Inside medium"
//						+ ee1);
//			}
//		
//		}
//		return feedBackFromEC2;
//	}
	

}
