package edu.vanderbilt.masi.jistcloud;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;

public class JistAwsS3 {
	static AmazonS3 s3Client;
	private String s3Bucket;
	private String s3Region;

	/**
	 * SEND TO S3 Mipav install bin, mipavInstallPara, Jist-lib, plugins.zip
	 */
	private String MIPAV = "/JistAwsEc2/DoNotDelete/installMIPAV.bin";
	private String JISTLIB = "/JistAwsEc2/DoNotDelete/jist-lib.zip";
	private String MIPAVINSTALLPARA = "/JistAwsEc2/DoNotDelete/mipav.preferences";
	private String JISTUSERPREFERENCES = "/JistAwsEc2/DoNotDelete/JistUserPreferences.xml";
	private String PLUGINS = "/JistAwsEc2/DoNotDelete/plugins.zip";

	public JistAwsS3(String _accessKey, String _secretKey, String _regionName) {

		s3Client = new AmazonS3Client(checkCredentials(_accessKey, _secretKey));
		s3Client.setEndpoint(_regionName);
	}

	public AmazonS3 getAmazonS3Client() {
		return s3Client;
	}

	public void setS3Client(AmazonS3 _p_s3Client) {
		s3Client = _p_s3Client;
	}

	public String getS3Bucket() {
		return s3Bucket;
	}

	public void setS3Bucket(String _p_s3Bucket) {
		s3Bucket = _p_s3Bucket;
	}

	public String getS3Region() {
		return s3Region;
	}

	public void setS3Region(String _p_s3Region) {
		s3Region = _p_s3Region;
	}

	public static AWSCredentials checkCredentials(String accessKey,
			String secretKey) {
		AWSCredentials credentials = null;
		try {
			credentials = new BasicAWSCredentials(accessKey, secretKey);
			return credentials;
		} catch (Exception e) {
			throw new AmazonClientException(
					"Cannot load the credentials from the credential profiles file. ",
					e);
		}
	}

	public boolean ifBucketValid(String bucket) {
		List<Bucket> s3Bucket = new ArrayList<Bucket>();
		s3Bucket = s3Client.listBuckets();

		System.out.println(s3Bucket.size());
		for (Bucket b : s3Bucket) {
			if (b.getName().equals(bucket)) {
				System.out.println("false");
				return false;
			}
		}
		System.out.println("true");
		return true;

	}

	public boolean sendMipavJistToS3(AmazonS3 s3, String bucketName) {
		String systemHome = System.getProperties().getProperty("user.home");

		ObjectListing list1 = s3.listObjects(bucketName, "installMIPAV.bin");
		ObjectListing list2 = s3.listObjects(bucketName, "jist-lib.zip");
		ObjectListing list3 = s3.listObjects(bucketName, "mipav.preferences");
		ObjectListing list4 = s3.listObjects(bucketName, "JistUserPreferences.xml");
		ObjectListing list5 = s3.listObjects(bucketName, "plugins.zip");

		int objSumSize1 = list1.getObjectSummaries().size();
		int objSumSize2 = list2.getObjectSummaries().size();
		int objSumSize3 = list3.getObjectSummaries().size();
		int objSumSize4 = list4.getObjectSummaries().size();
		int objSumSize5 = list5.getObjectSummaries().size();

		if (objSumSize1 * objSumSize2 * objSumSize3 * objSumSize4 * objSumSize5 == 0) {

			if (objSumSize1 == 0) {
				System.out.println("FIREEEEEEEEEEEEEEEEEE");
				File file1 = new File(systemHome + MIPAV);
				s3.putObject(new PutObjectRequest(bucketName,
						"installMIPAV.bin", file1));
			}

			if (objSumSize2 == 0) {
				System.out.println("FIREEEEEEEEEEEEEEEEEE");
				File file2 = new File(systemHome + JISTLIB);
				s3.putObject(new PutObjectRequest(bucketName, "jist-lib.zip",
						file2));

			}

			if (objSumSize3 == 0) {
				System.out.println("FIREEEEEEEEEEEEEEEEEE");
				File file3 = new File(systemHome + MIPAVINSTALLPARA);
				s3.putObject(new PutObjectRequest(bucketName,
						"mipav.preferences", file3));
			}

			if (objSumSize4 == 0) {
				System.out.println("FIREEEEEEEEEEEEEEEEEE");
				File file4 = new File(systemHome + JISTUSERPREFERENCES);
				s3.putObject(new PutObjectRequest(bucketName,
						"JistUserPreferences.xml", file4));
			}

			if (objSumSize5 == 0) {
				System.out.println("FIREEEEEEEEEEEEEEEEEE");
				File file5 = new File(systemHome + PLUGINS);
				s3.putObject(new PutObjectRequest(bucketName, "plugins.zip",
						file5));
			}

		} else {
			return false;
		}

		return true;
	}

	public boolean ifMipavJistTranserDone(AmazonS3 s3, String bucketName) {
		ObjectListing list1 = s3.listObjects(bucketName, "mipav.zip");
		ObjectListing list2 = s3.listObjects(bucketName, "jist-lib.zip");
		ObjectListing list3 = s3.listObjects(bucketName, "mipav.preferences");
		ObjectListing list4 = s3.listObjects(bucketName,
				"JistUserPreferences.xml");
		ObjectListing list5 = s3.listObjects(bucketName, "plugins.zip");

		int ob1 = list1.getObjectSummaries().size();
		int ob2 = list2.getObjectSummaries().size();
		int ob3 = list3.getObjectSummaries().size();
		int ob4 = list4.getObjectSummaries().size();
		int ob5 = list5.getObjectSummaries().size();

		if ((ob1 * ob2 * ob3 * ob4 * ob5) > 0)
			return true;
		return false;
	}
	
	public boolean removeBucket(AmazonS3 s3, String bucketName){
		ObjectListing s =s3.listObjects(bucketName);
		
		for(S3ObjectSummary s3Summary : s.getObjectSummaries() ){
			//System.out.println(s1.getKey());
			s3.deleteObject(bucketName, s3Summary.getKey());
		}
		s3.deleteBucket(bucketName);
		return true;
	}
}
