package edu.vanderbilt.masi.jistcloud;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

import edu.jhu.ece.iacl.jist.pipeline.ExecutionContext;
import edu.jhu.ece.iacl.jist.pipeline.gui.ProcessManager;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class JistAwsUtil {

	private static ExecutionContext context = null;
	
	public JistAwsUtil(ExecutionContext _p_context){
		this.setContext(_p_context);
	}
	
	public static Session createSession(String privateKeyPath, String user,
			String publicDNS, int port) throws JSchException {
		final JSch jsch = new JSch();

		// final String home = System.getProperty("user.home");

		// final File file = new File(privateKeyPath);

		jsch.addIdentity(privateKeyPath);

		// final String username = user;
		// final String hostname = publicDNS;
		// final int port = 22;

		final Session session = jsch.getSession(user, publicDNS, port);

		return session;
	}

	public static InputStream exec(Session session, String command) throws Exception {

		final ChannelExec channel = (ChannelExec) session.openChannel("exec");

		((ChannelExec) channel).setPty(true);
		channel.setCommand(command);

		channel.connect();

		final InputStream input = channel.getInputStream();

		
		final Reader reader = new InputStreamReader(input);

		final BufferedReader buffered = new BufferedReader(reader);

		while (true) {

			final String line = buffered.readLine();

			if (line == null) {
				break;
			}

			System.out.println(line);
		}

		channel.disconnect();
		return input;

	}
	
	public static InputStream execFinalCmd(Session session, String command, ExecutionContext p_context) throws Exception {
	
						
			final ChannelExec channel = (ChannelExec) session.openChannel("exec");

			((ChannelExec) channel).setPty(true);
			channel.setCommand(command);

			channel.connect();

			final InputStream input = channel.getInputStream();
			
		

			final Reader reader = new InputStreamReader(input);

			final BufferedReader buffered = new BufferedReader(reader);

			while (true) {

				final String line = buffered.readLine();

				if (line == null) {
					break;
				}

				getContext().setLineFromAWS(line);
				System.out.println(line);
			}

			channel.disconnect();
			getContext().setExecCompleteFromAWS(true);
		
		
		
		return input;

	}
	
	public static void DeleteAwsTmpFile(String path){
		File f = new File(path);
		System.out.println(f.getParent());
		
		for(File file : f.listFiles()){
			try {
				FileDeleteStrategy.FORCE.delete(file);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	public static void SendZipProjectInputToCloud(String projectAbsolutePath, String layoutAbsolutePath, String layoutTitle) throws IOException{
		//File dirToUpload = new File("/home/local/VANDERBILT/baos1/Desktop/JISTSTEVE");
		File dirToUpload = new File(projectAbsolutePath);
		System.out.println(dirToUpload.getName());
		String expName = dirToUpload.getName();
		File dir = new File(System.getProperties()
				.getProperty("user.home")+"/JistAwsEc2/tmp/"+dirToUpload.getName());
		if (dir.exists()) {
			System.out.println("Create dir " + expName
					+ " failure, dir has existed");
			
			String origindir = System.getProperties()
					.getProperty("user.home")+"/JistAwsEc2/tmp/"+dirToUpload.getName();	
			String[] dirCheck = origindir.split("/");
			if(dirCheck[dirCheck.length-1].contains(".")){
				dirCheck[dirCheck.length-1] = dirCheck[dirCheck.length-1].replace(".", "");
				origindir = "";
				for(int i = 1; i<dirCheck.length;++i){
					origindir = origindir +  File.separator + dirCheck[i];
				}
			}
			
			FileUtils.deleteDirectory(new File(origindir));
			
		}
		if (!dirToUpload.getName().endsWith(File.separator)) {
			expName = expName + File.separator;
		}
		// create dir
		if (dir.mkdirs()) {
			System.out.println("Create dir " + expName + " success");

			//CREATE INPUT FOLDER IF NEEDED
			File inputFolder = new File(dir.getAbsolutePath()+"/INPUT");
			inputFolder.mkdir();
			
			//File layoutXML = new File("/home/local/VANDERBILT/baos1/Desktop/JISTSTEVE/JIST_3_0_DTI_CLOUD.LayoutXML");
			File layoutXML = new File(layoutAbsolutePath);
			//File exp_0000 = new File("/home/local/VANDERBILT/baos1/Desktop/JISTSTEVE/exp-0000");
			//File exp_0000 = new File(projectAbsolutePath+"/exp-0000");
			//Shunxing update exp-* JULY 31
			File exp_star = new File(projectAbsolutePath);
			
			File[] files = exp_star.listFiles();
			Vector<File> expList = new Vector<File>();
			Vector<String> expNameList = new Vector<String>();
			for (File f : files) {
				System.out.println(f.getAbsolutePath());
				if (f.isDirectory()) {
					String expDirName = f.getName();
					int in = expDirName.indexOf("exp-");
					if (in == 0) {
						expList.add(f);
						expNameList.add(expDirName);
					}
				}
			}
			
			
			try {
				Files.copy(Paths.get(layoutAbsolutePath),Paths.get(dir.getAbsolutePath()+"/"+layoutTitle),StandardCopyOption.REPLACE_EXISTING);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			for (int i = 0; i < expList.size(); ++i){
				if(expList.get(i).exists()){
					try {
						FileUtils.copyDirectory(new File(projectAbsolutePath+File.separator+ expNameList.get(i)),new File(dir.getAbsolutePath()+File.separator+ expNameList.get(i)));
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}

		} else {
			System.out.println("Create dir " + expName
					+ " failure, dir has existed");
		}
		
		JistAwsUtil.arraylistFile = new ArrayList<File>();
		JistAwsUtil.arraylistFile = JistAwsUtil
				.updatePathAndSendToS3(dir);
		String layoutLocalPth = dirToUpload.getParent();

		for (File tmpFile : JistAwsUtil.arraylistFile) {
			System.out.println(tmpFile.getName());
			Path srcpath = Paths.get(tmpFile.getAbsolutePath());
			Charset charset = StandardCharsets.UTF_8;

			String content = new String(
					Files.readAllBytes(srcpath), charset);
			String originTmpContent = content;
			
				if(content.contains("<file>")){
					
				
				String[] tagsFile = StringUtils.substringsBetween(content, "<file>", "</file>");
				
				//Set for eliminate same tags
				Set<String> mytagsFileSet = new HashSet<String>(Arrays.asList(tagsFile));
				for(String eachFile : mytagsFileSet){
					
					//CHANGE BY SHUNXING 
					//Shunxing update exp-* JULY 31
					//if(eachFile.contains(projectAbsolutePath +"/exp-0000")){
					if(eachFile.contains(projectAbsolutePath +"/exp-")){
					//if(eachFile.contains("/exp-0000")){
						//if Input file is generated by experiment
						if(eachFile.contains(layoutLocalPth)){
							
							
							String tmpExp000Tag = eachFile.replace(layoutLocalPth, "/mnt/s3");
							System.out.println(tmpExp000Tag);
							//content = content.replaceAll(eachFile,tmpExp000Tag);
							content = StringUtils.replace(content,eachFile,tmpExp000Tag);
						}
					} else {
						//if Input file is from 
						String[] tmpInputFileAbsolutePath = eachFile.split("/");
						
						if(tmpInputFileAbsolutePath.length == 1){
							String tmpInputFileTag = tmpInputFileAbsolutePath[0].replace(tmpInputFileAbsolutePath[0], "/mnt/s3/"+ expName + "INPUT/" + tmpInputFileAbsolutePath[0]);
							//content = content.replaceAll(eachFile,tmpInputFileTag);
							content = StringUtils.replace(content,eachFile,tmpInputFileTag);
							//COPY file to INPUT FOLDER
							if(tmpFile.exists()){
								File checkEachFileExist = new File(eachFile);
								if(checkEachFileExist.exists()){
									Files.copy(Paths.get(eachFile),Paths.get(dir.getAbsolutePath()+"/INPUT/"+tmpInputFileAbsolutePath[0]),StandardCopyOption.REPLACE_EXISTING);
								}
							}
						} else {
							String tmpInputFileTag = eachFile.replace(eachFile, "/mnt/s3/"+ expName + "INPUT" + eachFile);
							//content = content.replaceAll(eachFile,tmpInputFileTag);
							content = StringUtils.replace(content,eachFile,tmpInputFileTag);
							//create dir for Input file
							String inputFolderAbsolutePath = dir.getAbsolutePath()+"/INPUT";
							for(int i = 0; i < tmpInputFileAbsolutePath.length -1; ++i){
								inputFolderAbsolutePath = inputFolderAbsolutePath + "/" + tmpInputFileAbsolutePath[i];
								File tmpInputSubFolder = new File(inputFolderAbsolutePath);
								if(!tmpInputSubFolder.exists()){
									tmpInputSubFolder.mkdir();
								}
							}
							//COPY file to INPUT FOLDER with several subfolder
							System.out.println(eachFile);
							System.out.println(tmpFile);
							if(tmpFile.exists()){
								File checkEachFileExist = new File(eachFile);
								if(checkEachFileExist.exists()){
									Files.copy(Paths.get(eachFile),Paths.get(dir.getAbsolutePath()+"/INPUT/"+eachFile),StandardCopyOption.REPLACE_EXISTING);
								}
							}
						}
						
					}
				}
				
				//content = content.replaceAll("file:/mnt/s3", "file:///mnt/s3");
				content =  StringUtils.replace(content,"file:/mnt/s3","file:///mnt/s3");
	
				if (!content.equals(originTmpContent)) {			
					Files.write(Paths.get(tmpFile.getAbsolutePath()), content.getBytes(charset));

				}

			}
		}
		
		
	}
	
	public static void SendZipProjectInputToCloudNew(String projectAbsolutePath, String layoutAbsolutePath, String layoutTitle) throws IOException{
		//File dirToUpload = new File("/home/local/VANDERBILT/baos1/Desktop/JISTSTEVE");
		File dirToUpload = new File(projectAbsolutePath);
		System.out.println(dirToUpload.getName());
		String expName = dirToUpload.getName();
		File dir = new File(System.getProperties()
				.getProperty("user.home")+"/JistAwsEc2/tmp/"+dirToUpload.getName());
		if (dir.exists()) {
			System.out.println("Create dir " + expName
					+ " failure, dir has existed");
			FileUtils.deleteDirectory(new File(System.getProperties()
					.getProperty("user.home")+"/JistAwsEc2/tmp/"+dirToUpload.getName()));
			
		}
		if (!dirToUpload.getName().endsWith(File.separator)) {
			expName = expName + File.separator;
		}
		// create dir
		if (dir.mkdirs()) {
			System.out.println("Create dir " + expName + " success");

			//CREATE INPUT FOLDER IF NEEDED
			File inputFolder = new File(dir.getAbsolutePath()+"/INPUT");
			inputFolder.mkdir();
			
			//File layoutXML = new File("/home/local/VANDERBILT/baos1/Desktop/JISTSTEVE/JIST_3_0_DTI_CLOUD.LayoutXML");
			File layoutXML = new File(layoutAbsolutePath);
			//File exp_0000 = new File("/home/local/VANDERBILT/baos1/Desktop/JISTSTEVE/exp-0000");
			File exp_0000 = new File(projectAbsolutePath+"/exp-0000");
			
			try {
				Files.copy(Paths.get(layoutAbsolutePath),Paths.get(dir.getAbsolutePath()+"/"+layoutTitle),StandardCopyOption.REPLACE_EXISTING);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if(exp_0000.exists()){
				try {
					FileUtils.copyDirectory(new File(projectAbsolutePath+"/exp-0000"),new File(dir.getAbsolutePath()+"/exp-0000"));
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		} else {
			System.out.println("Create dir " + expName
					+ " failure, dir has existed");
		}
		
		JistAwsUtil.arraylistFile = new ArrayList<File>();
		JistAwsUtil.arraylistFile = JistAwsUtil
				.updatePathAndSendToS3(dir);
		String layoutLocalPth = dirToUpload.getParent();

		for (File tmpFile : JistAwsUtil.arraylistFile) {
			System.out.println(tmpFile.getName());
			Path srcpath = Paths.get(tmpFile.getAbsolutePath());
			Charset charset = StandardCharsets.UTF_8;

			BufferedReader br = new BufferedReader(new FileReader(new File(tmpFile.getAbsolutePath())));
			String line;
			StringBuilder sb = new StringBuilder();
			
			while((line=br.readLine())!=null){
				sb.append(line);
			}
			
			String content = sb.toString();
//			String content = new String(
//					Files.readAllBytes(srcpath), charset);
			String originTmpContent = content;
			
				if(content.contains("<file>")){
					
				
				String[] tagsFile = StringUtils.substringsBetween(content, "<file>", "</file>");
				
				//Set for eliminate same tags
				Set<String> mytagsFileSet = new HashSet<String>(Arrays.asList(tagsFile));
				for(String eachFile : mytagsFileSet){
					
					//CHANGE BY SHUNXING 
					if(eachFile.contains(projectAbsolutePath +"/exp-0000")){
					//if(eachFile.contains("/exp-0000")){
						//if Input file is generated by experiment
						if(eachFile.contains(layoutLocalPth)){
							
							
							String tmpExp000Tag = eachFile.replace(layoutLocalPth, "/mnt/s3");
							System.out.println(tmpExp000Tag);
							//content = content.replaceAll(eachFile,tmpExp000Tag);
							content = StringUtils.replace(content,eachFile,tmpExp000Tag);
						}
					} else {
						//if Input file is from 
						String[] tmpInputFileAbsolutePath = eachFile.split("/");
						
						if(tmpInputFileAbsolutePath.length == 1){
							String tmpInputFileTag = tmpInputFileAbsolutePath[0].replace(tmpInputFileAbsolutePath[0], "/mnt/s3/"+ expName + "INPUT/" + tmpInputFileAbsolutePath[0]);
							//content = content.replaceAll(eachFile,tmpInputFileTag);
							content = StringUtils.replace(content,eachFile,tmpInputFileTag);
							//COPY file to INPUT FOLDER
							if(tmpFile.exists()){
								File checkEachFileExist = new File(eachFile);
								if(checkEachFileExist.exists()){
									
									Files.copy(Paths.get(eachFile),Paths.get(dir.getAbsolutePath()+"/INPUT/"+tmpInputFileAbsolutePath[0]),StandardCopyOption.REPLACE_EXISTING);
								}
							}
								
						} else {
							String tmpInputFileTag = eachFile.replace(eachFile, "/mnt/s3/"+ expName + "INPUT" + eachFile);
							//content = content.replaceAll(eachFile,tmpInputFileTag);
							content = StringUtils.replace(content,eachFile,tmpInputFileTag);
							//create dir for Input file
							String inputFolderAbsolutePath = dir.getAbsolutePath()+"/INPUT";
							for(int i = 0; i < tmpInputFileAbsolutePath.length -1; ++i){
								inputFolderAbsolutePath = inputFolderAbsolutePath + "/" + tmpInputFileAbsolutePath[i];
								File tmpInputSubFolder = new File(inputFolderAbsolutePath);
								if(!tmpInputSubFolder.exists()){
									tmpInputSubFolder.mkdir();
								}
							}
							//COPY file to INPUT FOLDER with several subfolder
							System.out.println(eachFile);
							System.out.println(tmpFile);
							if(tmpFile.exists()){
								File checkEachFileExist = new File(eachFile);
								if(checkEachFileExist.exists()){
									Files.copy(Paths.get(eachFile),Paths.get(dir.getAbsolutePath()+"/INPUT/"+eachFile),StandardCopyOption.REPLACE_EXISTING);
								}
							}
						}
						
					}
				}
				
				//content = content.replaceAll("file:/mnt/s3", "file:///mnt/s3");
				content =  StringUtils.replace(content,"file:/mnt/s3","file:///mnt/s3");
	
				if (!content.equals(originTmpContent)) {			
					//Files.write(Paths.get(tmpFile.getAbsolutePath()), content.getBytes(charset));
					FileWriter out = new FileWriter(tmpFile.getAbsolutePath());
					out.write(content);
					out.close();

				}

			}
		}		
	}
	public static boolean execIfComplete(Session session, String command) throws Exception {

		final ChannelExec channel = (ChannelExec) session.openChannel("exec");

		((ChannelExec) channel).setPty(true);
		channel.setCommand(command);

		channel.connect();

		final InputStream input = channel.getInputStream();

		final Reader reader = new InputStreamReader(input);

		final BufferedReader buffered = new BufferedReader(reader);

		while (true) {

			final String line = buffered.readLine();

			if (line == null) {
				break;
			}

			if(line.contains("Does Not")){
				channel.disconnect();
				return false;
			}
				
		}

		channel.disconnect();
		return true;
	}
	
	public static boolean execIfHasFile(Session session, String command) throws Exception {

		final ChannelExec channel = (ChannelExec) session.openChannel("exec");

		((ChannelExec) channel).setPty(true);
		channel.setCommand(command);

		channel.connect();

		final InputStream input = channel.getInputStream();

		final Reader reader = new InputStreamReader(input);

		final BufferedReader buffered = new BufferedReader(reader);

		while (true) {

			final String line = buffered.readLine();

			if (line == null) {
				break;
			}

			if(line.contains("Does Not")){
				channel.disconnect();
				return false;
			}
				
		}

		channel.disconnect();
		return true;
	}
	
	public static void createExpDir(String expSrcName, String expName, ArrayList<String> allExpUniqueNam){
		String freeRunningInstanceId = ProcessManager.jistAwsEC2.getRunningInstanceIdFromMap();
		
		String keyPath = ProcessManager.jistAwsEC2.getKeyPairAbsolutePath();
		String user = "ec2-user";
		DescribeInstancesRequest describeInstanceRequest = new DescribeInstancesRequest()
				.withInstanceIds(freeRunningInstanceId);
		DescribeInstancesResult describeInstanceResult = ProcessManager.jistAwsEC2
				.getAmazonEc2Client()
				.describeInstances(describeInstanceRequest);

		Instance runningInstance = describeInstanceResult.getReservations()
				.get(0).getInstances().get(0);
		Session session;
		try {
			session = JistAwsUtil.createSession(keyPath, user,
					runningInstance.getPublicDnsName(), 22);
			session.setConfig("StrictHostKeyChecking", "no");
			session.connect();

			try {
				JistAwsUtil.exec(session, "cd && chmod 777 IfDirExists.bin");
				String mkdir1 = "./IfDirExists.bin /mnt/s3/" + expSrcName;
				JistAwsUtil.exec(session, mkdir1);
				String mkdir2 = mkdir1 + "/" + expName;
				JistAwsUtil.exec(session, mkdir2);
				
				String mkdir3 = mkdir2 + "/";
				for(String tmpdir  : allExpUniqueNam){
					mkdir3 = mkdir3 + tmpdir;
					JistAwsUtil.exec(session, mkdir3);
					mkdir3 = mkdir2 + "/";
					
					String mkdir4 = mkdir3 + "/";
					File tmpdirFile = new File(ProcessManager.layoutParentLocation+"/"+expName+"/"+tmpdir);
					String[] allOutputPicName = tmpdirFile.list();
					System.out.println(allOutputPicName.length+"????");
					for(String tmpSubDir : allOutputPicName){
						if(!(tmpSubDir.contains(".err")||tmpSubDir.contains(".out")||tmpSubDir.contains(".input")||tmpSubDir.contains(".output"))){
							mkdir4 = mkdir4 + tmpSubDir;
							System.out.println("niya!!!!!!!!!!!!!!!!!");
							JistAwsUtil.exec(session, mkdir4);
							//mkdir4 = mkdir3 + "/";
						}
					}
					
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			session.disconnect();
			ProcessManager.jistAwsEC2.setRunningInstanceFromBusyToFree(freeRunningInstanceId);
		} catch (JSchException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static List<File> arraylistFile = new ArrayList<File>();
	public static List<File> updatePathAndSendToS3(File node){
		 
		if((node.getName().contains(".output"))||(node.getName().contains(".input"))){
			arraylistFile.add(node);
		}
 
		if(node.isDirectory()){
			String[] subNote = node.list();
			for(String filename : subNote){
				updatePathAndSendToS3(new File(node, filename));
			}
		}
		return arraylistFile;
 
	}

	public static void main(String[] args) throws Exception {

		//

		final JSch jsch = new JSch();

		final String home = System.getProperty("user.home");

		final File file = new File(home, "/Downloads/firstInstance.pem");

		String keyPath = home + "/Downloads/firstInstance.pem";
		//

		jsch.addIdentity(file.getAbsolutePath());

		final String username = "ec2-user";
		final String hostname = "ec2-52-10-200-250.us-west-2.compute.amazonaws.com";
		final int port = 22;

		final Session session = createSession(keyPath, username, hostname, port);

		session.setConfig("StrictHostKeyChecking", "no");

		//

		// final String repo = "http://extras.ubuntu.com/ubuntu/ oneiric main";

		session.connect();

		// exec(session, "sudo mkdir woca");
		//
		// exec(session, "mkdir qnm");

		exec(session, "chmod +x s3fs.bin");

		exec(session, "sudo ./s3fs.bin");

		exec(session, "cd");

		exec(session, "sudo rm -rf /home/ec2-user/jist-lib");
		exec(session,
				"sudo unzip /home/ec2-user/jist-lib.zip -d /home/ec2-user/");

		exec(session, "sudo rm -rf /home/ec2-user/mipav");
		exec(session, "sudo unzip /home/ec2-user/mipav.zip -d /home/ec2-user/");

		// exec(session,
		// "wget http://s3fs.googlecode.com/files/s3fs-1.61.tar.gz");
		//
		// exec(session, "tar -xzf s3fs-1.61.tar.gz");
		//
		// exec(session,
		// "sudo yum -y install make glibc-devel gcc gcc-c++ libxml2-devel libcurl-devel fuse-devel openssl-devel");
		//
		// exec(session, "cd s3fs-1.61");
		//
		// exec(session,"./configure --prefix=/usr/");
		//
		// exec(session, "sudo make");
		//
		// exec(session, "sudo make install");
		//
		// exec(session,
		// "sudo touch /etc/passwd-s3fs && sudo chmod 640 /etc/passwd-s3fs");
		//
		// exec(session, "cd");
		//
		// exec(session,
		// "vim passwd-s3fs -c '$put = \"sdasad/QiRLVrQfNSjsSpHiyiHzm7\"' -c ':wq'");
		//
		//
		//
		// exec(session, "cd");
		//
		// exec(session, "mkdir bbb");
		//
		// exec(session, "sudo mkdir /mnt/s3");

		// exec(session, "sudo s3fs onealbaobaobao /mnt/s3 -o allow_other");
		//
		// //
		//
		// exec(session, "sudo mkdir --verbose --parents /opt/java32");
		//
		// exec(session,
		// "cd /opt/java32; sudo wget  --timestamping"
		// +
		// " http://download.oracle.com/otn-pub/java/jdk/7u1-b08/jdk-7u1-linux-i586.tar.gz");
		//
		// exec(session,
		// "cd /opt/java32; sudo tar --extract --gzip --keep-newer-files --totals"
		// + " --file jdk-7u1-linux-i586.tar.gz");
		//
		// exec(session, "sudo update-alternatives --verbose"
		// + " --remove-all java");
		//
		// exec(session,
		// "sudo update-alternatives --verbose"
		// +
		// " --install /usr/bin/java java /opt/java32/jdk1.7.0_01/bin/java 10");
		//
		// exec(session, "java -version 2>&1");
		//
		// //
		//
		// exec(session, "sudo addgroup --system karaf");
		// exec(session, "sudo adduser --system "
		// + " --ingroup karaf --home /var/karaf karaf");
		// exec(session, "sudo adduser ubuntu karaf");
		//
		// // exec(session, "sudo mkdir --parents /var/karaf");
		//
		// // exec(session, "sudo cp --recursive /home/ubuntu/.ssh /var/karaf");
		//
		// exec(session,
		// "sudo chown --changes --recursive ubuntu:karaf /var/karaf");
		// exec(session,
		// "sudo chmod --changes --recursive o-rwx,g+rw,g+s,u-s /var/karaf");
		//
		// // DIFF=$(expr $(date +%s) - $(stat --format %X /var/lib/apt/lists) )
		//
		// // exec(session, "sudo reboot");

		session.disconnect();

		//

	}

	public static ExecutionContext getContext() {
		return context;
	}

	public static void setContext(ExecutionContext context) {
		JistAwsUtil.context = context;
	}
	
	public static void zipFile(File inputFile, String zipFilePath){
		try{
	        FileOutputStream fileOutputStream = new FileOutputStream(zipFilePath);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);

            // a ZipEntry represents a file entry in the zip archive
            // We name the ZipEntry after the original file's name
            ZipEntry zipEntry = new ZipEntry(inputFile.getName());
            zipOutputStream.putNextEntry(zipEntry);

            FileInputStream fileInputStream = new FileInputStream(inputFile);
            byte[] buf = new byte[1024];
            int bytesRead;

            // Read the input file by chucks of 1024 bytes
            // and write the read bytes to the zip stream
            while ((bytesRead = fileInputStream.read(buf)) > 0) {
                zipOutputStream.write(buf, 0, bytesRead);
            }

            // close ZipEntry to store the stream to the file
            zipOutputStream.closeEntry();

            zipOutputStream.close();
            fileOutputStream.close();

            System.out.println("Regular file :" + inputFile.getCanonicalPath()+" is zipped to archive :"+zipFilePath);

        } catch (IOException e) {
            e.printStackTrace();
        }
	}
	
	public static boolean deleteDir(File dir) {
		File candir;
		try {
			candir = dir.getCanonicalFile();
		} catch (IOException e) {
			JistLogger.logError(JistLogger.SEVERE, "jist.base: "+e.getMessage());
			return false;
		}
		File[] files = candir.listFiles();

		int count = 0;
		if (files != null) {
			for (File file : files) {
				boolean deleted = file.delete();
				if (!deleted) {
					if (file.isDirectory()) {
						deleteDir(file);
					}
				}
			}
		}
		return dir.delete();
	}
	
	public static boolean createSciptsForCloud(String doNotDeletepath) throws IOException{
		//File: IfDirExists.bin
		File fIfDirExists = new File(doNotDeletepath + File.separator + "IfDirExists.bin");
		if(fIfDirExists.exists()){
			System.out.println("IfDirExists.bin exists");
		} else {
			String ifDirExits = "#!/bin/sh\nDIR=$1\n\n" + "if [ ! -d \"$DIR\" ]\n"
					+ "then\n" + "    echo \"DIR $DIR does not exist.\"\n"
					+ "    mkdir $DIR\n" + "fi";
			
			FileWriter out = new FileWriter(doNotDeletepath + File.separator + "IfDirExists.bin");
			out.write(ifDirExits);
			out.close();
		}
		// System.out.println(ifDirExits);
		
		//File: IfFileExists.bin
		File fIfFileExists = new File(doNotDeletepath + File.separator + "IfFileExists.bin");
		if(fIfFileExists.exists()){
			System.out.println("IfDirExists.bin exists");
		} else {
			String ifFileExists = "#!/bin/bash\nFILE=$1\nif [ -f $FILE ]; then\n    echo \"File '$FILE' Exists\"\nelse\n    echo \"The File '$FILE' Does Not Exist\"\nfi";
			FileWriter out = new FileWriter(doNotDeletepath + File.separator + "IfFileExists.bin");
			out.write(ifFileExists);
			out.close();
		}
		//System.out.println(ifFileExists);
		
		//File: mipavInstallPara
		File fmipavInstallPara = new File(doNotDeletepath + File.separator + "mipavInstallPara");
		if(fmipavInstallPara.exists()){
			System.out.println("IfDirExists.bin exists");
		} else {
			String mipavInstallPara = "\nY\n\n\n\n\n\n\n";
			FileWriter out = new FileWriter(doNotDeletepath + File.separator + "mipavInstallPara");
			out.write(mipavInstallPara);
			out.close();
		}
	//	System.out.println(mipavInstallPara);
		
		//File: s3fs_template.bin
		File fs3fs_template = new File(doNotDeletepath + File.separator + "s3fs_template.bin");
		if(fs3fs_template.exists()){
			System.out.println("IfDirExists.bin exists");
		} else {
			String s3fs_template = "cd\n"
					+ "#download s3fs\n\n"
					+ "wget http://s3fs.googlecode.com/files/s3fs-1.61.tar.gz\n"
					+ "tar -xzf s3fs-1.61.tar.gz\n\n"
					+ "#install necessary package\n"
					+ "sudo yum -y install make glibc-devel gcc gcc-c++ libxml2-devel libcurl-devel fuse-devel openssl-devel\n"
					+ "sudo yum -y install xorg-x11-server-Xvfb\n\n"
					+ "#compile and run s3fs\n"
					+ "cd s3fs-1.61\n"
					+ "./configure --prefix=/usr/\n"
					+ "sudo make\n"
					+ "sudo make install\n\n"
					+ "#create aws credential\n"
					+ "sudo touch /etc/passwd-s3fs && sudo chmod 640 /etc/passwd-s3fs\n"
					+ "sudo vim /etc/passwd-s3fs -c '$put = \\\"$ACCESSKEY$:$SECRETKEY$\\\"' -c ':wq'\n\n"
					+ "#create mount folder\n"
					+ "sudo mkdir /mnt/s3\n\n"
					+ "#mount s3, need to use own bucket\n"
					+ "sudo s3fs $BUCKET$ /mnt/s3 -o allow_other\n\n"
					+ "clear\n\n"
					+ "#sudo rm -rf /home/ec2-user/jist-lib\n"
					+ "cd\n"
					+ "sudo cp /mnt/s3/jist-lib.zip /home/ec2-user/\n"
					+ "sudo chmod 777 /home/ec2-user/jist-lib.zip\n"
					+ "sudo sh -c 'nohup unzip /home/ec2-user/jist-lib.zip -d /home/ec2-user/'\n\n"
					+ "cd\n"
					+ "sudo cp /mnt/s3/installMIPAV.bin /home/ec2-user/\n"
					+ "sudo chmod 777 /home/ec2-user/installMIPAV.bin\n\n"
					+ "#cd\n"
					+ "#cat mipavInstallPara | ./installMIPAV.bin\n\n"
					+ "#sudo cp plugins.zip /home/ec2-user/\n"
					+ "#sudo cp plugins.zip /home/ec2-user/\n"
					+ "#sudo sh -c 'nohup unzip /home/ec2-user/plugins.zip -d /home/ec2-user/mipav'\n\n"
					+ "#sudo cp /mnt/s3/mipav.preferences /home/ec2-user/mipav/\n"
					+ "#sudo chmod 777 /home/ec2-user/mipav/mipav.preferences\n\n"
					+ "sudo cp /mnt/s3/JistUserPreferences.xml /home/ec2-user/jist-lib/\n"
					+ "sudo chmod 777 /home/ec2-user/jist-lib/JistUserPreferences.xml";
			FileWriter out = new FileWriter(doNotDeletepath + File.separator + "s3fs_template.bin");
			out.write(s3fs_template);
			out.close();
		}
		//System.out.println(s3fs_template);

		//FOR MIPAV preferences
		Properties prop = new Properties();
		InputStream inputStream = null;
		try {
			inputStream = new FileInputStream(doNotDeletepath + File.separator + "mipav.preferences");
		} catch (FileNotFoundException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		try {
			prop.load(inputStream);
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		try {
			prop.setProperty("PerformLaxCheck", "true");
			prop.setProperty("MaximumHeapSize", "1000");
			prop.setProperty("JIST_Library_Directory", "/home/ec2-user/jist-lib");
			prop.setProperty("LastXImages", "");
			prop.setProperty("ImageDirectory", "/home/ec2-user/");
			prop.setProperty("StartingHeapSize", "300");
			prop.setProperty("PluginInstallDirectory", "/home/ec2-user");
			prop.setProperty("fileTempDir", "/home/ec2-user/mipav/tempDir/");
			OutputStream output = new FileOutputStream(doNotDeletepath + File.separator + "mipav.preferences");
			try {
				prop.store(output, null);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//FOR JISTPREFERENCES
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer;
		String content = null;
		String tmpContent = null;
		try {
			transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,
					"yes");
			StringWriter writer = new StringWriter();

			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = null;
			try {
				builder = factory.newDocumentBuilder();
			} catch (ParserConfigurationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			Document doc = null;
			try {
				doc = builder.parse(doNotDeletepath + File.separator +"JistUserPreferences.xml");
			} catch (SAXException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			try {
				transformer.transform(new DOMSource(doc), new StreamResult(
						writer));
			} catch (TransformerException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			content = writer.getBuffer().toString();
			tmpContent = content;
			//System.out.println(content);
		} catch (TransformerConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// NEWLY ADDED
		// content = new String(Files.readAllBytes(srcpath), charset);

		if (content.contains("<jre>")) {

			String[] tagsFile = StringUtils.substringsBetween(content,
					"<jre>", "</jre>");
			content = StringUtils.replace(content, tagsFile[0],
					"/home/ec2-user/mipav/jre/bin/java");
		}
		
		if (content.contains("defaultMemory")){
			String[] tagsFile = StringUtils.substringsBetween(content,
					"<defaultMemory>", "</defaultMemory>");
			content = StringUtils.replace(content, tagsFile[0],
					"1000");
		}
		
		if (!content.equals(tmpContent)) {
			FileWriter out;
			try {
				out = new FileWriter(doNotDeletepath + File.separator +"JistUserPreferences.xml");
				out.write(content);
				out.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}
		
		return true;
		
	}
}
