package edu.vanderbilt.masi.jistcloud;

/**
 * @description Add server-side functionality for JIST
 * @author: Wei Xie <wei.xie@vanderbilt.edu>
 */

import java.io.File;

import javax.swing.WindowConstants;

import edu.jhu.ece.iacl.jist.io.MipavController;
import edu.jhu.ece.iacl.jist.pipeline.JistPreferences;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout;
import edu.jhu.ece.iacl.jist.pipeline.PipeLibrary;
import edu.jhu.ece.iacl.jist.pipeline.PipeScheduler;
import edu.jhu.ece.iacl.jist.pipeline.gui.PipelineLayoutTool;
import edu.jhu.ece.iacl.jist.pipeline.gui.ProcessManager;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class JistServer {
	/**
	 * Exit GUI program completely
	 * NOTE: we'll discard all unsaved changes in layouts (no server-side edit anyway)
	 * @param tool PipelineLayoutTool object
	 */
	public static void exitProgram(PipelineLayoutTool tool) {	
		JistPreferences.savePreferences();
		tool.setVisible(false);
		
		if (tool.getDefaultCloseOperation() == WindowConstants.DISPOSE_ON_CLOSE) {
			System.exit(0);
		}
	}
	
	/**
	 * Run the given layout
	 * @param layoutPath Full path to layout
	 * @param debugMode set to false to avoid running Process Manager (for dev/test only)
	 * @return true if run succeeded; otherwise return false
	 */
	public static boolean runLayout(String layoutPath, boolean debugMode) {
		 System.out.println(1); 
		MipavController.setQuiet(true);
        MipavController.init();
        PipeLibrary.getInstance().loadPreferences();
        
        PipelineLayoutTool tool = PipelineLayoutTool.getInstance();
        tool.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        
       
        PipeLayout layout = PipeLayout.read(new File(layoutPath));
        System.out.println(2); 
        if (layout.getFileLocation() != null) {
        	tool.load(layout);
        	JistLogger.logOutput(JistLogger.INFO, "Layout loaded: " + layout.getFileLocation().getAbsolutePath());
        	 System.out.println(3); 
        	// Only run jobs when not in DEBUG mode
        	if (! debugMode) {
	        	ProcessManager pm = ProcessManager.getInstance();
	        	pm.load(layout);
	        	pm.setVisible(true);
	        	 System.out.println(4); 
	        	try {
	        		// It's unclear why this wait is necessary. Removing it will cause errors
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
	        	
	        	PipeScheduler scheduler = pm.getCurrentScheduler();
	        	if (scheduler != null) {
	        		scheduler.enqueue();
	        		if (!scheduler.isRunning()) {
	        			scheduler.start();
	        			 System.out.println(5); 
	        		}
	        	}
	        	
	        	while (!scheduler.isCompleted()) {
	        		try {
						Thread.sleep(500);
						 System.out.println(6); 
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
	        	}
	        	 System.out.println(7); 
	        	JistLogger.logOutput(JistLogger.INFO, "");
	        	scheduler.stop();
	        	
	        	exitProgram(tool);
        	}
	        
	        return true;
        }
        
        return false;
	}
	
	/**
	 * Test run layout
	 * @param args Array[layout path]
	 */
	public static void main(String[] args) {
        if (args.length < 1) {
            JistLogger.logError(JistLogger.SEVERE, "> Need to specify layout path.");
            System.exit(1);
        }
        
        boolean debugMode = false;
        if (args.length > 1) {
        	debugMode = args[1].equals("DEBUG");
        }
        
        runLayout(args[0], debugMode);
	}
}
