package edu.vanderbilt.masi.jistcloud;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import edu.jhu.ece.iacl.jist.pipeline.PipeLayout;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

/**
 * Helper methods for JIST cloud
 * @author Bo Li, Wei Xie
 *
 */
public class MyUtils {
	static Properties props;
	static FileInputStream fileInputStream;
	
	/**
	 * Decompress zip package to specified folder
	 * Note: if you have test.zip whose root directory is test_inside/
	 * and you specify /blabla as your target directory for extraction,
	 * then result will be: /blabla/test_inside
	 * @param zipFile path to zip file
	 */
	static public void extractFolder(String zipFile, String targetFolder) throws ZipException, IOException 
	{
	    JistLogger.logOutput(JistLogger.INFO, ">> To extract: " + zipFile);
	    int BUFFER = 2048;
	    File file = new File(zipFile);
	    ZipFile zip = new ZipFile(file);
	    
	    String newPath = targetFolder;  //zipFile.substring(0, zipFile.length() - 4);
	    File projectFolder = new File(newPath);
	    
	    if (! projectFolder.exists()) {
	    	projectFolder.mkdir();
	    }
	    
	    Enumeration zipFileEntries = zip.entries();

	    // Process each entry
	    while (zipFileEntries.hasMoreElements())
	    {
	        // grab a zip file entry
	        ZipEntry entry = (ZipEntry) zipFileEntries.nextElement();
	        String currentEntry = entry.getName();
	        File destFile = new File(newPath, currentEntry);
	        //destFile = new File(newPath, destFile.getName());
	        File destinationParent = destFile.getParentFile();

	        // create the parent directory structure if needed
	        destinationParent.mkdirs();

	        if (!entry.isDirectory()) {
	            BufferedInputStream is = new BufferedInputStream(zip
	            .getInputStream(entry));
	            int currentByte;
	            // establish buffer for writing file
	            byte data[] = new byte[BUFFER];

	            // write the current file to disk
	            FileOutputStream fos = new FileOutputStream(destFile);
	            BufferedOutputStream dest = new BufferedOutputStream(fos,
	            BUFFER);

	            // read and write until last byte is encountered
	            while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
	                dest.write(data, 0, currentByte);
	            }
	            
	            dest.flush();
	            dest.close();
	            is.close();
	            
	        } else {
	            destFile.mkdirs();
	        }
	        
	        // we don't support zip inside zip at the moment
	        //if (currentEntry.endsWith(".zip")) {
	            // found a zip file, try to open
	        //    extractFolder(destFile.getAbsolutePath());
	        //}
	    }
	}
	
	// Deprecated
	public static void loadProperty(String experimentFolder) {
		props = new Properties();
		
		try {
			fileInputStream = new FileInputStream(new File(experimentFolder, ".jistcloud.properties"));
			props.load(fileInputStream);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	
	// Deprecated
	public static String getProperty(String propertyName) {
		if (props != null) {
			return props.getProperty(propertyName);
		} else {
			return "";
		}
	}
	
	// Deprecated
	public static void closeProperty() {
		if (fileInputStream != null) {
			try {
				fileInputStream.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * Get path to .properties file for current experiment
	 * @param layoutPath path to layout (at root level of experiment)
	 * @return path to .properties
	 */
	public static String getPropertiesPath(String layoutPath) {
		return new File( new File(layoutPath).getParent(), ".jistcloud.properties" ).toString();
	}

	/**
	 * Get path to experiment .properties file
	 * @param layout layout object of current experiment
	 * @return path to .properties file
	 */
	public static String getPropertiesPath(PipeLayout layout) {
		return getPropertiesPath(layout.getFileLocation().getAbsolutePath());
	}
	
	/**
	 * Create .properties file for current experiment if necessary
	 * @param propertiesPath path to expected .properties file
	 */
	public static void preparePropertiesFile(String propertiesPath) {
		File propertiesFile = new File(propertiesPath);

		if (! propertiesFile.exists()) {
			try {
				propertiesFile.createNewFile();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	public static int getIntegerFromProperties(PipeLayout layout, String propertiesKey) {
		int result = -1;
		File propertiesPath = new File(getPropertiesPath(layout));
		
		if (! propertiesPath.exists()) {
			return result;
		}
		
		Properties prop = new Properties();
		FileInputStream fis = null;
		
		try {
			fis = new FileInputStream(propertiesPath);
			prop.load(fis);
			if (prop.getProperty("use_cloud") != null && prop.getProperty("use_cloud").equals("true") && 
					prop.getProperty(propertiesKey) != null) {
				result = Integer.parseInt(prop.getProperty(propertiesKey));
			}
			
		} catch (Exception ex) {
			ex.printStackTrace();
			
		} finally {
			try {
				fis.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		
		return result;
	}
	
	//
	public static List<File> arraylistFile = new ArrayList<File>();
	public static List<File> updatePathAndSendToS3(File node){
		 
		if((node.getName().contains(".output"))||(node.getName().contains(".input"))){
			if(node.getName().contains(".LayoutXML"))
				System.out.println("haoyuna");
			arraylistFile.add(node);
		}
 
		if(node.isDirectory()){
			String[] subNote = node.list();
			for(String filename : subNote){
				updatePathAndSendToS3(new File(node, filename));
			}
		}
		return arraylistFile;
 
	}
	
	public static void main(String[] args)
	{
	    if (args.length < 2) {
	      JistLogger.logError(JistLogger.SEVERE, "ERROR: need to specify zip path and target directory.");
	      return;
	    }
	    
	    try {
	    	extractFolder(args[0], args[1]);
	    	JistLogger.logOutput(JistLogger.INFO, "Finished.");
	   
	    } catch (IOException ioe) {
	    	JistLogger.logError(JistLogger.SEVERE, "There is an IOException Occured :" + ioe);
			ioe.printStackTrace();
			return;
	    }
	}
}
