package edu.vanderbilt.masi.xnatJist;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class XnatLoginPanel extends JPanel implements ActionListener {
	
	public static final Dimension defaultLabelDimension = new Dimension(150, 20);
	public static boolean loggedInStatus;
	public static String jsessionID;
	public static String host;
	public static String username;
	
	private JFrame xnatFrame;
	private JPanel fieldPane, buttonPane, invalidLoginPane;
	
	private JTextField hostField, usernameField;
	private JPasswordField passwordField;

	private JButton loginButton, logoutButton;

	private JLabel invalidLabel;
	
	private XnatMain xnat;
	
	public XnatLoginPanel() {
		
	}

	public void init() {
		if (loggedInStatus) {
			
			fieldPane.setVisible(false);
			buttonPane.setVisible(false);
			invalidLoginPane.setVisible(false);
			xnatFrame.setVisible(false);
			
			xnatFrame = new JFrame("Xnat Logout");
			fieldPane = new JPanel(new BorderLayout());
			buttonPane = new JPanel(new BorderLayout());
			
			logoutButton = new JButton("Logout");
			logoutButton.addActionListener(this);
			
			fieldPane.add(new JLabel("You are logged in."));
			
			buttonPane.add(logoutButton);
			
			xnatFrame.add(fieldPane, BorderLayout.NORTH);
			xnatFrame.add(buttonPane, BorderLayout.SOUTH);
			
			Dimension d = new Dimension(200 , 150);
            xnatFrame.setMinimumSize(d);
			xnatFrame.setVisible(true);
			
			fieldPane.setVisible(true);
			buttonPane.setVisible(true);
			
			
		} else {
			
			xnatFrame = new JFrame("Xnat Login");
			
			fieldPane = new JPanel(new BorderLayout());
			buttonPane = new JPanel(new BorderLayout());
			invalidLoginPane = new JPanel(new BorderLayout());
			
			JPanel hostPane = new JPanel(new BorderLayout());
			JPanel usernamePane = new JPanel(new BorderLayout());
			JPanel passwordPane = new JPanel(new BorderLayout());
			
			JLabel labelHost = new JLabel("Host");
			labelHost.setMaximumSize(defaultLabelDimension);
			hostField = new JTextField(20);
			hostField.setText("http://www.vandyxnat.org/xnat/");
			
			JLabel labelUsername = new JLabel("Username");
			labelUsername.setMaximumSize(defaultLabelDimension);
			usernameField = new JTextField(20);
			
			JLabel labelPassword = new JLabel("Password");
			labelPassword.setMaximumSize(defaultLabelDimension);
			passwordField = new JPasswordField(20);
			passwordField.getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),"enter_pressed");
			passwordField.getActionMap().put("enter_pressed", new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					loginButton.doClick();
					}
				});
			
			hostPane.add(labelHost, BorderLayout.WEST);
			hostPane.add(hostField, BorderLayout.EAST);
			usernamePane.add(labelUsername, BorderLayout.WEST);
			usernamePane.add(usernameField, BorderLayout.EAST);
			passwordPane.add(labelPassword, BorderLayout.WEST);
			passwordPane.add(passwordField, BorderLayout.EAST);
			
			fieldPane.add(hostPane, BorderLayout.NORTH);
			fieldPane.add(usernamePane, BorderLayout.CENTER);
			fieldPane.add(passwordPane, BorderLayout.SOUTH);
			
			loginButton = new JButton("Login");
			loginButton.addActionListener(this);
			
			invalidLabel = new JLabel("Invalid credentials. Try again.");
			invalidLabel.setMaximumSize(defaultLabelDimension);
			
			invalidLoginPane.add(invalidLabel, BorderLayout.NORTH);
			
			buttonPane.add(loginButton, BorderLayout.NORTH);
			
			
			xnatFrame.add(invalidLoginPane, BorderLayout.NORTH);
			xnatFrame.add(fieldPane, BorderLayout.CENTER);
			xnatFrame.add(buttonPane, BorderLayout.SOUTH);
			
			
			invalidLoginPane.setVisible(false);
			//Display the window.
			xnatFrame.pack();
			xnatFrame.setVisible(true);
		}
        
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		// TODO Auto-generated method stub
		if (event.getSource() == loginButton) {
			
			host = hostField.getText();
			username = usernameField.getText();
			String password = new String(passwordField.getPassword());
			
			
			xnat = new XnatMain(host, username, password);
			try {
				try {
					this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
					xnat.login();
				} finally {
					this.setCursor(Cursor.getDefaultCursor());
				}
				jsessionID = xnat.getJSessionID();
				loggedInStatus = true;
				init();
				
			} catch(IOException e) {
				invalidLoginPane.setVisible(true);
				xnatFrame.pack();
			}
			
		} else if (event.getSource() == logoutButton) {
			try {
				
				xnat.logout();
				loggedInStatus = false;
				jsessionID = null;
				host = null;
				username = null;
				
				fieldPane.setVisible(false);
				buttonPane.setVisible(false);
				xnatFrame.setVisible(false);
				
				init();
			} catch(IOException e) {
				
			}
		}
		
	}
	
	public XnatMain getXnatObj() {
		return this.xnat;
	}
	
	

}
