package edu.vanderbilt.masi.xnatJist;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dialog.ModalityType;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;

import edu.jhu.ece.iacl.jist.pipeline.JistPreferences;
import edu.jhu.ece.iacl.jist.pipeline.PipeLayout;
import edu.jhu.ece.iacl.jist.pipeline.gui.LayoutPanel;

public class XnatSearchGUI {
	static JFrame frame;
	static ArrayList<ArrayList<String>> results = new ArrayList<ArrayList<String>>();
	static ArrayList<ArrayList<String>> selectedResults = new ArrayList<ArrayList<String>>();
	static ArrayList<String> projResults = new ArrayList<String>();
	private static DefaultListModel listBoxEntries;
	private static ArrayList<String> fileNames;
	private static String timeID;
	
	
	public static String getProject() {
		frame = new JFrame("Search Project");
		String project  = null;
		String s = "";
				
		s = (String)JOptionPane.showInputDialog(frame, "Search for project IDs\n"
					+ "(leave blank to get all)", "Search Project", JOptionPane.PLAIN_MESSAGE);
		
		
		project = selectProject(s);
		
		
		return project;
	}

	private static String selectProject(final String s) {
		frame = new JFrame("Select Project");
		final String jsessionID = XnatLoginPanel.jsessionID;
		final String host = XnatLoginPanel.host;
		String proj = null;
		
		
		projResults.clear();
		
		SwingWorker<Void, Void> mySwingWorker = new SwingWorker<Void, Void>(){
	         @Override
	         protected Void doInBackground() throws Exception {
	        	 try {
	 				projResults = XnatMain.searchProjects(s, jsessionID, host);
	 				
	 				
	 			} catch (IOException e) {
	 				// TODO Auto-generated catch block
	 				e.printStackTrace();
	 			}
	        	 
	        	return null;
	         }
	      };

	      Window win = SwingUtilities.getWindowAncestor(frame);
	      final JDialog dialog = new JDialog(win, "Dialog", ModalityType.APPLICATION_MODAL);

	      mySwingWorker.addPropertyChangeListener(new PropertyChangeListener() {

	         public void propertyChange(PropertyChangeEvent evt) {
	            if (evt.getPropertyName().equals("state")) {
	               if (evt.getNewValue() == SwingWorker.StateValue.DONE) {
	                  dialog.dispose();
	               }
	            }
	         }
	      });
	      mySwingWorker.execute();

	      JProgressBar progressBar = new JProgressBar();
	      progressBar.setIndeterminate(true);
	      JPanel panel = new JPanel(new BorderLayout());
	      panel.add(progressBar, BorderLayout.CENTER);
	      panel.add(new JLabel("Please wait......."), BorderLayout.PAGE_START);
	      dialog.add(panel);
	      dialog.pack();
	      dialog.setLocationRelativeTo(win);
	      dialog.setVisible(true);
		
		
						
		
		Object[] possibilities = new Object[projResults.size()];
		
		for(int i=0; i< projResults.size(); i++) {
			possibilities[i] = projResults.get(i);
			
		}
		String firstProj = (String) possibilities[0];
		
		
		proj = (String)JOptionPane.showInputDialog(frame, "Select project ID", "Select Project",
					JOptionPane.PLAIN_MESSAGE, null, possibilities, firstProj);
		
		
		return proj;
	}
	
	public static XnatSearchObject getSelectedResults(final String project) {
		
		
		
		frame = new JFrame("Search");
		JPanel mainPane = new JPanel();
		
		JPanel searchPane1 = new JPanel(new BorderLayout());
		JPanel searchPane2 = new JPanel(new BorderLayout());
		
		JPanel subjectPane = new JPanel(new BorderLayout());
		JPanel experimentPane = new JPanel(new BorderLayout());
		JPanel scanPane = new JPanel(new BorderLayout());
		JPanel resourcePane = new JPanel(new BorderLayout());
		
		final JTextField subjectField = new JTextField(20);
		subjectPane.add(new JLabel("Subject ID:"), BorderLayout.WEST);
		subjectPane.add(subjectField, BorderLayout.EAST);
		
		final JTextField experimentField = new JTextField(20);
		experimentPane.add(new JLabel("Experiment ID:"), BorderLayout.WEST);
		experimentPane.add(experimentField, BorderLayout.EAST);
		
		final JTextField scanField = new JTextField(20);
		scanPane.add(new JLabel("Scan ID:"), BorderLayout.WEST);
		scanPane.add(scanField, BorderLayout.EAST);
		
		final JTextField resourceField = new JTextField(20);
		resourcePane.add(new JLabel("Resource ID:"), BorderLayout.WEST);
		resourcePane.add(resourceField, BorderLayout.EAST);
		
		searchPane1.add(subjectPane, BorderLayout.NORTH);
		searchPane1.add(experimentPane, BorderLayout.SOUTH);
		
		searchPane2.add(scanPane, BorderLayout.NORTH);
		searchPane2.add(resourcePane, BorderLayout.SOUTH);
		
		mainPane.add(searchPane1, BorderLayout.NORTH);
		mainPane.add(searchPane2, BorderLayout.SOUTH);
		
		int response = JOptionPane.showConfirmDialog(frame, mainPane, 
	               "Search for respective IDs \n" + "Leave any field blank to get all",
	               JOptionPane.OK_CANCEL_OPTION);
		
		if(response == JOptionPane.OK_OPTION) {
			
			SwingWorker<Void, Void> mySwingWorker = new SwingWorker<Void, Void>(){
		         @Override
		         protected Void doInBackground() throws Exception {
		        	String subj=null;
		     		String exp=null;
		     		String scan=null;
		     		String res=null; 	
		        	subj = subjectField.getText();
					exp = experimentField.getText();
					scan = scanField.getText();
					res = resourceField.getText();
					searchResults(project, subj, exp, scan, res);
		        	return null;
		         }
		      };

		      Window win = SwingUtilities.getWindowAncestor(frame);
		      final JDialog dialog = new JDialog(win, "Dialog", ModalityType.APPLICATION_MODAL);

		      mySwingWorker.addPropertyChangeListener(new PropertyChangeListener() {

		         public void propertyChange(PropertyChangeEvent evt) {
		            if (evt.getPropertyName().equals("state")) {
		               if (evt.getNewValue() == SwingWorker.StateValue.DONE) {
		                  dialog.dispose();
		               }
		            }
		         }
		      });
		      mySwingWorker.execute();

		      JProgressBar progressBar = new JProgressBar();
		      progressBar.setIndeterminate(true);
		      JPanel panel = new JPanel(new BorderLayout());
		      panel.add(progressBar, BorderLayout.CENTER);
		      panel.add(new JLabel("Please wait......."), BorderLayout.PAGE_START);
		      dialog.add(panel);
		      dialog.pack();
		      dialog.setLocationRelativeTo(win);
		      dialog.setVisible(true);
		   
				
				
			selectResults();
				
				
			
			
		}
		
		XnatSearchObject obj = new XnatSearchObject();
		//obj.time = timeID;
		obj.selectedResults = selectedResults;
		System.out.println("inside xnat search gui, selected results size-" + obj.selectedResults.size());
		return obj;
		
	}

	private static void selectResults() {
		frame = new JFrame("Select Results");
		String[] col = {"Subjects", "Experiments", "Scans", "Resources"};
		DefaultTableModel tableModel = new DefaultTableModel(col, 0);
		for(ArrayList<String> row : results) {
			String s = row.get(0);
			String e = row.get(1);
			String sc = row.get(2);
			String rs = row.get(3);
			Object[] obj = {s, e, sc, rs};
			tableModel.addRow(obj);
		}
		
		JTable searchTable = new JTable(tableModel);
		searchTable.setAutoCreateRowSorter(true);
		
		ListSelectionModel selectionModel = searchTable.getSelectionModel();
		selectionModel.setSelectionInterval(0, 0);
		searchTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
		JScrollPane tableScrollPane = new JScrollPane(searchTable);
		Object[] options = {"Select & Download", "Select All & Download", "Cancel"};
		int response = JOptionPane.showOptionDialog(frame, tableScrollPane, 
	               "Select results to be downloaded", JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE,
	               null, options, null);
		
		selectedResults.clear();
		if(response == 0) {
			int[] rows = searchTable.getSelectedRows();
						
			for(int row : rows) {
				
				ArrayList<String> result = new ArrayList<String>();
				result.clear();
				result.add((String) searchTable.getValueAt(row, 0));
				result.add((String) searchTable.getValueAt(row, 1));
				result.add((String) searchTable.getValueAt(row, 2));
				result.add((String) searchTable.getValueAt(row, 3));
				boolean exists = false;
				for(ArrayList<String> temp : selectedResults) {
					if(equals(result, temp)) {
						exists = true;
					}
				}
				if(exists == false) {
					selectedResults.add(result);
				}
			}
		} else if(response == 1) {
			int rowCount = searchTable.getRowCount();
					
			for(int row = 0; row < rowCount; row++) {
				
				ArrayList<String> result = new ArrayList<String>();
				result.clear();
				
				result.add((String) searchTable.getValueAt(row, 0));
				result.add((String) searchTable.getValueAt(row, 1));
				result.add((String) searchTable.getValueAt(row, 2));
				result.add((String) searchTable.getValueAt(row, 3));
				
				boolean exists = false;
				for(ArrayList<String> temp : selectedResults) {
					if(equals(result, temp)) {
						exists = true;
					}
				}
				if(exists == false) {
					selectedResults.add(result);
				}
			}
		}
		
		
	}

	private static boolean equals(ArrayList<String> result,
			ArrayList<String> temp) {
		boolean equal = true;
		
		for(int i=0; i<result.size(); i++) {
			if(result.get(i) != temp.get(i)) {
				equal = false;
			}
		}
		return equal;
	}

	private static void searchResults(String project,
			String subj, String exp, String scan, String res) {
		
		
		String jsessionID = XnatLoginPanel.jsessionID;
		String host = XnatLoginPanel.host;
		
		results.clear();
		
		try {
			frame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				results = XnatMain.search(subj, exp, scan, res, project, jsessionID, host);
				
			} catch (IOException e) {
				
				e.printStackTrace();
			}
		} finally {
			frame.setCursor(Cursor.getDefaultCursor());
		}
		
		
	}

	public static File[] download(final ArrayList<ArrayList<String>> selectedResults, final String project) {
		
		listBoxEntries = new DefaultListModel();
		listBoxEntries.removeAllElements();
		
		fileNames = new ArrayList<String>();
		fileNames.clear();
		
		
		
		SwingWorker<Void, Void> mySwingWorker = new SwingWorker<Void, Void>(){
	         @Override
	         protected Void doInBackground() throws Exception {
	        	 
	        	 for (ArrayList<String> row : selectedResults) {
	     			
	     			String s = row.get(0);
	     			
	     			String e = row.get(1);
	     			String sc = row.get(2);
	     			String rs = row.get(3);
	     			String jsessionID = XnatLoginPanel.jsessionID;
	     			String host = XnatLoginPanel.host;
	     			ArrayList<String> filename = new ArrayList<String>();
	     			filename.clear();
	     			//String filePath = null;
	     			
	     			try {
	     				filename = XnatMain.download(s, e, sc, rs, project, jsessionID, host);
	     				
	     				
	     			} catch (IOException e1) {
	     				
	     			}
	     			
	     			//PipeLayout layout = LayoutPanel.getInstance().getPipelineLayout();
	     			//File f = layout.getRunParameters().getOutputDirectory();
	     			File f = JistPreferences.getPreferences().getLastLayoutDirectory();
	     			String directory = f.getAbsolutePath();
	     		
	     			for(String str : filename) {
	     				findFile(str, new File(directory));
	     			
	     			}
	     		}
	     			
	     			
	        	 
	        	return null;
	         }
	      };

	      Window win = SwingUtilities.getWindowAncestor(frame);
	      final JDialog dialog = new JDialog(win, "Dialog", ModalityType.APPLICATION_MODAL);

	      mySwingWorker.addPropertyChangeListener(new PropertyChangeListener() {

	         public void propertyChange(PropertyChangeEvent evt) {
	            if (evt.getPropertyName().equals("state")) {
	               if (evt.getNewValue() == SwingWorker.StateValue.DONE) {
	                  dialog.dispose();
	               }
	            }
	         }
	      });
	      mySwingWorker.execute();

	      JProgressBar progressBar = new JProgressBar();
	      progressBar.setIndeterminate(true);
	      JPanel panel = new JPanel(new BorderLayout());
	      panel.add(progressBar, BorderLayout.CENTER);
	      panel.add(new JLabel("Please wait......."), BorderLayout.PAGE_START);
	      dialog.add(panel);
	      dialog.pack();
	      dialog.setLocationRelativeTo(win);
	      dialog.setVisible(true);
		
	      File[] files = new File[listBoxEntries.size()];
			
			for(int i=0; i< listBoxEntries.getSize(); i++) {
				files[i] = (File) listBoxEntries.get(i);
				
				//System.out.println(files[i].getAbsolutePath());
			} 
		
			
			//System.out.println("Transferring listBoxEntries to files");
			/*for(int i=0; i<listBoxEntries.getSize(); i++) {
				files[i] = (File) listBoxEntries.get(i);
			}
			if(files == null) {
				System.out.println("files=null");
			}
			wait = true;
			*/
			
		
		return files;
	}

	private static void findFile(String filename, File f) {
		File[] list = f.listFiles();
		
		for (File fil : list) {
			
				if (fil.isDirectory()) {
					findFile(filename, fil);
				} else {
					if(filename.contains(fil.getName()) || fil.getName().contains(filename)) {
						
						
						//return fil.getParent();
						String fullFileName = fil.getParent() + File.separator + filename;
						File fullName = new File(fullFileName);
						boolean exists = false;
						for (int i = 0; i < fileNames.size(); i++) {
							String temp = fileNames.get(i);
							if(temp.equals(filename)) {
								exists = true;
							}
						}
						if (!exists) {
							fileNames.add(filename);
							listBoxEntries.addElement(fullName);
							//System.out.println("xnat list box size-" + listBoxEntries.getSize());
						}
						
					}
				}
			
		}
		
	}
}
