/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: A singleton used to hold the appropriate data for JIST tests
 * 	that test if a module actually created the files it was supposed to.
 */
package JIST_test;

import java.util.LinkedList;

public class FileExistenceSingleton {

	private static FileExistenceSingleton instance = null;
	
	// add private static Vectors here
	
	private static LinkedList<String> directory;
	private static LinkedList<Double> val;

	protected FileExistenceSingleton () {
		// we wouldn't want anyone touching this now would we
	}

	public static FileExistenceSingleton getInstance () {
		if (instance == null) {
			// initialize vectors here
			directory   = new LinkedList<String>();
			val 		= new LinkedList<Double>();
			instance 	= new FileExistenceSingleton();
		}

		return instance;
	}

	public void set_data (String dir, double v) {
		directory.offer(dir);
		val.offer(v);
	}

	// get methods	
	public String get_directory () {
		return directory.poll();
	}

	public Double get_val () {
		return val.poll();
	}

}
