/*
 * Author: Elliot Hall <elliot.t.hall@vanderbilt.edu>
 * Description: A class for comparing Surfaces.
 */

package JIST_test;

import java.io.*;
import java.util.*;

import java.util.concurrent.Executors;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ExecutorCompletionService;

import org.junit.Test;
import junit.framework.TestCase;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;

public class SurfaceCompareTest extends TestCase {

	private TestcaseStrings tcs;
	private String directory, datadir, userdir, jredir, classpath, extdirs;

	public SurfaceCompareTest (String name) {
		super(name);
	}

	// If you want a more specific test, ie "testThisModuleName", and it's a
	// 	Surface comparison, then all you need to do is add that test and call
	// 	this private method. It's all the same stuff under the hood, but this
	// 	makes it easier to differentiate specific tests.
	
	private Boolean test_surface () {
		
		SurfaceCompareSingleton scs = SurfaceCompareSingleton.getInstance();

		datadir 	= scs.get_datadir();
		directory 	= scs.get_directory().replace("{datadir}", datadir);
		userdir 	= scs.get_userdir();
		jredir 		= scs.get_jredir();
		classpath 	= scs.get_classpath();
		extdirs     = scs.get_extdirs();
		tcs 		= scs.get_tcs();

		/*
		 * 1)  Find out where surfaces are located. 
		 * 2)  Convert both surfaces to Volumes
		 * 3)  Compare both Volumes.
		 *
		 * If most of the following looks familiar, it's because most of it has
		 * 	already been done somewhere else.
		 */

		System.out.println("\tSurface Compare - Provided Data:");
		System.out.println("ed_file: " + tcs.ed_file);
		System.out.println("directory: " + directory);

		File ed_dir = null, ad_dir = null;

		try {
			ed_dir = new File(directory + "convert_ed");
			ad_dir = new File(directory + "convert_ad");
			ed_dir.mkdir();
			ad_dir.mkdir();
		} catch (Exception e) {
			// haha that's so helpful
			System.err.println("\n\n\tfuck you");
		}

		String convert_ed = (jredir + " -Xmx512m -classpath " + classpath 
				+ " -Djava.ext.dirs=" + extdirs
				+ " edu.jhu.ece.iacl.jist.cli.run " 
				+ " edu.jhu.ece.iacl.plugins.utilities.surface.MedicAlgorithmSurfaceToVolumeConverter "
				+ " -inSurface " + tcs.ed_file.replace("{datadir}", datadir)
				+ " -inTemplate " + tcs.template_volume.replace("{datadir}", datadir)
				+ " -xDir " + directory + "convert_ed/").replace(";",":");

		Vector<File> surf_files = 
			new Vector<File>(Arrays.asList((new File(directory)).listFiles()));

		String ad_name = new String ();

		for (File f : surf_files) {
			if (f.getName().endsWith(tcs.surface_extension)) {
				ad_name = f.getAbsolutePath();
				break;
			}
		}

		String convert_ad = (jredir + " -Xmx512m  -classpath " + classpath
				+ " -Djava.ext.dirs=" + extdirs
				+ " edu.jhu.ece.iacl.jist.cli.run " 
				+ " edu.jhu.ece.iacl.plugins.utilities.surface.MedicAlgorithmSurfaceToVolumeConverter "
				+ " -inSurface " + ad_name
				+ " -inTemplate " + tcs.template_volume.replace("{datadir}", datadir)
				+ " -xDir " + directory + "convert_ad/").replace(";",":");

		if (tcs.debug_print) {
			System.out.println("\n\nconvert_ed: " + convert_ed);
			System.out.println("\n\nconvert_ad: " + convert_ad);
		}

		MipavCommand mc_ed = new MipavCommand(convert_ed, 
											  "convert_ed.jtest", 
											  true, 
											  userdir);

		MipavCommand mc_ad = new MipavCommand(convert_ad, 
											  "convert_ad.jtest", 
											  true, 
											  userdir);

		// run them both
		ExecutorService 			es  = Executors.newFixedThreadPool(2);
		CompletionService<Object> 	cs  = new ExecutorCompletionService<Object>(es);

		cs.submit(mc_ed);
		cs.submit(mc_ad);

		for (int i = 0; i < 2; ++i) {
			Object x;
			try {
				x = cs.take().get();
				System.out.println(x.toString() + " finished");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		/*
		 * The files we would like to compare are located in 
		 * 	{directory}/convert_ad and {directory}/convert_ed.
		 */

		File ad_volume = null, ed_volume = null;

		Vector<File> ad_files = 
			new Vector<File>(Arrays.asList((ad_dir).listFiles()));

		Vector<File> ed_files = 
			new Vector<File>(Arrays.asList((ed_dir).listFiles()));

		for (File f : ad_files) {
			if (f.getName().endsWith(".xml")) { // found our volume
				ad_volume = f;
				break;
			}
		}

		for (File f : ed_files) {
			if (f.getName().endsWith(".xml")) { // found our volume
				ed_volume = f;
				break;
			}
		}

		if (ad_volume == null)
			System.out.println("Converting reproduced Surface to Volume failed.");

		if (ed_volume == null)
			System.out.println("Converting given Surface to Volume failed.");

		if (ad_volume == null || ed_volume == null)
			return false;

		// NOW ALL WE HAVE TO DO IS JUST COMPARE THE FUCKING VOLUMES

		ImageData act_data = 
			ImageDataReaderWriter.getInstance().read(ad_volume);							
		ImageData exp_data = 
			ImageDataReaderWriter.getInstance().read(ed_volume);
		
		TestHolder th = new TestHolder();

		TestOperatorBase tob = th.get_test(tcs.test_criteria_type.trim());
		
		tob.set_tv(tcs.test_value);

		System.out.println("COMPARISON CRITERIA: " + tob.get_name());

		Boolean test_result = tob.run(act_data, exp_data);

		return test_result;

	}

	public void testSurface () {

		Boolean res = test_surface();

		assert(res);

	}

}
