#!/bin/bash
# args 
#  1: Input - Absolute Path for Fixed Image (Target)
#  2: Input - Absolute Path for Moving Image (Subject)
#  3: Input - Number of Coarse Iterations
#  4: Input - Number of Medium Iterations
#  5: Input - Number of Fine Iterations
#  6: Input - Run Affine Step Before Registration
#  7: Input - Type of Cost Function 
#  8: Output - Absolute Path for Registration Result (Deform Subject)
#  9: Output - Absolute Path for Deformation Field
#  10: Output - Absolute Path for Inverse Deformation Field 
#  11: Output - Absolute Path for Affine Matrix File

fixed="$1"
moving="$2"
coarseItr="$3"
mediumItr="$4"
fineItr="$5"
affineFirst="$6"
costFunction="$7"
outResult="$8"
outDef="$9"
outInvDef="${10}"
outAff="${11}"

if [ "$affineFirst" == "true" ]
then
        offAffineTag=""
else
        offAffineTag="--number-of-affine-iterations 0"
fi


if [ "$costFunction" == "Cross Correlation" ]
then
        metricTag="CC[$fixed,$moving,1,5]"
elif [ "$costFunction" == "Mutual Information" ]
then
        metricTag="MI[$fixed,$moving,1,64]"
fi

#Calls ANT and then transform moving (subject) image using deformation field
ANTS 3 -m $metricTag -o $outResult -i $coarseItr"x"$mediumItr"x"$fineItr -r Gauss[3,1] -t SyN[.25] $offAffineTag
WarpImageMultiTransform 3 $moving $outResult -R $fixed $outDef $outAff
