function mCorr=meanCorr(x,y)
% x and y are nvox * nfreq matrix
    nfreq = size(x,2);
    tempcorr = zeros(nfreq,1);
    % compute correlation for each frequency point
    for i = 1:nfreq
%         tempcorr(i)=corr(x(:,i),y(:,i));
%         sx = sort(x(:,i));
%         sy = sort(y(:,i));
        if size(x,1) == size(y,1)
            tempcorr(i) = corr(x(:,i),y(:,i));
        else
            tmpcrosscorr = xcorr(x(:,i)-mean(x(:,i)),y(:,i)-mean(y(:,i)));
%             tmpcrosscorr = xcorr(x(:,i)-mean(x(:,i)),y(:,i)-mean(y(:,i)),'coeff');
            [tempcross Ind]= max(abs(tmpcrosscorr));
            tempcorr(i) = tmpcrosscorr(Ind)/sqrt(max(xcorr(x)))/max(sqrt(xcorr(y)));
        end
    end
    tempcorr(isnan(tempcorr)) = []; 
    mCorr=mean(tempcorr);
end