function ssfmri_analysis(SSF) 
%--------------------------------------------------------------------------
%                                ssfmri 
%--------------------------------------------------------------------------  
%   Format: 
%   ssfmri(SSF) or ssfmri_analysis(SSF)
%--------------------------------------------------------------------------
%   Examples:
%    >> ssfmri; %-launches GUI  
%    >> ssfmri(SSF);
%    >> ssfmri_analysis(SSF);
%           
%--------------------------------------------------------------------------
%             ssfmri can be executed from the command line 
%   SSF structure:
%   SSF.result_dir  - the path and name of the directory where results will be
%                   stored.
%
%   SSF.type        - type of fMRI analysis
%                   'REST' : resting state fMRI
%                   'EVENT': task fMRI (may not work for this version yet)
%
%   SSF.imgname     - a cell array containing image names. each cell is the 
%                   full path and name of one scan image
%
%   SSF.RT          - fMRI repetition time
%
%   SSF.seed        - The seed file name. It stores the seed time course
%
%   SSF.titles      - a cell array of names assigned to the contrast
%
%   SSF.conf        - the file name of other confounds. One column
%                   represents one confound
%
%   SSF.ROI         - ROI structure
%                   ROI.Label   : The label image corresponding to fMRI
%                   ROI.LabelVal: The labeling intensity value of the ROIs we are
%                   interested in
%
%   SSF.band        - a cell array for frequency index. 
%                   e.g., SSF.band{1} = 2:99; (1 is the constant part index)
%
%   SSF.mask        - path and file name of the file containing the brain
%                   mask. set to '' if do not provide user defined mask
%
%   SSF.nband       - number of frequency bands
%
%   SSF.Dpattern    - optional. The priors for between ROI covariance
%                   estimation. It will be set to '' if no this field in input.
%
%   SSF.Type_STAT   - 'T', only t-test has been implemented for this version
%
%   SSF.test        - a cell array containing test structure. 
%                   SSF.test{i}.con    : contrast vector for coeffiecients
%                   SSF.test{i}.H0     : 'ONE' for one sided t-test or 'TWO'
%                   for two sided t-test
%                   SSF.test{i}.correct: multiple correction. only
%                   impelmented 'FDR' for this version
%                   SSF.test{i}.alpha  : the FDR threshold
%--------------------------------------------------------------------------

SCCSid = '1.4';
SPMid  = spm('SFnBanner','wfu_bpm toolbox','SCCSid');
warning('off')

if nargin < 1  
    %========== set parameters via GUI ==============================% 
    [SSF error H] = ssfmri_setup;
    if error > 0
        close(H)
        return
    end
    
    if ~spm_input('Run analysis now? ','+1','y/n',[1,0],1)
        spm_figure('clear','Interactive');
        fprintf('\tDone.'); 
        close(H)
        return
    end    
      
end

% ---- deleting the content of the result directory ----------%

cd(SSF.result_dir);
% delete('SSF.mat');

% -----execute----- %
[results,xband] = ssfmri_ancova(SSF); 
SSF.estResults = results;
SSF.X_band = xband;
display('analysis done');

% ---------- Calling the Contrast Manager in command line regime ----%
if nargin > 0 
    fname = fullfile(SSF.result_dir,'SSF');   
    save(fname, 'SSF');
    if isfield(SSF,'test')
        SSF = ssfmri_con_man(SSF);   
    end
    save(fname, 'SSF')      
else
    % ---------- Updating SSF ----------------------------%
    fname = fullfile(SSF.result_dir,'SSF');   
    save(fname, 'SSF');
    close(H)
    cd(SSF.result_dir);
end

return
