function [results,FX_band] = ssfmri_ancova(SSF)
%------------------------------------------------------------------------
%    This function performs the following tasks:
%
%       Load the data from the corresponding subjects files
%       and performs spatio-spectral analysis
%-------------------------------------------------------------------------
% Input parameters
% SSF 
%-------------------------------------------------------------------------
% Output parameters
% FX_band    - Forier coefficients of the design matrix
% results from the Spatio-Spectral Mixed Effects Model.
% beta_hat   - estimated beta for each ROI
% cov_b      - estimated within ROI covariance 
% cov_d      - estimated between ROI covariance
% fw         - estimated std for each band
% ROI_numVox - number of voxels in each ROI
% freq       - 

%--------------------------------------------------------------------------
  
% load the data and confound from the files
% data is a cell of arrays

% Reading other covariates
col_conf = SSF.conf; 
if ~isempty(col_conf)
    conf_time = load(col_conf);
else 
    conf_time = [];
end

num_img = length(SSF.imgname);
switch SSF.type    
    case{'EVENT'}
        hrf = spm_hrf(SSF.RT);
        num_event = length(SSF.event);
        X_time = zeros(num_img,num_event);

        for k = 1:num_event
            tmpevent = zeros(num_img,1);
            if length(SSF.event{k}.duration) > 1
                if (length(SSF.event{k}.onset) ~= length(SSF.event{k}.duration)) || (SSF.event{k}.onset(end)+SSF.event{k}.duration(end)-1 > num_img)
                    display('error stimulus design');
                    return;
                end
            end
            event_off = SSF.event{k}.onset + SSF.event{k}.duration - 1;
            for j = 1:length(SSF.event{k}.onset)
                tmpevent(SSF.event{k}.onset(j):event_off(j)) = 1;
            end
            eventhrf = conv(tmpevent, hrf); 
            eventhrf = eventhrf(1:num_img);
            X_time(:,k) = eventhrf;
        end
        
    case{'REST'}
        if isfield(SSF,'seed')
            X_time = load(SSF.seed);
%             X_time = X_time - mean(X_time);
        else
            imgstrs = spm_vol(SSF.imgname);
            X_time = zeros(num_img,1);
            seed_m = spm_vol(SSF.seedmask);
            seed_mimg = spm_read_vols(seed_m);
            for i = 1:num_img
                tempimg = spm_read_vols(imgstrs{i});
                X_time(i) = mean(tempimg(seed_mimg>0));
            end
%             X_time = X_time - mean(X_time);
        end 

        if isfield(SSF,'Dpattern') && ~isempty(SSF.Dpattern)
            pattern = load(SSF.Dpattern);
            pfield = fieldnames(pattern);
            d_pattern = getfield(pattern,pfield{1});
        else
            d_pattern = '';
        end
end

[Y_band, X_band, conf_band, bands_all,coord_rois,imgDim] = ssfmri_band(SSF.imgname, X_time, conf_time, SSF.band, SSF.ROI, SSF.mask);

switch SSF.type    
    case{'EVENT'}
        [beta_hat, Cov_b, Cov_d, Fw, numVoxROI] = ssfmri_est(X_band,Y_band,conf_band,bands_all,SSF.nbin,SSF.band,coord_rois);
        
    case{'REST'}
        [beta_hat, beta_conf, Cov_b, Cov_d, Fw, numVoxROI, F_freq] = ssfmri_est_rs(X_band,Y_band,conf_band,bands_all,SSF.nband,coord_rois,imgDim,d_pattern);
        results.beta_conf = beta_conf;
end

results.beta_hat = beta_hat;
results.cov_b = Cov_b;
results.cov_d = Cov_d;
results.fw = Fw;
results.ROI_numVox = numVoxROI;
results.freq = F_freq;
FX_band = [X_band conf_band];
spm_figure('Clear','Interactive');
return
