package edu.vanderbilt.masi.LabelFusion;

abstract class ObservationBase {

	// fields
	int [] dims;
	int num_labels, num_raters;
	
	// get_vote takes in coordinates and a rater and returns the associated label
	public abstract int [] get_vote(int x, int y, int z, int r);

	// iterate over all votes
	public abstract void iterate_votes(LabelFusionAction lfa);
	
	public abstract void iterate_region(LabelFusionAction lfa,
										int xs,
										int ys,
										int zs,
										int xe,
										int ye,
										int ze);
	
	public abstract void iterate_voxel(LabelFusionAction lfa,
									   int x,
									   int y,
									   int z);
	
}