package edu.vanderbilt.masi.LabelFusion;

// The DataVolume Class enforces the rule that all raters must label all voxels in the image.
// This class is optimized so that it will be fastest for STAPLE, COLLATE, Spatial STAPLE, etc ...
public class ObservationVolume extends ObservationBase {
	
	// fields
	private int [][][][] data;
	
	// DataVolume Constructor
	public ObservationVolume (int [][][][] data_in) {
		data = data_in;
		this.set_dims();
		this.set_num_raters();
		this.set_num_labels();
	}
	
	// set the dimensions
	private void set_dims() {
		super.dims = new int[3];
		super.dims[0] = data.length;
		super.dims[1] = data[0].length;
		super.dims[2] = data[0][0].length;
	}
	
	// set the number of raters
	private void set_num_raters() {
		super.num_raters = data[0][0][0].length;
	}
	
	private void set_num_labels() {
		int max_label_num = -1;
	    for (int x = 0; x < super.dims[0]; x++)
	        for (int y = 0; y < super.dims[1]; y++)
	            for (int z = 0; z < super.dims[2]; z++)
	                for (int r = 0; r < super.num_raters; r++)
	                    if (data[x][y][z][r] > max_label_num)
	                    	max_label_num = data[x][y][z][r];
	    super.num_labels = max_label_num + 1;
	}
	
	// get_vote takes in coordinates and a rater and returns the associated label
	public int [] get_vote(int x, int y, int z, int r) {
		int [] data_array = new int [1];
		data_array[0] = data[x][y][z][r];
		return(data_array);
	}
	
	public void iterate_votes(LabelFusionAction lfa) {
	    for (int x = 0; x < super.dims[0]; x++)
	        for (int y = 0; y < super.dims[1]; y++)
	            for (int z = 0; z < super.dims[2]; z++)
	                for (int r = 0; r < super.num_raters; r++)
	                    lfa.run(x, y, z, r, data[x][y][z][r]);
	}
	
	public void iterate_voxel(LabelFusionAction lfa,
							  int x,
							  int y,
							  int z) {
        for (int r = 0; r < super.num_raters; r++)
            lfa.run(x, y, z, r, data[x][y][z][r]);
	}
	
	public void iterate_region(LabelFusionAction lfa,
							   int xs,
							   int ys,
							   int zs,
							   int xe,
							   int ye,
							   int ze) {
	    for (int x = xs; x <= xe; x++)
	        for (int y = ys; y <= ye; y++)
	            for (int z = zs; z <= ze; z++)
	                for (int r = 0; r < super.num_raters; r++)
	                    lfa.run(x, y, z, r, data[x][y][z][r]);
	}
}