% An example simulation to test the COLLATE and STAPLE algorithms on a model
% that uses a boundary model of rater behavior

% simulation settings
num_raters = 15;
num_slices = 50;
num_labels = 5;
length_im = 100;
shiftiness = 2;

% algorithm settings
epsilon = 0.001;
prior_flag = 0;
init_flag = 0;
cons_flag = 0;
alphas = [0, 1e10];
cval = 0.95;

% set up the simulation
[obs truth] = consensus_simulation_boundary_model(num_raters, num_slices, ...
                                                  length_im, ...
                                                  shiftiness);

% run the algorithms
[STAPLE_estimate STAPLE_W STAPLE_theta] = STAPLE(obs, epsilon, ...
                                                 prior_flag, init_flag, ...
                                                 cons_flag);
[COLLATE_estimate COLLATE_W COLLATE_theta] = COLLATE(obs, epsilon, ...
                                                     prior_flag, init_flag, ...
                                                     alphas, cval);

% plot the results
figure(1);
subplot(2, 3, 1);
imagesc(truth(:, :, 1));
title('True Segmentation');
subplot(2, 3, 2);
imagesc(STAPLE_estimate(:, :, 1));
title('STAPLE Estimate');
subplot(2, 3, 3);
imagesc(COLLATE_estimate(:, :, 1));
title('COLLATE Estimate');
subplot(2, 3, 4);
imagesc(obs.data{1}(:, :, 1));
title('Example Best Observation');
subplot(2, 3, 5);
imagesc(obs.data{round(num_raters/2)}(:, :, 1));
title('Example Middle Observation');
subplot(2, 3, 6);
imagesc(obs.data{num_raters}(:, :, 1));
title('Example Worst Observation');

% print the accuracy levels to the screen
STAPLE_accuracy = fraction_correct(truth, STAPLE_estimate, obs, 'confusion');
COLLATE_accuracy = fraction_correct(truth, COLLATE_estimate, obs, 'confusion');

disp(['STAPLE Accuracy in Confusion Region: ', num2str(STAPLE_accuracy)]);
disp(['COLLATE Accuracy in Confusion Region: ', num2str(COLLATE_accuracy)]);

