% this script shows the STAPLE estimate overlayed on the slice compared to the
% true segmentation from an expert rater. Additionally, the error slice and
% the overall rater disagreement is plotted

% algorithm settings
epsilon = 0.001;
prior_flag = 0;
init_flag = 0;
cons_flag = 0;

%
% collect all of the data
%
sagittal_st_slice = 71;

% settings for the current data
sagittal_data_dir = '../example-data/cerebellum/sagittal/testing/obs/';
sagittal_truth_dir = '../example-data/cerebellum/sagittal/testing/truth/';

% load the truths
sagittal_truth = get_webmill_truth(sagittal_truth_dir);

% create the observation structs
sagittal_obs = create_obs('slice', size(sagittal_truth));

% get the filenames
sagittal_fnames = dir([sagittal_data_dir, '*.png']);

% load the observations
for i = 1:length(sagittal_fnames)
    sagittal_obs = add_webmill_obs(sagittal_obs, [sagittal_data_dir, ...
                                   sagittal_fnames(i).name], sagittal_st_slice);
end

% STAPLER (sagittal)
num_labels = length(unique(sagittal_truth))+1;
num_raters = length(unique(sagittal_obs.raters));
bias = zeros([num_labels, num_labels, num_raters]);
[SRZ_est SRZ_W SRZ_theta] = STAPLER(sagittal_obs, epsilon, ...
                                prior_flag, init_flag, cons_flag, bias);
[MV_est MV_W] = majority_vote(sagittal_obs);

r = 0.25;
orig_slice = '../example-data/cerebellum/slices/example-slice.png';
os = double(imread(orig_slice));
rgb = repmat(os, [1 1 3]) / max(os(:));

% set the colormap values
cmap = [0 0 0; 0 0 1; 0 1 0; 1 0 1; 1 0 0; 1 1 0];

figure(1);
subplot(2, 2, 1);
clr = double(ind2rgb(uint8(sagittal_truth(:, :, 1)), cmap));
imshow((r * clr + (1 - r) * rgb));

subplot(2, 2, 2);
clr = double(ind2rgb(uint8(SRZ_est(:, :, 1)), cmap));
imshow((r * clr + (1 - r) * rgb));

subplot(2, 2, 3);
err = (sagittal_truth(:, :, 1) ~= SRZ_est(:, :, 1));
imshow(err);
colormap([0 0 0; 1 1 1])
caxis([0 1]);

subplot(2, 2, 4);
imshow(1 - max(MV_W(:, :, 1, :), [], 4));
colormap(hot);
caxis([0 1]);

