clear all;
close all;

load braincolor_cmap

a = load_nii_gz('~/fs3-andrew/data/brain-reg/data/testing/atlas-labels/1002_3_glm.nii.gz');
ul = unique(a.img);

ul = [ul; 255];
cmap_orig_vals = [cmap_orig_vals; cmap_orig_vals(end, :)];

fid = fopen('~/braincolor.lut', 'w');
fprintf(fid, '<LUT>\n');
fprintf(fid, '%d\n', 255);
for i = 1:length(ul)-1
    for j = ul(i):(ul(i+1)-1)
        fprintf(fid, '%d\t1.0\t%f\t%f\t%f\n', j,  255*cmap_orig_vals(i, 1), ...
                                                  255*cmap_orig_vals(i, 2), ...
                                                  255*cmap_orig_vals(i, 3));
    end
end
fclose(fid);

