function run_cmd_cluster(cmds, memval, pbsout, txtout, varargin)
% RUN_CMD_CLUSTER - runs a collection of commands on the local cluster
%
% run_cmd_cluster(cmds, memval, pbsout, txtout)
%
% Input: cmds - the cell array of commands
%        memval - the amount of memory to allocate for the job
%               - Note: there are three values that can be set with this
%                       variable (mem_free, mem_token, and h_vmem).
%                       1) mem_free - the amount of memory needed to start job
%                       2) mem_token - amount to (virtually) allocate at start
%                       3) h_vmem - the absolute limit this job can use
%                                   (in terms of virtual memory) -
%                                   see the "VIRT" column in "top"
%               - As a result, can take on 4 different forms:
%                 1) a string - which results in:
%                             mem_free = memval;
%                             mem_token = memval;
%                             h_vmem = memval;
%                 2) a one element cell array
%                             mem_free = memval{1};
%                             mem_token = memval{1};
%                             h_vmem = memval{1};
%                 3) a two element cell array
%                             mem_free = memval{1};
%                             mem_token = memval{1};
%                             h_vmem = memval{2};
%                 4) a three element cell array
%                             mem_free = memval{1};
%                             mem_token = memval{3};
%                             h_vmem = memval{2};
%        pbsout - the name of the pbs file
%        txtout - the name of the txt file
%        queue - (optional) the cluster queue to run on (default: 'clusterjob')
%
% Output: (NONE)

queue = 'clusterjob';
if length(varargin) == 0;
    queue = 'clusterjob';
elseif length(varargin) == 1 && isstr(varargin{1})
    queue = varargin{1};
else
    error('Invalid input arguments to run_cmd_cluster.m');
end

if length(cmds) == 0
    return;
end

% set the memory values
memval_memfree = '';
memval_memtoken = '';
memval_hvmem = '';
if isstr(memval)
    memval_memfree = memval;
    memval_memtoken = memval;
    memval_hvmem = memval;
elseif iscell(memval)
    if length(memval) == 1
        memval_memfree = memval{1};
        memval_memtoken = memval{1};
        memval_hvmem = memval{1};
    elseif length(memval) == 2
        memval_memfree = memval{1};
        memval_memtoken = memval{1};
        memval_hvmem = memval{2};
    elseif length(memval) == 3
        memval_memfree = memval{1};
        memval_memtoken = memval{3};
        memval_hvmem = memval{2};
    else
        error('Invalid "memval" value');
    end
else
    error('Invalid "memval" value');
end

fid = fopen(pbsout,'w');
fprintf(fid, '#!/bin/bash\n');

% pbs settings
fprintf(fid, '#$ -q %s\n', queue);
fprintf(fid, '#$ -j y\n');
fprintf(fid, '#$ -cwd\n');
fprintf(fid, '#$ -o %s\n', txtout);
fprintf(fid, '#$ -l mem_free=%s\n', memval_memfree);
fprintf(fid, '#$ -l mem_token=%s\n', memval_memtoken);
fprintf(fid, '#$ -l h_vmem=%s\n\n', memval_hvmem);

fprintf(fid, 'uname -a\n');
for i = 1:length(cmds)
    fprintf(fid, '%s\n', cmds{i});
end

fclose(fid);

% submit the job
system(sprintf('qsub %s', pbsout));
