function est = SpatialSTAPLE_default(data)
% Function SpatialSTAPLE_default - runs a "default" implementation of the
%                                  SpatialSTAPLE algorithm
%
% est = SpatialSTAPLE_default(data)
%
% Input: data - a X x Y x Z x R matrix that contains the rater observations
%               at each voxel.
%               Note: the values of the matrix should be between 0 and L - 1
%                     where L is the number of labels.
%
% Output: est - the segmentation estimate from SpatialSTAPLE

% Spatial STAPLE settings
epsilon = 1e-4;
cons_flag = 2;
interp_type = 1;
overlap = 0.5;
win_frac = 0.1;
rho = 1;
init_flag = 0;

% input settings
dims = [size(data, 1), size(data, 2), size(data, 3)];
num_raters = size(data, 4);
num_labels = length(unique(data(:)));

% construct the observation struct
obs = create_obs('volume', dims);
for i = 1:num_raters
    obs = add_obs(obs, data(:, :, :, i));
end

% construct the prior
[MV_est prior] = log_odds_majority_vote(obs, rho);

% construct the Spatial STAPLE parameters
win_dims = [11 11 11];
delta = [ceil(win_dims(1) * (1 - overlap)), ...
         ceil(win_dims(2) * (1 - overlap)), ...
         ceil(win_dims(3) * (1 - overlap))];
num_up = [ceil((dims(1)-win_dims(1)) / delta(1))+1, ...
          ceil((dims(2)-win_dims(2)) / delta(2))+1, ...
          ceil((dims(3)-win_dims(3)) / delta(3))+1];
bias = 0.25 * prod(win_dims) / num_labels;

% run the Spatial STAPLE algorithm
[est SS_W SS_theta] = SpatialSTAPLE(obs, epsilon, prior, init_flag, ...
                                    cons_flag, interp_type, num_up, ...
                                    win_dims, bias);

