function [truthout obsout uniquelabels] = compress_label_nums(truth, obs)
% COMPRESS_LABEL_NUMS - reorders the label numbers to go from 0 to the number
%                       of possible labels minus 1.
%
% [truthout obsout uniquelabels] = compress_label_nums(truth, obs)
%
% Input: truth - the original true segmentation (uncompressed label numbers)
%        obs - the original observations (uncompressed)
%
% Output: truthout - the compressed true segmentation
%         obsout - the compressed observations
%         uniquelabels - the unique labels that were mapped
%                        uniquelabels(i) -> i-1.
%

% find the original unique labels labels
origlabels = unique(truth);
for i = 1:obs.num_obs
    origlabels = union(origlabels, unique(obs.data{i}));
end

% set the uniquelabels
uniquelabels = sort(origlabels);

% set the output truth and obs
truthout = truth;
obsout = obs;

% first do the truth
for s = 1:length(uniquelabels)
    truthout(truth == uniquelabels(s)) = s-1;
end

% now do the observations
for j = 1:obs.num_obs
    for s = 1:length(uniquelabels)
        obsout.data{j}(obs.data{j} == uniquelabels(s)) = s-1;
    end
end

