function [obs_slice] = convert_volume_to_slice_obs(obs_volume)
% CONVERT_VOLUME_TO_SLICE_OBS - converts a volume type observation struct into
%                               a slice type observation struct
%
% [obs_slice] = convert_volume_to_slice_obs(obs_volume)
%
% Input: obs_volume - the volume type observations
% Output: obs_slice - the slice type observations

obs_slice = create_obs('slice', obs_volume.dims);

for r = 1:obs_volume.num_obs
    for s = 1:obs_volume.dims(3)
        obs_slice = add_obs(obs_slice, obs_volume.data{r}(:, :, s), s, r);
    end
end

