function obsjava = create_java_obs(obs)
% CREATE_JAVA_OBS - create the java observation object
%
% obsjava = create_java_obs(obs)
%
% Input: obs - the observation struct
% Output: obsjava - the java obsevation object associated with that struct


% first check the type of observations
if strcmp(obs.type, 'slice')

    % get the data matrix
    data = zeros(obs.dims(1), obs.dims(2), obs.num_obs);
    for i = 1:obs.num_obs
        data(:, :, i) = obs.data{i};
    end
    data = int32(data);

    % get the slices array
    slices = int32(obs.slices-1);

    % get the raters array
    raters = int32(reorder_array(obs.raters));

    % get the dimensions array
    dims = int32(obs.dims);

    % create the java object
    obsjava = edu.vanderbilt.masi.LabelFusion.ObservationSlice(data, ...
                                                    slices, raters, dims);
elseif strcmp(obs.type, 'volume')

    % construct the data
    data = zeros([obs.dims, obs.num_obs]);
    for i = 1:obs.num_obs
        data(:, :, :, i) = obs.data{i};
    end
    data = int32(data);

    % construct the java object
    obsjava = edu.vanderbilt.masi.LabelFusion.ObservationVolume(data);

else

    error('Unknown observation type');

end


