function est = get_estimate_from_label_probabilities(W)
% GET_ESTIMATE_FROM_LABEL_PROBABILITIES - returns the volumetric estimate of the
%                                         true segmentation given the label
%                                         probabilities (W - in STAPLE notation)
%
% est = get_estimate_from_label_probabilities(W)
%
% Input: W - the label probabilities (X by Y by Z by L)
% Output: est - the true segmentation estimate
%

est = zeros([size(W, 1) size(W, 2) size(W, 3)]);
maxW = max(W, [], 4);
for s = 1:size(W, 4)
    est(W(:, :, :, s) == maxW) = s-1;
end
est = uint8(est);
