function truth = get_webmill_truth(truth_dir)
% GET_WEBMILL_TRUTH - Loads all of the images from a directory and constructs
%                     the true segmentation.
%                     Assumes that the slices are in alphanumerical order.
%
% truth = get_webmill_truth(truth_dir);
%
% Input: truth_dir - directory containing true png files
%
% Output: truth - the true segmentation volume

% get all of the filenames
fnames = dir([truth_dir, '/*.png']);

% get the dimensions of the images
num_slices = length(fnames);
im = imread([truth_dir, '/', fnames(1).name]);
dims = [size(im), num_slices];

% allocate space for the truth
truth = zeros(dims);

% load each slice
for i = 1:num_slices
    fname = [truth_dir, '/', fnames(i).name];
    im = imread(fname);
    truth(:, :, i) = im;
end

