function [meanjac jac uniquelabels] = jaccard(truth, estimate)
% JACCARD - calculate the Jaccard Index
%
% [meanjac jac uniquelabels] = jaccard(truth, estimate)
%
% Assumes: truth, estimate are the same dimension, orientation, etc...
%          only interested in the labels that are unique to the truth
% Input: truth - truth volume/vector/matrix
%        estimate - estimate volume/vector/matrix
%
% Output: meanjac - mean jaccard index
%         jac - JI value for each label
%         uniquelabels - the label numbers corresponding to 'jac'

% find the unique values in the truth
uniquelabels = unique(truth);

% calculate the jaccard index for each label
jac = zeros([length(uniquelabels) 1]);

% iterate over each unique value
for i = 1:length(uniquelabels)
    % get the value
    v = uniquelabels(i);

    % find where that value is in the truth
    inds1 = find(truth == v);

    % find where that value is in the estimate
    inds2 = find(estimate == v);

    % calculate the union for this label
    unon = union(inds1, inds2);

    % calculate the intersect for this label
    intsct = intersect(inds1, inds2);

    % calculate the jaccard index for this label
    jac(i) = length(intsct) / length(unon);
end

meanjac = mean(jac(2:end));


