function mi = mutualinfo(im1, im2, n, lperc, hperc)
% MUTUALINFO - calculates the mutual information between two images
%
% mi = mutualinfo(im1, im2, n, lperc, hperc)
%
% Input: im1 - the first image
%        im2 - the second image
%        n - the number of bins in the histogram
%        lperc - the lower percentile of intensities to keep
%        hperc - the higher percentile of intensities to keep
%
% Output: mi - the calculated mutual information
%

im1 = im1(:);
im2 = im2(:);
im1 = (im1 - min(im1)) / (max(im1) - min(im1));
im2 = (im2 - min(im2)) / (max(im2) - min(im2));

inds1 = find(im1 >= lperc & im1 <= hperc & im2 >= lperc & im2 <= hperc);
im1 = im1(inds1);
im2 = im2(inds1);
im1(im1 == hperc) = hperc - 0.0001;
im2(im2 == hperc) = hperc - 0.0001;

x = linspace(lperc, hperc, n+1);
pa = zeros([1 n]);
pb = zeros([1 n]);
pab = zeros([n n]);

for i = 1:n
    for j = 1:n
        pab(i, j) = length(find(im1 >= x(i) & im1 < x(i+1) & ...
                                im2 >= x(j) & im2 < x(j+1)));
    end
    pa(i) = length(find(im1 >= x(i) & im1 < x(i+1)));
    pb(i) = length(find(im2 >= x(i) & im2 < x(i+1)));
end
pa = pa / sum(pa);
pb = pb / sum(pb);
pab = pab / sum(pab(:));

xx = pab .* log(pab ./ (pa'*pb));
xx(xx*0 ~= 0) = 0;
mi = sum(xx(:));

