function plot_probability_overlay(im, seg, alpha, cmap, intlim, plim, sl);
% PLOT_PROBABILITY_OVERLAY - plots a segmented image overlayed with the
%                             raw image (uses the current figure)
%
% plot_probability_overlay(im, seg, alpha, cmap, intlim, plim, sl)
%
% Input: im - the raw image (a volume)
%        seg - the probability image (again, a volume)
%        alpha - number between 0 and 1
%                0 => all raw image
%                1 => all segmented image
%        cmap - the colormap to use
%        intlim - intensity limits for grayscale transformation
%        plim - the range of intensities to display
%        sl - the slice to visualize
%
% Output: NONE
%

max_label_num = max(seg(:));
im = double(im);
seg = double(seg);
mi = min(im(:));
mx = max(im(:));
im = im(:, :, sl);
seg = seg(:, :, sl);

% fix the intensity limits
intlim(intlim < 0) = 0;
intlim(intlim > 1) = 1;

% convert the raw image to an rgb image
xl = mi + intlim(1) * (mx - mi);
xh = mi + intlim(2) * (mx - mi);
im(im < xl) = xl;
im(im > xh) = xh;
im = (im - xl) / (xh - xl);
rgb = repmat(im, [1 1 3]);

% resample the probability
num = 10000;
seg(seg < plim(1)) = plim(1);
seg(seg > plim(2)) = plim(2);
seg = (seg - plim(1)) / (plim(2) - plim(1));
seg = round(seg * num);

% resample the colormap
xo = 1:size(cmap, 1);
xi = linspace(1, size(cmap, 1), num);
cmap2 = interp1(xo, cmap, xi);

% convert the segmented image to an rgb image
clr = double(ind2rgb(seg, cmap2));

% create the overlay image
overlayim = rgb;
inds = find(seg > 0);
for ch = 1:3
    rgbch = rgb(:, :, ch);
    overlaych = overlayim(:, :, ch);
    clrch = clr(:, :, ch);
    overlaych(inds) = alpha * clrch(inds) + (1 - alpha) * rgbch(inds);
    overlayim(:, :, ch) = overlaych;
end

% plot it
imagesc(overlayim);
axis equal;
axis off;

