function varargout = edge3_fwb(im, thresholds,filterprops)
% CANNY3D - a simple function to detect edges in a 3D matrix
%   Format: final = canny3D(im, filterprops, thresholds)
%   
% arguments:
%   im - 3D matrx
%   filterprops - 2x1 array of Gaussian filter properties [size sigma]        
%       size - filter size (diameter) in voxels (default: 5)
%       sigma - standard dev of Gaussian filter size (default: 2)
%       + can also put string 'nofilter' for no filtering (maybe already done?)
%   thresholds - 2x1 array of edge thresholds [uppper lower]
%       upper - upper filter boundary 
%       lower - lower filter boundary 
%
%   If th_up and th_low aren't chosen, they are set automatically
%-------------------------------------------------------------------------%

%-------------------------------------------------------------------------%
%   Created by:
%   University of Illinois at Urbana Champaign
%   Department of Mechanical Science and Engineering
%   Laboratory of Photonics Research on Bio/Nano Environment
%   Written by : Tung Yuen Lau
%   Advisor: Prof. Kimani Toussaint
%   Start date: FEB 16 2012
%      
%   Modified by: Frederick Bryan, Vanderbilt, July 2013
%-------------------------------------------------------------------------%


% account for optional vars
if nargin < 3 || ~isequal(size(filterprops), [1 2]);
    filterprops = [5 2];
end
if nargin < 2 || ~isequal(size(thresholds), [1 2]);
    thresholds = 'auto'; 
end


% cast so that math works
im = double(im);

% determine if filtering required
if strcmp(filterprops,'nofilter')
    imfil = im;
else
    filsize = filterprops(1);
    sigma = filterprops(2);

    % Gaussian filter
    hfil = floor(filsize/2);
    [x y z] = meshgrid(-hfil:hfil,-hfil:hfil,-hfil:hfil);
    fil_x = exp(-x.^2/(2*sigma^2))./(sigma*sqrt(2*pi)); clear x;
    fil_y = exp(-y.^2/(2*sigma^2))./(sigma*sqrt(2*pi)); clear y;
    fil_z = exp(-z.^2/(2*sigma^2))./(sigma*sqrt(2*pi)); clear z;
    f = fil_x .* fil_y .* fil_z; clear fil_x; clear fil_y; clear fil_z;
    f = f/sum(abs(f(:)));
    imfil = imfilter(im,f,'replicate'); %clear f; clear im;
end

% find xyz gradients (could be re-implemented using sobel, but why?)
[imfil_x , imfil_y, imfil_z] = gradient(imfil); %clear imfil;

% Thinning (non-maximum suppression)
im_thin = nonmax_sup(imfil_x,imfil_y,imfil_z);

% find magnitude
imfil_mag = sqrt(imfil_x.^2+imfil_y.^2+imfil_z.^2);

% threshold
im_sub = hysteresis(im_thin,imfil_mag,thresholds);

% output
varargout{1} = im_sub;

if nargout == 2; 
    varargout{2} = imfil_mag; % probablistc thing
end



