function render_3D_truth_label(truth, fignum, res_dims)
% RENDER_3D_TRUTH - renders a 3D representation of a segmentation
%
% render_3D_truth(truth, fignum, res_dims)
%
% Input: truth - the true segmentation
%        fignum - the figure number to show the result
%        res_dims - the resolution of the X Y Z dimensions
%
% Output: None

iso0 = isosurface(truth == 1);
iso1 = isosurface(truth == 2);

num0 = size(iso0.vertices, 1);
num = size(iso1.vertices, 1);

figure(fignum); clf;
p0 = patch('Vertices', iso0.vertices, ...
           'Faces', iso0.faces, ...
           'FaceVertexCData', repmat([0.5 0.5 0.5], [num0 1]), ...
           'FaceColor', 'interp', ...
           'EdgeColor', 'none', ...
           'FaceAlpha', 0.3);
hold on;
p2 = patch('Vertices', iso1.vertices, ...
           'Faces', iso1.faces, ...
           'FaceVertexCData', repmat([1 0 1], [num 1]), ...
           'FaceColor', 'interp', ...
           'EdgeColor', 'none');
hold off;
daspect(1 ./ res_dims);
view(90, 60);
camlight;
lighting phong;
set(gca, 'Visible', 'off')

